/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.CommonUtils;
import codechicken.core.IStringMatcher;
import codechicken.core.asm.ASMHelper;
import codechicken.core.asm.CodeChickenCorePlugin;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.relauncher.RelaunchLibraryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.tree.ClassNode;

public class ClassDiscoverer {
    public IStringMatcher matcher;
    public String[] superclasses;
    public ArrayList classes;
    public ModClassLoader modClassLoader;

    public ClassDiscoverer(IStringMatcher matcher, Class ... superclasses) {
        this.matcher = matcher;
        this.superclasses = new String[superclasses.length];
        int i = 0;
        while (i < superclasses.length) {
            this.superclasses[i] = superclasses[i].getName().replace('.', '/');
            ++i;
        }
        this.classes = new ArrayList();
        this.modClassLoader = (ModClassLoader)Loader.instance().getModClassLoader();
    }

    public ClassDiscoverer(Class ... superclasses) {
        this(new IStringMatcher(){

            @Override
            public boolean matches(String test) {
                return true;
            }
        }, superclasses);
    }

    public ArrayList findClasses() {
        try {
            this.findClasspathMods();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.classes;
    }

    private void checkAddClass(String resource) {
        try {
            String classname = resource.replace(".class", "").replace("\\", ".").replace("/", ".");
            byte[] bytes = CodeChickenCorePlugin.cl.getClassBytes(classname);
            if (bytes == null) {
                return;
            }
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            String[] stringArray = this.superclasses;
            int n = this.superclasses.length;
            int n2 = 0;
            while (n2 < n) {
                String superclass = stringArray[n2];
                if (!cnode.interfaces.contains(superclass) && !cnode.superName.equals(superclass)) {
                    return;
                }
                ++n2;
            }
            this.addClass(classname);
        }
        catch (IOException e) {
            System.err.println("Unable to load class: " + resource);
            e.printStackTrace();
        }
    }

    private void addClass(String classname) {
        try {
            Class<?> class1 = Class.forName(classname, true, (ClassLoader)this.modClassLoader);
            this.classes.add(class1);
        }
        catch (Exception cnfe) {
            System.err.println("Unable to load class: " + classname);
            cnfe.printStackTrace();
        }
    }

    private void findClasspathMods() {
        ImmutableList knownLibraries = ImmutableList.builder().addAll((Iterable)this.modClassLoader.getDefaultLibraries()).addAll((Iterable)RelaunchLibraryManager.getLibraries()).build();
        File[] minecraftSources = this.modClassLoader.getParentSources();
        HashSet<String> searchedSources = new HashSet<String>();
        File[] fileArray = minecraftSources;
        int n = minecraftSources.length;
        int n2 = 0;
        while (n2 < n) {
            File minecraftSource = fileArray[n2];
            if (!searchedSources.contains(minecraftSource.getAbsolutePath())) {
                searchedSources.add(minecraftSource.getAbsolutePath());
                if (minecraftSource.isFile()) {
                    if (!knownLibraries.contains(minecraftSource.getName())) {
                        FMLLog.fine((String)"Found a minecraft related file at %s, examining for codechicken classes", (Object[])new Object[]{minecraftSource.getAbsolutePath()});
                        try {
                            this.readFromZipFile(minecraftSource);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to scan " + minecraftSource.getAbsolutePath() + ", the zip file is invalid");
                            e.printStackTrace();
                        }
                    }
                } else if (minecraftSource.isDirectory()) {
                    FMLLog.fine((String)"Found a minecraft related directory at %s, examining for codechicken classes", (Object[])new Object[]{minecraftSource.getAbsolutePath()});
                    this.readFromDirectory(minecraftSource, minecraftSource);
                }
            }
            ++n2;
        }
    }

    private void readFromZipFile(File file) throws IOException {
        ZipEntry zipentry;
        FileInputStream fileinputstream = new FileInputStream(file);
        ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
        while ((zipentry = zipinputstream.getNextEntry()) != null) {
            String name;
            String fullname = zipentry.getName().replace('\\', '/');
            int pos = fullname.lastIndexOf(47);
            String string = name = pos == -1 ? fullname : fullname.substring(pos + 1);
            if (zipentry.isDirectory() || !this.matcher.matches(name)) continue;
            this.checkAddClass(fullname);
        }
        fileinputstream.close();
    }

    private void readFromDirectory(File directory, File basedirectory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                this.readFromDirectory(child, basedirectory);
            } else if (child.isFile() && this.matcher.matches(child.getName())) {
                String fullname = CommonUtils.getRelativePath(basedirectory, child);
                this.checkAddClass(fullname);
            }
            ++n2;
        }
    }
}

