/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.energy;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.util.MathHelper;
import java.util.logging.Level;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.util.energy.IPowerProviderAdv;

public class PowerProviderTesseract
extends PowerProvider
implements IPowerProviderAdv {
    public static float energyFactor = 0.8f;
    public static float energyRequest = 1.0f / energyFactor;
    public static int energyMax = 100;

    public PowerProviderTesseract() {
        this.powerLoss = 0;
        this.powerLossRegularity = 72000;
        this.configure(energyMax, energyMax);
    }

    public void configure(int maxEnergyReceived, int maxStoredEnergy) {
        super.configure(0, 2, MathHelper.ceil((double)((float)maxEnergyReceived * energyRequest)), 0, maxStoredEnergy);
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        return false;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.energyStored += (quantity *= energyFactor);
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void addEnergy(float quantity) {
        this.energyStored += quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void subtractEnergy(float quantity) {
        this.energyStored -= quantity;
        if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void setEnergyStored(float quantity) {
        this.energyStored = quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void roundEnergyStored() {
        this.energyStored = MathHelper.round((double)this.energyStored);
    }

    @Override
    public int powerRequest() {
        if (this.energyStored >= (float)this.maxEnergyStored) {
            return 0;
        }
        return MathHelper.ceil((double)MathHelper.minF((float)this.maxEnergyReceived, (float)(((float)this.maxEnergyStored - this.energyStored) * energyRequest)));
    }

    static {
        int tweakTesseractEnergyLoss = 20;
        tweakTesseractEnergyLoss = ThermalExpansion.config.get("tweak", "Tesseract.Energy.Loss", tweakTesseractEnergyLoss);
        energyMax = ThermalExpansion.config.get("tweak", "Tesseract.Energy.MaxTransfer", energyMax);
        if (tweakTesseractEnergyLoss >= 0 && tweakTesseractEnergyLoss < 100) {
            energyFactor = 1.0f - (float)tweakTesseractEnergyLoss / 100.0f;
            energyRequest = 1.0f / energyRequest;
        } else {
            ThermalExpansion.log.log(Level.INFO, "The configuration value for 'Tesseract.Energy.Loss' is invalid. Setting to Default. (20)");
        }
        if (energyMax > 1000) {
            energyMax = 1000;
            ThermalExpansion.log.log(Level.INFO, "The configuration value for 'Tesseract.Energy.MaxTransfer' is too high. Setting to Maximum. (1000)");
        } else if (energyMax <= 0) {
            energyMax = 100;
            ThermalExpansion.log.log(Level.INFO, "The configuration value for 'Tesseract.Energy.MaxTransfer' is too low. Setting to Default. (100)");
        }
    }
}

