/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.energy;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.util.energy.IPowerProviderAdv;

public class PowerProviderAdv
extends PowerProvider
implements IPowerProviderAdv {
    public PowerProviderAdv() {
        this.powerLoss = 0;
        this.powerLossRegularity = 72000;
        this.configure(0, 0);
    }

    public void configure(int maxEnergyReceived, int maxStoredEnergy) {
        super.configure(0, 2, maxEnergyReceived, 0, maxStoredEnergy);
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        return false;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.energyStored += quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void addEnergy(float quantity) {
        this.energyStored += quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void subtractEnergy(float quantity) {
        this.energyStored -= quantity;
        if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void setEnergyStored(float quantity) {
        this.energyStored = quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void roundEnergyStored() {
        this.energyStored = MathHelper.round((double)this.energyStored);
    }

    @Override
    public int powerRequest() {
        if (this.energyStored == (float)this.maxEnergyStored) {
            return 0;
        }
        return MathHelper.ceil((double)MathHelper.minF((float)this.maxEnergyReceived, (float)((float)this.maxEnergyStored - this.energyStored)));
    }
}

