/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.ISmelterManager;
import thermalexpansion.api.crafting.ISmelterRecipe;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.item.TEItems;

public class SmelterManager
implements ISmelterManager {
    public static int bronzeAmount = 2;
    public static ItemStack blockSand;
    public static ItemStack itemIngotIron;
    public static ItemStack itemIngotGold;
    private static SmelterManager instance;
    private static boolean initialized;
    private static boolean allowOverwrite;
    private static Map recipeMap;
    private static List recipeList;
    private static Set validationSet;

    public static ISmelterManager getInstance() {
        return instance;
    }

    public static void allowOverwrite() {
        if (!initialized) {
            initialized = true;
            allowOverwrite = true;
        }
    }

    public static void denyOverwrite() {
        initialized = true;
        allowOverwrite = false;
    }

    public static SmelterRecipe getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return null;
        }
        SmelterRecipe recipe = (SmelterRecipe)recipeMap.get(Arrays.asList(primaryInput.field_77993_c, primaryInput.func_77960_j(), secondaryInput.field_77993_c, secondaryInput.func_77960_j()));
        if (recipe == null) {
            recipe = (SmelterRecipe)recipeMap.get(Arrays.asList(secondaryInput.field_77993_c, secondaryInput.func_77960_j(), primaryInput.field_77993_c, primaryInput.func_77960_j()));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return true;
        }
        SmelterRecipe recipe = (SmelterRecipe)recipeMap.get(Arrays.asList(primaryInput.field_77993_c, primaryInput.func_77960_j(), secondaryInput.field_77993_c, secondaryInput.func_77960_j()));
        return recipe != null || (recipe = (SmelterRecipe)recipeMap.get(Arrays.asList(secondaryInput.field_77993_c, secondaryInput.func_77960_j(), primaryInput.field_77993_c, primaryInput.func_77960_j()))) != null;
    }

    public static boolean isItemValid(ItemStack input) {
        if (input == null) {
            return false;
        }
        return validationSet.contains(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static void initialize() {
        CraftingManagers.smelterManager = new SmelterManager();
        SmelterManager.getInstance().addRecipe(400, new ItemStack(Block.field_72012_bb, 4), new ItemStack(Block.field_72013_bc), new ItemStack(Block.field_72033_bA, 2), TEItems.crystalSulfur, 25, false);
    }

    public static void loadRecipes() {
        ItemStack blockGlass = new ItemStack(TEBlocks.blockGlass, 2, 0);
        SmelterManager.addAlloyRecipe(400, "ingotLead", 1, "dustObsidian", 2, blockGlass);
        SmelterManager.addAlloyRecipe(400, "dustLead", 1, "dustObsidian", 2, blockGlass);
        SmelterManager.addDefaultOreDictionaryRecipe("oreIron", "dustIron", itemIngotIron);
        SmelterManager.addDefaultOreDictionaryRecipe("oreGold", "dustGold", itemIngotGold);
        SmelterManager.addDefaultOreDictionaryRecipe("oreCopper", "dustCopper", TEItems.ingotCopper);
        SmelterManager.addDefaultOreDictionaryRecipe("oreTin", "dustTin", TEItems.ingotTin);
        SmelterManager.addDefaultOreDictionaryRecipe("oreSilver", "dustSilver", TEItems.ingotSilver);
        SmelterManager.addDefaultOreDictionaryRecipe("oreLead", "dustLead", TEItems.ingotLead);
        SmelterManager.addDefaultOreDictionaryRecipe("oreNickel", "dustNickel", TEItems.ingotNickel);
        SmelterManager.addDefaultOreDictionaryRecipe("orePlatinum", "dustPlatinum", TEItems.ingotPlatinum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustElectrum", TEItems.ingotElectrum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustInvar", TEItems.ingotInvar);
        ItemStack ingot = TEItems.ingotElectrum.func_77946_l();
        ingot.field_77994_a = 2;
        SmelterManager.addAlloyRecipe(240, "ingotSilver", 1, "ingotGold", 1, ingot);
        ingot = TEItems.ingotInvar.func_77946_l();
        ingot.field_77994_a = 3;
        SmelterManager.addAlloyRecipe(240, "ingotNickel", 1, "ingotIron", 2, ingot);
        if (!OreDictionary.getOres((String)"ingotBronze").isEmpty()) {
            ItemStack ingotBronze = ((ItemStack)OreDictionary.getOres((String)"ingotBronze").get(0)).func_77946_l();
            SmelterManager.addDefaultOreDictionaryRecipe(null, "dustBronze", ingotBronze);
            ingotBronze.field_77994_a = bronzeAmount;
            SmelterManager.addAlloyRecipe(240, "ingotCopper", 3, "ingotTin", 1, ingotBronze);
        }
        if (!OreDictionary.getOres((String)"ingotBrass").isEmpty()) {
            ItemStack ingotBrass = ((ItemStack)OreDictionary.getOres((String)"ingotBrass").get(0)).func_77946_l();
            SmelterManager.addDefaultOreDictionaryRecipe(null, "dustBrass", ingotBrass);
        }
        if (!OreDictionary.getOres((String)"ingotZinc").isEmpty()) {
            ItemStack ingotZinc = ((ItemStack)OreDictionary.getOres((String)"ingotZinc").get(0)).func_77946_l();
            SmelterManager.addDefaultOreDictionaryRecipe("oreZinc", "dustZinc", ingotZinc);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot) {
        if (ingot == null) {
            return;
        }
        ItemStack ingot2 = ingot.func_77946_l();
        ItemStack ingot3 = ingot.func_77946_l();
        ingot2.field_77994_a = 2;
        ingot3.field_77994_a = 3;
        if (oreName != null) {
            SmelterManager.addOreToIngotRecipe(oreName, ingot2, ingot3);
        }
        if (dustName != null) {
            SmelterManager.addDustToIngotRecipe(dustName, ingot2);
        }
    }

    private static void addOreToIngotRecipe(String oreName, ItemStack ingot2, ItemStack ingot3) {
        ArrayList registeredOres = OreDictionary.getOres((String)oreName);
        for (int i = 0; i < registeredOres.size(); ++i) {
            SmelterManager.addTERecipe(320, (ItemStack)registeredOres.get(i), blockSand, ingot2, TEItems.slagRich, 5);
            SmelterManager.addTERecipe(400, (ItemStack)registeredOres.get(i), TEItems.slagRich, ingot3, TEItems.slag, 75);
        }
    }

    private static void addDustToIngotRecipe(String dustName, ItemStack ingot2) {
        ArrayList registeredOres = OreDictionary.getOres((String)dustName);
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack dust = ((ItemStack)registeredOres.get(i)).func_77946_l();
            dust.field_77994_a = 2;
            SmelterManager.addTERecipe(80, dust, blockSand, ingot2, TEItems.slag, 25);
        }
    }

    public static void addAlloyRecipe(int energy, String primaryOreName, int primaryAmount, String secondaryOreName, int secondaryAmount, ItemStack primaryOutput) {
        ArrayList primaryOreList = OreDictionary.getOres((String)primaryOreName);
        ArrayList secondaryOreList = OreDictionary.getOres((String)secondaryOreName);
        for (int i = 0; i < primaryOreList.size(); ++i) {
            ItemStack primaryInput = ((ItemStack)primaryOreList.get(i)).func_77946_l();
            primaryInput.field_77994_a = primaryAmount;
            for (int j = 0; j < secondaryOreList.size(); ++j) {
                ItemStack secondaryInput = ((ItemStack)secondaryOreList.get(j)).func_77946_l();
                secondaryInput.field_77994_a = secondaryAmount;
                SmelterManager.addAlloyRecipe(energy, primaryInput, secondaryInput, primaryOutput);
            }
        }
    }

    private static void addAlloyRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        SmelterManager.addTERecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static boolean addTERecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return instance.addInternalRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance);
    }

    private boolean addInternalRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        SmelterRecipe recipe;
        if (primaryInput == null || secondaryInput == null || energy <= 0) {
            return false;
        }
        if (SmelterManager.recipeExists(primaryInput, secondaryInput)) {
            recipe = SmelterManager.getRecipe(primaryInput, secondaryInput);
            recipeList.remove(recipe);
        }
        recipe = new SmelterRecipe(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(primaryInput.field_77993_c, primaryInput.func_77960_j(), secondaryInput.field_77993_c, secondaryInput.func_77960_j()), recipe);
        recipeList.add(recipe);
        validationSet.add(Arrays.asList(primaryInput.field_77993_c, primaryInput.func_77960_j()));
        validationSet.add(Arrays.asList(secondaryInput.field_77993_c, secondaryInput.func_77960_j()));
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, boolean overwrite) {
        return SmelterManager.getInstance().addRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0, overwrite);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, boolean overwrite) {
        return SmelterManager.getInstance().addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100, overwrite);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        SmelterRecipe recipe;
        if (primaryInput == null || secondaryInput == null || energy <= 0) {
            return false;
        }
        if (SmelterManager.recipeExists(primaryInput, secondaryInput)) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                recipe = SmelterManager.getRecipe(primaryInput, secondaryInput);
                recipeList.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "An Induction Smelter recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite an Induction Smelter recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        recipe = new SmelterRecipe(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(primaryInput.field_77993_c, primaryInput.func_77960_j(), secondaryInput.field_77993_c, secondaryInput.func_77960_j()), recipe);
        recipeList.add(recipe);
        validationSet.add(Arrays.asList(primaryInput.field_77993_c, primaryInput.func_77960_j()));
        validationSet.add(Arrays.asList(secondaryInput.field_77993_c, secondaryInput.func_77960_j()));
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return this.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, false);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return this.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, false);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return this.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, false);
    }

    @Override
    public ISmelterRecipe[] getRecipeList() {
        return recipeList.toArray(new SmelterRecipe[0]);
    }

    static {
        if (ThermalExpansion.config.get("tweak.craftinghandlers", "Smelter.Override", false)) {
            SmelterManager.allowOverwrite();
        } else {
            SmelterManager.denyOverwrite();
        }
        bronzeAmount = ThermalExpansion.config.get("tweak", "Smelter.Bronze.Amount", bronzeAmount);
        if (bronzeAmount < 1 || bronzeAmount > 4) {
            ThermalExpansion.log.log(Level.INFO, "'Smelter.Bronze.Amount' config value is out of acceptable range. Using default.");
            bronzeAmount = 2;
        }
        blockSand = new ItemStack(Block.field_71939_E);
        itemIngotIron = new ItemStack(Item.field_77703_o);
        itemIngotGold = new ItemStack(Item.field_77717_p);
        instance = new SmelterManager();
        recipeMap = new HashMap();
        recipeList = new ArrayList();
        validationSet = new HashSet();
    }

    public class SmelterRecipe
    implements ISmelterRecipe {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        SmelterRecipe(ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        @Override
        public ItemStack getPrimaryInput() {
            return this.primaryInput.func_77946_l();
        }

        @Override
        public ItemStack getSecondaryInput() {
            return this.secondaryInput.func_77946_l();
        }

        @Override
        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        @Override
        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        @Override
        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

