/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.IPulverizerManager;
import thermalexpansion.api.crafting.IPulverizerRecipe;
import thermalexpansion.item.TEItems;

public class PulverizerManager
implements IPulverizerManager {
    private static PulverizerManager instance;
    private static boolean initialized;
    private static boolean allowOverwrite;
    private static Map recipeMap;
    private static List recipeList;

    public static IPulverizerManager getInstance() {
        return instance;
    }

    public static void allowOverwrite() {
        if (!initialized) {
            initialized = true;
            allowOverwrite = true;
        }
    }

    public static void denyOverwrite() {
        initialized = true;
        allowOverwrite = false;
    }

    public static PulverizerRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return (PulverizerRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static boolean recipeExists(ItemStack input) {
        if (input == null) {
            return true;
        }
        PulverizerRecipe recipe = (PulverizerRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        return recipe != null;
    }

    public static void initialize() {
        CraftingManagers.pulverizerManager = new PulverizerManager();
        boolean recipeSandstone = ThermalExpansion.config.get("tweak", "Pulverizer.Sandstone", true);
        boolean recipeNetherrack = ThermalExpansion.config.get("tweak", "Pulverizer.Netherrack", true);
        boolean recipeWool = ThermalExpansion.config.get("tweak", "Pulverizer.Wool", false);
        boolean recipeReed = ThermalExpansion.config.get("tweak", "Pulverizer.Reed", true);
        boolean recipeBone = ThermalExpansion.config.get("tweak", "Pulverizer.Bone", true);
        boolean recipeBlazeRod = ThermalExpansion.config.get("tweak", "Pulverizer.BlazeRod", true);
        PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71981_t), new ItemStack(Block.field_71978_w));
        PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71978_w), new ItemStack(Block.field_71939_E), new ItemStack(Block.field_71940_F), 10);
        PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71940_F), new ItemStack(Item.field_77804_ap));
        PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71946_M), new ItemStack(Block.field_71939_E));
        PulverizerManager.getInstance().addRecipe(80, new ItemStack(Block.field_72007_bm), new ItemStack(Block.field_72007_bm, 1, 2));
        if (recipeSandstone) {
            ItemStack sand2 = new ItemStack(Block.field_71939_E, 2);
            PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71957_Q, 1, 0), sand2, TEItems.crystalNiter, 10);
            PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71957_Q, 1, 1), sand2, TEItems.crystalNiter, 10);
            PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_71957_Q, 1, 2), sand2, TEItems.crystalNiter, 10);
        }
        PulverizerManager.getInstance().addRecipe(400, new ItemStack(Block.field_72089_ap), TEItems.dustObsidian);
        if (recipeNetherrack) {
            PulverizerManager.getInstance().addRecipe(320, new ItemStack(Block.field_72012_bb), new ItemStack(Block.field_71978_w), TEItems.crystalSulfur, 10);
        }
        PulverizerManager.getInstance().addRecipe(240, new ItemStack(Block.field_71950_I), new ItemStack(Item.field_77705_m, 2, 0));
        PulverizerManager.getInstance().addRecipe(240, new ItemStack(Block.field_72073_aw), new ItemStack(Item.field_77702_n, 2, 0));
        PulverizerManager.getInstance().addRecipe(240, new ItemStack(Block.field_72068_bR), new ItemStack(Item.field_77817_bH, 2, 0));
        PulverizerManager.getInstance().addRecipe(80, new ItemStack(Block.field_72014_bd), new ItemStack(Item.field_77751_aT, 4));
        PulverizerManager.getInstance().addRecipe(240, new ItemStack(Block.field_71947_N), new ItemStack(Item.field_77756_aW, 8, 4));
        PulverizerManager.getInstance().addRecipe(240, new ItemStack(Block.field_72047_aN), new ItemStack(Item.field_77767_aC, 8));
        PulverizerManager.getInstance().addRecipe(160, new ItemStack(Block.field_71951_J, 1, 0), TEItems.woodchips);
        PulverizerManager.getInstance().addRecipe(160, new ItemStack(Block.field_71951_J, 1, 1), TEItems.woodchips);
        PulverizerManager.getInstance().addRecipe(160, new ItemStack(Block.field_71951_J, 1, 2), TEItems.woodchips);
        PulverizerManager.getInstance().addRecipe(160, new ItemStack(Block.field_71951_J, 1, 3), TEItems.woodchips);
        if (recipeWool) {
            ItemStack string = new ItemStack(Item.field_77683_K);
            for (int i = 0; i < 16; ++i) {
                PulverizerManager.getInstance().addRecipe(160, new ItemStack(Block.field_72101_ab, 1, i), string);
            }
        }
        if (recipeReed) {
            PulverizerManager.getInstance().addRecipe(80, new ItemStack(Item.field_77758_aJ), new ItemStack(Item.field_77747_aY, 2));
        }
        if (recipeBone) {
            PulverizerManager.getInstance().addRecipe(160, new ItemStack(Item.field_77755_aX), new ItemStack(Item.field_77756_aW, 6, 15));
        }
        if (recipeBlazeRod) {
            PulverizerManager.getInstance().addRecipe(160, new ItemStack(Item.field_77731_bo), new ItemStack(Item.field_77722_bw, 4), TEItems.crystalSulfur, 50);
        }
    }

    public static void loadRecipes() {
        int i;
        boolean recipeIngotsToDusts = ThermalExpansion.config.get("tweak", "Pulverizer.IngotsToDust", true);
        ItemStack dustZinc = null;
        if (!OreDictionary.getOres((String)"dustZinc").isEmpty()) {
            dustZinc = (ItemStack)OreDictionary.getOres((String)"dustZinc").get(0);
        }
        PulverizerManager.addOreToDustRecipe(400, "oreIron", TEItems.dustIron, TEItems.dustNickel, 10);
        PulverizerManager.addOreToDustRecipe(400, "oreGold", TEItems.dustGold, null, 0);
        PulverizerManager.addOreToDustRecipe(400, "oreCopper", TEItems.dustCopper, TEItems.dustGold, 10);
        PulverizerManager.addOreToDustRecipe(400, "oreTin", TEItems.dustTin, TEItems.dustIron, 10);
        PulverizerManager.addOreToDustRecipe(400, "oreSilver", TEItems.dustSilver, TEItems.dustLead, 10);
        PulverizerManager.addOreToDustRecipe(400, "oreLead", TEItems.dustLead, TEItems.dustSilver, 10);
        PulverizerManager.addOreToDustRecipe(400, "oreNickel", TEItems.dustNickel, TEItems.dustPlatinum, 10);
        PulverizerManager.addOreToDustRecipe(400, "orePlatinum", TEItems.dustPlatinum, null, 0);
        PulverizerManager.addOreToDustRecipe(400, "oreZinc", dustZinc, null, 0);
        if (recipeIngotsToDusts) {
            PulverizerManager.addIngotToDustRecipe(240, "ingotIron", TEItems.dustIron);
            PulverizerManager.addIngotToDustRecipe(240, "ingotGold", TEItems.dustGold);
            PulverizerManager.addIngotToDustRecipe(240, "ingotCopper", TEItems.dustCopper);
            PulverizerManager.addIngotToDustRecipe(240, "ingotTin", TEItems.dustTin);
            PulverizerManager.addIngotToDustRecipe(240, "ingotSilver", TEItems.dustSilver);
            PulverizerManager.addIngotToDustRecipe(240, "ingotLead", TEItems.dustLead);
            PulverizerManager.addIngotToDustRecipe(240, "ingotNickel", TEItems.dustNickel);
            PulverizerManager.addIngotToDustRecipe(240, "ingotPlatinum", TEItems.dustPlatinum);
            PulverizerManager.addIngotToDustRecipe(240, "ingotElectrum", TEItems.dustElectrum);
            PulverizerManager.addIngotToDustRecipe(240, "ingotInvar", TEItems.dustInvar);
            PulverizerManager.addIngotToDustRecipe(240, "ingotBronze", TEItems.dustBronze);
            PulverizerManager.addIngotToDustRecipe(240, "ingotBrass", TEItems.dustBrass);
            PulverizerManager.addIngotToDustRecipe(240, "ingotZinc", dustZinc);
        }
        ItemStack dustCharcoal = null;
        ItemStack dustCoal = null;
        ItemStack dustSulfur = null;
        ItemStack dustSaltpeter = null;
        ArrayList registeredOres = OreDictionary.getOres((String)"logWood");
        if (!registeredOres.isEmpty()) {
            for (i = 0; i < registeredOres.size(); ++i) {
                PulverizerManager.getInstance().addRecipe(160, (ItemStack)registeredOres.get(i), TEItems.woodchips);
            }
        }
        if (!(registeredOres = OreDictionary.getOres((String)"dustCoal")).isEmpty()) {
            dustCoal = ((ItemStack)registeredOres.get(0)).func_77946_l();
            dustCoal.field_77994_a = 1;
            PulverizerManager.getInstance().addRecipe(160, new ItemStack(Item.field_77705_m), dustCoal);
        }
        if (!(registeredOres = OreDictionary.getOres((String)"dustCharcoal")).isEmpty()) {
            dustCharcoal = ((ItemStack)registeredOres.get(0)).func_77946_l();
            dustCharcoal.field_77994_a = 1;
            PulverizerManager.getInstance().addRecipe(160, new ItemStack(Item.field_77705_m, 1, 1), dustCharcoal);
        }
        if (!(registeredOres = OreDictionary.getOres((String)"dustSulfur")).isEmpty()) {
            dustSulfur = ((ItemStack)registeredOres.get(0)).func_77946_l();
            dustSulfur.field_77994_a = 6;
        }
        registeredOres = OreDictionary.getOres((String)"oreSulfur");
        if (dustSulfur != null) {
            for (i = 0; i < registeredOres.size(); ++i) {
                PulverizerManager.getInstance().addRecipe(240, (ItemStack)registeredOres.get(i), dustSulfur, TEItems.crystalSulfur, 30);
            }
        }
        if (!(registeredOres = OreDictionary.getOres((String)"dustSaltpeter")).isEmpty()) {
            dustSaltpeter = ((ItemStack)registeredOres.get(0)).func_77946_l();
            dustSaltpeter.field_77994_a = 4;
        }
        registeredOres = OreDictionary.getOres((String)"oreSaltpeter");
        if (dustSaltpeter != null) {
            for (i = 0; i < registeredOres.size(); ++i) {
                PulverizerManager.getInstance().addRecipe(240, (ItemStack)registeredOres.get(i), dustSaltpeter, TEItems.crystalNiter, 15);
            }
        }
    }

    public static void addOreToDustRecipe(int energy, String oreName, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryOutput == null) {
            return;
        }
        ArrayList registeredOres = OreDictionary.getOres((String)oreName);
        ItemStack dust = primaryOutput.func_77946_l();
        dust.field_77994_a = 2;
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack ore = ((ItemStack)registeredOres.get(i)).func_77946_l();
            ore.field_77994_a = 1;
            PulverizerManager.addTERecipe(energy, ore, dust, secondaryOutput, secondaryChance);
        }
    }

    public static void addOreToDustRecipe(int energy, ItemStack ore, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryOutput == null) {
            return;
        }
        ItemStack dust = primaryOutput.func_77946_l();
        dust.field_77994_a = 2;
        PulverizerManager.addTERecipe(energy, ore, dust, secondaryOutput, secondaryChance);
    }

    public static void addIngotToDustRecipe(int energy, String ingotName, ItemStack dust) {
        if (dust == null) {
            return;
        }
        ArrayList registeredOres = OreDictionary.getOres((String)ingotName);
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack ore = ((ItemStack)registeredOres.get(i)).func_77946_l();
            ore.field_77994_a = 1;
            PulverizerManager.addTERecipe(energy, ore, dust, null, 0);
        }
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return instance.addInternalRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance);
    }

    private boolean addInternalRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        PulverizerRecipe recipe;
        if (input == null || primaryOutput == null || energy <= 0) {
            return false;
        }
        if (PulverizerManager.recipeExists(input)) {
            recipe = PulverizerManager.getRecipe(input);
            recipeList.remove(recipe);
        }
        recipe = new PulverizerRecipe(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, boolean overwrite) {
        return this.addRecipe(energy, input, primaryOutput, null, 0, overwrite);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, boolean overwrite) {
        return this.addRecipe(energy, input, primaryOutput, secondaryOutput, 100, overwrite);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        PulverizerRecipe recipe;
        if (input == null || primaryOutput == null || energy <= 0) {
            return false;
        }
        if (PulverizerManager.recipeExists(input)) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                recipe = PulverizerManager.getRecipe(input);
                recipeList.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "A Pulverizer recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite a Pulverizer recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        recipe = new PulverizerRecipe(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return this.addRecipe(energy, input, primaryOutput, false);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return this.addRecipe(energy, input, primaryOutput, secondaryOutput, false);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return this.addRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance, false);
    }

    @Override
    public IPulverizerRecipe[] getRecipeList() {
        return recipeList.toArray(new PulverizerRecipe[0]);
    }

    static {
        if (ThermalExpansion.config.get("tweak.craftinghandlers", "Pulverizer.Override", false)) {
            PulverizerManager.allowOverwrite();
        } else {
            PulverizerManager.denyOverwrite();
        }
        instance = new PulverizerManager();
        recipeMap = new HashMap();
        recipeList = new ArrayList();
    }

    public class PulverizerRecipe
    implements IPulverizerRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        PulverizerRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        @Override
        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        @Override
        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

