/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.codechicken.core.render.CCModel;
import cofh.codechicken.core.render.CCRenderState;
import cofh.codechicken.core.render.IUVTransformation;
import cofh.codechicken.core.render.IconTransformation;
import cofh.codechicken.core.render.LightModel;
import cofh.codechicken.core.vec.ITransformation;
import cofh.codechicken.core.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.tesseract.BlockTesseract;
import thermalexpansion.block.tesseract.TileTesseractRoot;
import thermalexpansion.core.TEProps;

@SideOnly(value=Side.CLIENT)
public class RenderTesseract
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static RenderTesseract instance = new RenderTesseract();
    static Icon[] texture = new Icon[5];
    static Icon texture_liquid;
    static CCModel liquid_model;
    static CCModel frame_model;

    public static void initialize() {
        RenderTesseract.texture[0] = IconRegistry.getIcon((String)"TesseractEnergy");
        RenderTesseract.texture[1] = IconRegistry.getIcon((String)"TesseractLiquid");
        RenderTesseract.texture[2] = IconRegistry.getIcon((String)"TesseractItem");
        RenderTesseract.texture[3] = IconRegistry.getIcon((String)"TesseractFrame");
        RenderTesseract.texture[4] = IconRegistry.getIcon((String)"TesseractFrameInner");
        texture_liquid = IconRegistry.getIcon((String)"LiquidEnder");
    }

    public void render(int metadata, double x, double y, double z) {
        int i;
        x += 0.5;
        y += 0.5;
        z += 0.5;
        for (i = 0; i < 48; i += 8) {
            frame_model.render(i, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[metadata]));
        }
        for (i = 4; i < 48; i += 8) {
            frame_model.render(i, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[4]));
        }
    }

    public void renderLiquid(int metadata, double x, double y, double z) {
        liquid_model.render(x, y, z, texture_liquid);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.render(metadata, -0.5, -0.5, -0.5);
        this.renderLiquid(metadata, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        GL11.glDisable((int)3042);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileTesseractRoot)) {
            return false;
        }
        TileTesseractRoot theTile = (TileTesseractRoot)tile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (BlockTesseract.renderPass == 0) {
            this.render(theTile.getId(), x, y, z);
        } else {
            this.renderLiquid(0, x, y, z);
        }
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdTesseract;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            offset = 0.0;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        instance.render(BlockTesseract.Types.values().length, offset, offset, offset);
        if (item.func_77960_j() == 129) {
            instance.renderLiquid(0, offset, offset, offset);
        }
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderUtils.setItemTextureSheet();
        GL11.glDisable((int)3042);
    }

    static {
        liquid_model = CCModel.quadModel((int)24);
        frame_model = CCModel.quadModel((int)48);
        TEProps.renderIdTesseract = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        liquid_model.generateBlock(0, 0.15, 0.15, 0.15, 0.85, 0.85, 0.85).computeNormals();
        frame_model.generateSlice(8, 0, -8.0, 5.0, -8.0, 16.0, 3.0, 16.0, 0.0, 0.0, 16.0, 16.0, 16.0).generateSidedParts(1, new Vector3()).computeNormals().computeLighting(LightModel.standardLightModel);
    }
}

