/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.codechicken.core.render.CCModel;
import cofh.codechicken.core.render.CCRenderState;
import cofh.codechicken.core.render.LightModel;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.device.TileLamp;
import thermalexpansion.core.TEProps;

public class RenderLamp
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static RenderLamp instance = new RenderLamp();
    static final int NUM_RENDERS = 1;
    static Icon[] texture = new Icon[1];
    static Icon[] texture_liquid = new Icon[2];
    static CCModel[] frame_models = new CCModel[1];
    static CCModel[] liquid_models = new CCModel[1];

    public static void initialize() {
        RenderLamp.texture_liquid[0] = IconRegistry.getIcon((String)"LiquidGlowstone");
        RenderLamp.texture_liquid[1] = IconRegistry.getIcon((String)"LiquidLamp");
        for (int i = 0; i < 1; ++i) {
            RenderLamp.texture[i] = IconRegistry.getIcon((String)"Lamp", (int)i);
        }
    }

    private static void generateModels() {
        double d1 = 0.00390625;
        double d2 = 2.0 * d1;
        RenderLamp.frame_models[0] = CCModel.quadModel((int)24).generateBlock(0, d1, d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1).computeNormals().computeLighting(LightModel.standardLightModel);
        RenderLamp.liquid_models[0] = CCModel.quadModel((int)24).generateBlock(0, d2, d2, d2, 1.0 - d2, 1.0 - d2, 1.0 - d2).computeNormals();
    }

    public void render(int metadata, double x, double y, double z) {
        frame_models[metadata].render(x, y, z, texture[metadata]);
    }

    public void renderLiquid(int metadata, double x, double y, double z, boolean modified) {
        if (modified) {
            liquid_models[metadata].render(x, y, z, texture_liquid[1]);
        } else {
            liquid_models[metadata].render(x, y, z, texture_liquid[0]);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity aTile = world.func_72796_p(x, y, z);
        if (!(aTile instanceof TileLamp)) {
            return false;
        }
        TileLamp theTile = (TileLamp)aTile;
        int bMeta = world.func_72805_g(x, y, z);
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        CCRenderState.setColour((int)theTile.getColorMultiplier());
        this.renderLiquid(bMeta, x, y, z, theTile.modified);
        CCRenderState.setColour((int)-1);
        this.render(bMeta, x, y, z);
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdLamp;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            offset = 0.0;
        }
        int metadata = item.func_77960_j();
        boolean modified = false;
        int color = -1;
        if (item.func_77942_o()) {
            modified = item.func_77978_p().func_74767_n("modified");
            color = item.func_77978_p().func_74762_e("color");
            color = (color << 8) + 255;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        CCRenderState.setColour((int)color);
        instance.renderLiquid(metadata, offset, offset, offset, modified);
        CCRenderState.draw();
        CCRenderState.startDrawing((int)7);
        CCRenderState.setColour((int)-1);
        instance.render(metadata, offset, offset, offset);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderUtils.setItemTextureSheet();
        GL11.glDisable((int)3042);
    }

    static {
        TEProps.renderIdLamp = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderLamp.generateModels();
    }
}

