/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.render.RenderUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.api.crafting.ITransposerRecipe;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.gui.gui.GuiTransposer;
import thermalexpansion.plugins.nei.NEIGuiHandler;
import thermalexpansion.util.crafting.TransposerManager;

public class TransposerRecipeHandler
extends TemplateRecipeHandler {
    public static TransposerRecipeHandler instance = new TransposerRecipeHandler();
    public static final int MAX_ENERGY = Machines.powerData[Machines.Types.TRANSPOSER.ordinal()].maxEnergy;
    public static final int MAX_LIQUID = 10000;
    public int[] energyAmount = new int[2];
    public int[] liquidAmount = new int[]{10000, 10000};
    public int[] lastCycle = new int[2];
    public int[] arecipe = new int[]{-1, -1};

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(107, 8, 24, 18), "thermalexpansion.transposer", new Object[0]));
    }

    public List handleTooltip(GuiRecipe gui, List currenttip, int recipe) {
        int minX1 = 151;
        int maxX1 = 167;
        int minY1 = 17;
        int maxY1 = 77;
        int yOffset = 66;
        Point mousepos = gui.manager.getMousePosition();
        int leftSide = (gui.field_73880_f - gui.field_74194_b) / 2;
        int topSide = (gui.field_73881_g - gui.field_74195_c) / 2;
        if (mousepos.x >= minX1 + leftSide && mousepos.x < maxX1 + leftSide && mousepos.y >= minY1 + topSide && mousepos.y < maxY1 + topSide && this.arecipe[0] == recipe) {
            currenttip.add(((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid.asItemStack().func_77973_b().func_77628_j(((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid.asItemStack()));
        } else if (mousepos.x >= minX1 + leftSide && mousepos.x < maxX1 + leftSide && mousepos.y >= minY1 + topSide + yOffset && mousepos.y < maxY1 + topSide + yOffset && this.arecipe[1] == recipe) {
            currenttip.add(((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid.asItemStack().func_77973_b().func_77628_j(((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid.asItemStack()));
        }
        return currenttip;
    }

    public Class getGuiClass() {
        return GuiTransposer.class;
    }

    public String getRecipeName() {
        return CoreUtils.localize((String)"machine.transposer");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("thermalexpansion.transposer")) {
            ITransposerRecipe[] recipes;
            for (ITransposerRecipe recipe : recipes = TransposerManager.getInstance().getFillRecipeList()) {
                this.arecipes.add(new TransposerRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ITransposerRecipe[] recipes;
        for (ITransposerRecipe recipe : recipes = TransposerManager.getInstance().getFillRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new TransposerRecipe(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == TransposerRecipeHandler.class) {
            this.loadCraftingRecipes("thermalexpansion.transposer", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ITransposerRecipe[] recipes;
        for (ITransposerRecipe recipe : recipes = TransposerManager.getInstance().getFillRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new TransposerRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "/mods/thermalexpansion/textures/gui/Transposer.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        gui.drawTexturedModalRect(39, 41, 176, 0, 14, 16);
        this.drawEnergyBar(gui, recipe);
        this.drawLiquid(131 - (int)((float)(this.cycleticks % 20) / 20.0f * 24.0f), 11, ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid, (int)((float)(this.cycleticks % 20) / 20.0f * 24.0f), 16, gui);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(107, 11, 192, 112, 24, 16);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(147, 7, 176, 104, 16, 49);
        gui.drawText(105, 2, ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).energy + "MJ", 0x939393, false);
        gui.drawText(105, 29, ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid.amount + "mB", 0x939393, false);
    }

    public void drawLiquidBar(GuiContainerManager gui, int recipe, int recipe2) {
        if (this.liquidAmount[recipe] == 0) {
            this.liquidAmount[recipe] = 10000;
        }
        int n = recipe;
        this.liquidAmount[n] = this.liquidAmount[n] - ((TransposerRecipe)((Object)this.arecipes.get((int)recipe2))).liquid.amount;
        if (this.liquidAmount[recipe] <= 0) {
            this.liquidAmount[recipe] = 10000;
        }
    }

    public void drawEnergyBar(GuiContainerManager gui, int recipe) {
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = recipe;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != recipe) {
            this.arecipe[1] = recipe;
        }
        if (this.arecipe[0] != recipe && this.arecipe[1] != recipe) {
            this.arecipe[0] = -1;
            this.arecipe[1] = -1;
            this.energyAmount[0] = 0;
            this.energyAmount[1] = 0;
            this.lastCycle[0] = 0;
            this.lastCycle[1] = 0;
            this.liquidAmount[0] = 10000;
            this.liquidAmount[1] = 10000;
            this.drawEnergyBar(gui, recipe);
            return;
        }
        if (this.arecipe[0] == recipe) {
            int energy = this.getScaledEnergy(this.energyAmount[0]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            this.drawLiquid(147, 61 - this.getScaledLiquid(this.liquidAmount[0]), ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid, 16, this.getScaledLiquid(this.liquidAmount[0]), gui);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[0]) {
                if (this.energyAmount[0] == MAX_ENERGY) {
                    this.energyAmount[0] = 0;
                }
                this.energyAmount[0] = this.energyAmount[0] + ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[0] > MAX_ENERGY) {
                    this.energyAmount[0] = MAX_ENERGY;
                }
                this.drawLiquidBar(gui, 0, recipe);
                this.lastCycle[0] = this.cycleticks;
            }
        } else {
            int energy = this.getScaledEnergy(this.energyAmount[1]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            this.drawLiquid(147, 61 - this.getScaledLiquid(this.liquidAmount[1]), ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).liquid, 16, this.getScaledLiquid(this.liquidAmount[1]), gui);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[1]) {
                if (this.energyAmount[1] == MAX_ENERGY) {
                    this.energyAmount[1] = 0;
                }
                this.energyAmount[1] = this.energyAmount[1] + ((TransposerRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[1] > MAX_ENERGY) {
                    this.energyAmount[1] = MAX_ENERGY;
                }
                this.drawLiquidBar(gui, 1, recipe);
                this.lastCycle[1] = this.cycleticks;
            }
        }
    }

    public int getScaledLiquid(int amount) {
        int scale = 60;
        int theResult = amount * scale / 10000;
        return theResult;
    }

    public int getScaledEnergy(int amount) {
        int scale = 40;
        int theResult = amount * scale / MAX_ENERGY;
        return theResult;
    }

    public String getOverlayIdentifier() {
        return "thermalexpansion.transposer";
    }

    protected void drawLiquid(int j, int k, LiquidStack theLiquid, int width, int height, GuiContainerManager gui) {
        if (height > 60) {
            height = 60;
        }
        RenderUtils.setLiquidTextureSheet((LiquidStack)theLiquid);
        int x = 0;
        int y = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (x = 0; x < width; x += 16) {
            for (y = 0; y < height; y += 16) {
                drawWidth = MathHelper.minI((int)(width - x), (int)16);
                drawHeight = MathHelper.minI((int)(height - y), (int)16);
                NEIGuiHandler.drawScaledTexturedModelRectFromIcon(gui, j + x, k + y, RenderUtils.getLiquidTexture((LiquidStack)theLiquid), drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 8, 166, 65);
    }

    class TransposerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        LiquidStack liquid;
        int energy;

        public TransposerRecipe(ITransposerRecipe recipe) {
            super((TemplateRecipeHandler)TransposerRecipeHandler.this);
            this.input = new PositionedStack((Object)recipe.getInput(), 75, 11);
            this.output = new PositionedStack((Object)recipe.getOutput(), 75, 41);
            this.energy = recipe.getEnergy();
            this.liquid = recipe.getLiquid();
        }

        public PositionedStack getIngredient() {
            int cycle = TransposerRecipeHandler.this.cycleticks / 48;
            if (this.input.item.func_77960_j() == -1) {
                PositionedStack stack = this.input.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }
    }
}

