/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.render.RenderUtils;
import cofh.util.CoreUtils;
import java.awt.Rectangle;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.api.crafting.IPulverizerRecipe;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.gui.gui.GuiPulverizer;
import thermalexpansion.util.crafting.PulverizerManager;

public class PulverizerRecipeHandler
extends TemplateRecipeHandler {
    public static PulverizerRecipeHandler instance = new PulverizerRecipeHandler();
    public static final int MAX_ENERGY = Machines.powerData[Machines.Types.PULVERIZER.ordinal()].maxEnergy;
    public int[] energyAmount = new int[2];
    public int[] lastCycle = new int[2];
    public int[] arecipe = new int[]{-1, -1};

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "thermalexpansion.pulverizer", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiPulverizer.class;
    }

    public String getRecipeName() {
        return CoreUtils.localize((String)"machine.pulverizer");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("thermalexpansion.pulverizer")) {
            IPulverizerRecipe[] recipes;
            for (IPulverizerRecipe recipe : recipes = PulverizerManager.getInstance().getRecipeList()) {
                this.arecipes.add(new PulverizerRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        IPulverizerRecipe[] recipes;
        for (IPulverizerRecipe recipe : recipes = PulverizerManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getPrimaryOutput(), (ItemStack)result) && (recipe.getSecondaryOutput() == null || !NEIServerUtils.areStacksSameType((ItemStack)recipe.getSecondaryOutput(), (ItemStack)result))) continue;
            this.arecipes.add(new PulverizerRecipe(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == PulverizerRecipeHandler.class) {
            this.loadCraftingRecipes("thermalexpansion.pulverizer", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        IPulverizerRecipe[] recipes;
        for (IPulverizerRecipe recipe : recipes = PulverizerManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new PulverizerRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "/mods/thermalexpansion/textures/gui/Pulverizer.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        gui.drawTexturedModalRect(51, 36, 176, 0, 16, 16);
        this.drawProgressBar(gui, 74, 26, 176, 16, 24, 16, 20, 0);
        this.drawEnergyBar(gui, recipe);
        gui.drawText(74, 17, ((PulverizerRecipe)((Object)this.arecipes.get((int)recipe))).energy + "MJ", 0x939393, false);
        if (((PulverizerRecipe)((Object)this.arecipes.get((int)recipe))).secondaryOutput != null) {
            int secondChance = ((PulverizerRecipe)((Object)this.arecipes.get((int)recipe))).secondaryOutputChance;
            if (secondChance < 10) {
                gui.drawText(96, 52, secondChance + "%", 0x939393, false);
            } else if (secondChance >= 100) {
                gui.drawText(84, 52, secondChance + "%", 0x939393, false);
            } else {
                gui.drawText(90, 52, secondChance + "%", 0x939393, false);
            }
        }
    }

    public void drawEnergyBar(GuiContainerManager gui, int recipe) {
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = recipe;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != recipe) {
            this.arecipe[1] = recipe;
        }
        if (this.arecipe[0] != recipe && this.arecipe[1] != recipe) {
            this.arecipe[0] = -1;
            this.arecipe[1] = -1;
            this.energyAmount[0] = 0;
            this.energyAmount[1] = 0;
            this.lastCycle[0] = 0;
            this.lastCycle[1] = 0;
            this.drawEnergyBar(gui, recipe);
            return;
        }
        if (this.arecipe[0] == recipe) {
            int energy = this.getScaledEnergy(this.energyAmount[0]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[0]) {
                if (this.energyAmount[0] == MAX_ENERGY) {
                    this.energyAmount[0] = 0;
                }
                this.energyAmount[0] = this.energyAmount[0] + ((PulverizerRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[0] > MAX_ENERGY) {
                    this.energyAmount[0] = MAX_ENERGY;
                }
                this.lastCycle[0] = this.cycleticks;
            }
        } else {
            int energy = this.getScaledEnergy(this.energyAmount[1]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[1]) {
                if (this.energyAmount[1] == MAX_ENERGY) {
                    this.energyAmount[1] = 0;
                }
                this.energyAmount[1] = this.energyAmount[1] + ((PulverizerRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[1] > MAX_ENERGY) {
                    this.energyAmount[1] = MAX_ENERGY;
                }
                this.lastCycle[1] = this.cycleticks;
            }
        }
    }

    public int getScaledEnergy(int amount) {
        int scale = 40;
        int theResult = amount * scale / MAX_ENERGY;
        return theResult;
    }

    public String getOverlayIdentifier() {
        return "thermalexpansion.pulverizer";
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 8, 166, 65);
    }

    class PulverizerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack primaryOutput;
        PositionedStack secondaryOutput;
        int secondaryOutputChance;
        int energy;

        public PulverizerRecipe(IPulverizerRecipe recipe) {
            super((TemplateRecipeHandler)PulverizerRecipeHandler.this);
            this.secondaryOutput = null;
            this.secondaryOutputChance = 0;
            this.input = new PositionedStack((Object)recipe.getInput(), 51, 18);
            this.primaryOutput = new PositionedStack((Object)recipe.getPrimaryOutput(), 111, 18);
            this.energy = recipe.getEnergy();
            if (recipe.getSecondaryOutput() != null) {
                this.secondaryOutput = new PositionedStack((Object)recipe.getSecondaryOutput(), 111, 45);
                this.secondaryOutputChance = recipe.getSecondaryOutputChance();
            }
        }

        public PositionedStack getIngredient() {
            int cycle = PulverizerRecipeHandler.this.cycleticks / 48;
            if (this.input.item.func_77960_j() == -1) {
                PositionedStack stack = this.input.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.input;
        }

        public PositionedStack getResult() {
            return this.primaryOutput;
        }

        public PositionedStack getOtherStack() {
            return this.secondaryOutput;
        }
    }
}

