/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.mfr;

import cpw.mods.fml.common.Loader;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Property;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.simple.BlockOre;
import thermalexpansion.core.TEProps;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.plugins.mfr.DrinkHandlerEnder;
import thermalexpansion.plugins.mfr.DrinkHandlerGlowstone;
import thermalexpansion.plugins.mfr.DrinkHandlerRedstone;

public class MFRPlugin {
    public static boolean strawRedstone = true;
    public static boolean strawGlowstone = true;
    public static boolean strawEnder = true;
    public static int strawEnderRange = 16384;

    public static void configure() {
        String category = "plugins.tweak";
        strawRedstone = ThermalExpansion.config.get(category, "MFR.Redstone.Straw", true);
        strawGlowstone = ThermalExpansion.config.get(category, "MFR.Glowstone.Straw", true);
        strawEnder = ThermalExpansion.config.get(category, "MFR.Ender.Straw", true);
        Property curProp = ThermalExpansion.config.getProperty(category, "MFR.Ender.Range", strawEnderRange);
        curProp.comment = "This controls the maximum distance (in blocks) a player will teleport from drinking Ender.";
        strawEnderRange = curProp.getInt();
        if (strawEnderRange <= 0 || strawEnderRange > 65536) {
            ThermalExpansion.log.log(Level.INFO, "'MFR.Ender.Range' config value is out of acceptable range. Using default.");
            strawEnderRange = 16384;
        }
    }

    public static void initialize() {
    }

    public static void loadRecipes() {
        if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
            try {
                if (BlockOre.enable[TEProps.Ores.COPPER.ordinal()]) {
                    FarmingRegistry.registerLaserOre((int)120, (ItemStack)BlockOre.oreCopper);
                    FarmingRegistry.setLaserPreferredOre((int)14, (ItemStack)BlockOre.oreCopper);
                }
                if (BlockOre.enable[TEProps.Ores.TIN.ordinal()]) {
                    FarmingRegistry.registerLaserOre((int)120, (ItemStack)BlockOre.oreTin);
                    FarmingRegistry.setLaserPreferredOre((int)8, (ItemStack)BlockOre.oreTin);
                }
                if (BlockOre.enable[TEProps.Ores.SILVER.ordinal()]) {
                    FarmingRegistry.registerLaserOre((int)110, (ItemStack)BlockOre.oreSilver);
                    FarmingRegistry.setLaserPreferredOre((int)7, (ItemStack)BlockOre.oreSilver);
                }
                if (BlockOre.enable[TEProps.Ores.LEAD.ordinal()]) {
                    FarmingRegistry.registerLaserOre((int)110, (ItemStack)BlockOre.oreLead);
                    FarmingRegistry.setLaserPreferredOre((int)5, (ItemStack)BlockOre.oreLead);
                }
                if (BlockOre.enable[TEProps.Ores.NICKEL.ordinal()]) {
                    FarmingRegistry.registerLaserOre((int)55, (ItemStack)BlockOre.oreNickel);
                    FarmingRegistry.setLaserPreferredOre((int)9, (ItemStack)BlockOre.oreNickel);
                }
                if (strawRedstone) {
                    FarmingRegistry.registerLiquidDrinkHandler((int)TELiquids.blockRedstone.field_71990_ca, (ILiquidDrinkHandler)DrinkHandlerRedstone.instance);
                }
                if (strawGlowstone) {
                    FarmingRegistry.registerLiquidDrinkHandler((int)TELiquids.blockGlowstone.field_71990_ca, (ILiquidDrinkHandler)DrinkHandlerGlowstone.instance);
                }
                if (strawEnder) {
                    FarmingRegistry.registerLiquidDrinkHandler((int)TELiquids.blockEnder.field_71990_ca, (ILiquidDrinkHandler)DrinkHandlerEnder.instance);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

