/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.metallurgy;

import cofh.util.MathHelper;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import rebelkeithy.mods.metallurgy.api.IMetalSet;
import rebelkeithy.mods.metallurgy.api.IOreInfo;
import rebelkeithy.mods.metallurgy.api.MetallurgyAPI;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingHelpers;
import thermalexpansion.util.crafting.PulverizerManager;

public class MetallurgyPlugin {
    public static final String[] METAL_SETS = new String[]{"base", "precious", "nether", "fantasy", "ender", "utility"};

    public static void configure() {
    }

    public static void initialize() {
    }

    public static void loadRecipes() {
        boolean recipeIngotsToDusts = ThermalExpansion.config.get("tweak", "Pulverizer.IngotsToDust", true);
        if (Loader.isModLoaded((String)"Metallurgy3Core")) {
            for (int i = 0; i < METAL_SETS.length; ++i) {
                IMetalSet set = MetallurgyAPI.getMetalSet((String)METAL_SETS[i]);
                ArrayList oreList = new ArrayList(set.getOreList().values());
                for (IOreInfo ore : oreList) {
                    if (ore == null) continue;
                    CraftingHelpers.addPulverizerOreToDustRecipe(ore.getOre(), ore.getDust());
                    CraftingHelpers.addSmelterOreToIngotsRecipe(ore.getOre(), ore.getIngot());
                    if (recipeIngotsToDusts) {
                        CraftingHelpers.addPulverizerIngotToDustRecipe(ore.getIngot(), ore.getDust());
                    }
                    CraftingHelpers.addSmelterDustToIngotsRecipe(ore.getDust(), ore.getIngot());
                    MetallurgyPlugin.addPulverizerMiscDropRecipe(ore);
                }
            }
        }
    }

    public static boolean addPulverizerMiscDropRecipe(IOreInfo ore) {
        if (ore.getOre() == null || ore.getDrop() == null) {
            return false;
        }
        ItemStack drop = ore.getDrop().func_77946_l();
        drop.field_77994_a = MathHelper.maxI((int)3, (int)((int)((double)ore.getDropAmountMax() * 1.5)));
        PulverizerManager.getInstance().addRecipe(320, ore.getOre(), drop);
        return true;
    }
}

