/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item;

import cofh.util.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.gui.FalseInventoryCrafting;
import thermalexpansion.item.TEItems;

public class SchematicHelper {
    public static NBTTagCompound getNBTForSchematic(IInventory craftSlots, ItemStack output) {
        NBTTagCompound theComp = new NBTTagCompound();
        for (int i = 0; i < 9 && i < craftSlots.func_70302_i_(); ++i) {
            if (craftSlots.func_70301_a(i) != null) {
                theComp.func_74768_a("Slot" + i + "id", craftSlots.func_70301_a((int)i).field_77993_c);
                theComp.func_74768_a("Slot" + i + "meta", craftSlots.func_70301_a(i).func_77960_j());
                theComp.func_74778_a("Slot" + i + "name", craftSlots.func_70301_a(i).func_82833_r());
                String oreName = SchematicHelper.getOreDictName(craftSlots.func_70301_a(i));
                if (oreName == null) continue;
                theComp.func_74778_a("Slot" + i + "ore", oreName);
                continue;
            }
            theComp.func_74768_a("Slot" + i + "id", -1);
            theComp.func_74768_a("Slot" + i + "meta", -1);
            theComp.func_74778_a("Slot" + i + "name", "");
        }
        theComp.func_74778_a("outputName", output.field_77994_a + "x " + output.func_82833_r());
        return theComp;
    }

    public static String getOreDictName(ItemStack stackInSlot) {
        int ID = OreDictionary.getOreID((ItemStack)stackInSlot);
        if (ID == -1) {
            return null;
        }
        String sID = OreDictionary.getOreName((int)ID);
        return sID.equalsIgnoreCase("unknown") ? null : sID;
    }

    public static ItemStack getSchematic(NBTTagCompound theTag) {
        ItemStack returnStack = TEItems.schematic.func_77946_l();
        returnStack.field_77990_d = theTag;
        return returnStack;
    }

    public static String getOutputName(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("outputName")) {
            return ": " + stack.field_77990_d.func_74779_i("outputName");
        }
        return "";
    }

    public static ItemStack getOutput(ItemStack aSchematic, World theWorld) {
        FalseInventoryCrafting tempCraft = new FalseInventoryCrafting(3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCraft.func_70299_a(i, SchematicHelper.getSchematicSlot(aSchematic, i));
        }
        return ItemUtils.findMatchingRecipe((InventoryCrafting)tempCraft, (World)theWorld);
    }

    public static ItemStack getSchematicSlot(ItemStack aSchematic, int i) {
        if (aSchematic.field_77990_d != null && aSchematic.field_77990_d.func_74764_b("Slot" + i + "id") && aSchematic.field_77990_d.func_74762_e("Slot" + i + "id") > -1) {
            return new ItemStack(aSchematic.field_77990_d.func_74762_e("Slot" + i + "id"), 1, aSchematic.field_77990_d.func_74762_e("Slot" + i + "meta"));
        }
        return null;
    }

    public static String getSchematicOreSlot(ItemStack aSchematic, int i) {
        if (aSchematic.field_77990_d != null && aSchematic.field_77990_d.func_74764_b("Slot" + i + "ore")) {
            return aSchematic.field_77990_d.func_74779_i("Slot" + i + "ore");
        }
        return null;
    }

    public static boolean isSchematic(ItemStack theStack) {
        return theStack == null ? false : theStack.field_77993_c == TEItems.schematic.field_77993_c && theStack.func_77960_j() == 0;
    }

    public static void addSchematicTooltips(List theList, ItemStack theSchematic) {
        if (theSchematic.field_77990_d == null) {
            theList.add("-Blank-");
            return;
        }
        boolean hasOre = false;
        HashMap<String, Integer> aMap = new HashMap<String, Integer>();
        for (int i = 0; i < 9; ++i) {
            String curName;
            if (!theSchematic.field_77990_d.func_74764_b("Slot" + i + "name") || theSchematic.field_77990_d.func_74779_i("Slot" + i + "name").equalsIgnoreCase("")) continue;
            if (theSchematic.field_77990_d.func_74764_b("Slot" + i + "ore")) {
                hasOre = true;
                if (GuiScreen.func_73877_p()) {
                    curName = theSchematic.field_77990_d.func_74779_i("Slot" + i + "ore");
                    if (aMap.containsKey(curName)) {
                        aMap.put(curName, (Integer)aMap.get(curName) + 1);
                        continue;
                    }
                    aMap.put(curName, 1);
                    continue;
                }
            }
            if (aMap.containsKey(curName = theSchematic.field_77990_d.func_74779_i("Slot" + i + "name"))) {
                aMap.put(curName, (Integer)aMap.get(curName) + 1);
                continue;
            }
            aMap.put(curName, 1);
        }
        for (Map.Entry entry : aMap.entrySet()) {
            theList.add("\u00a77" + entry.getValue() + "x " + (String)entry.getKey());
        }
        if (hasOre && !GuiScreen.func_73877_p()) {
            theList.add("<Hold Shift for more Info>");
        }
    }
}

