/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiRoot;
import cofh.gui.element.ElementRoot;
import cofh.render.RenderUtils;
import thermalexpansion.core.TEProps;

public class ElementSlotOverlay
extends ElementRoot {
    public static boolean enableBorders;
    public static boolean colorBlind;
    public int slotColor;
    public int slotType;
    public int slotRender;

    public ElementSlotOverlay(GuiRoot gui, int posX, int posY) {
        super(gui, posX, posY);
        this.texture = TEProps.textureGuiCommon;
    }

    public ElementSlotOverlay setSlotInfo(int color, int type, int render) {
        this.slotColor = color;
        this.slotType = type;
        this.slotRender = render;
        return this;
    }

    public ElementSlotOverlay setSlotColor(int color) {
        this.slotColor = color;
        return this;
    }

    public ElementSlotOverlay setSlotRender(int render) {
        this.slotRender = render;
        return this;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        RenderUtils.bindTexture((String)this.texture);
        if (enableBorders) {
            this.drawSlotWithBorder(this.posX, this.posY);
        } else {
            this.drawSlotNoBorder(this.posX, this.posY);
        }
    }

    public String getTooltip() {
        return null;
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return false;
    }

    protected void drawSlotNoBorder(int x, int y) {
        this.sizeX = 0;
        this.sizeY = 0;
        int offsetX = this.slotColor / 3 * 128;
        int offsetY = this.slotColor % 3 * 32;
        switch (this.slotType) {
            case 0: {
                this.sizeX = 16;
                this.sizeY = 16;
                offsetX += 8;
                offsetY += 8;
                break;
            }
            case 1: {
                this.sizeX = 24;
                this.sizeY = 24;
                offsetX += 36;
                offsetY += 4;
                break;
            }
            case 2: {
                this.sizeX = 42;
                this.sizeY = 24;
                offsetX += 75;
                offsetY += 4;
                break;
            }
            case 3: {
                this.sizeX = 16;
                this.sizeY = 60;
                offsetX = this.slotColor * 32 + 8;
                offsetY = 98;
                break;
            }
            case 4: {
                this.sizeX = 34;
                this.sizeY = 160;
                offsetX += 8;
                offsetY += 164;
            }
        }
        switch (this.slotRender) {
            case 0: {
                this.sizeY /= 2;
                break;
            }
            case 1: {
                this.sizeY /= 2;
                y += this.sizeY;
                offsetY += this.sizeY;
                break;
            }
        }
        this.gui.func_73729_b(x, y, offsetX, offsetY, this.sizeX, this.sizeY);
    }

    protected void drawSlotWithBorder(int x, int y) {
        int sizeX = 32;
        int sizeY = 32;
        int offsetX = this.slotColor / 3 * 128;
        int offsetY = this.slotColor % 3 * 32;
        offsetX += this.slotType * 32;
        switch (this.slotType) {
            case 0: {
                x -= 8;
                y -= 8;
                break;
            }
            case 1: {
                x -= 4;
                y -= 4;
                break;
            }
            case 2: {
                sizeX = 64;
                x -= 11;
                y -= 4;
                break;
            }
            case 3: {
                sizeX = 32;
                sizeY = 64;
                offsetX = this.slotColor * 32;
                offsetY = 96;
                x -= 8;
                y -= 2;
                break;
            }
            case 4: {
                sizeX = 164;
                sizeY = 38;
                offsetX = this.slotColor / 3 * 128 + 6;
                offsetY += 162;
                x -= 2;
                y -= 2;
            }
        }
        switch (this.slotRender) {
            case 0: {
                sizeY /= 2;
                break;
            }
            case 1: {
                y += (sizeY /= 2);
                offsetY += sizeY;
                break;
            }
        }
        this.gui.func_73729_b(x, y, offsetX, offsetY, sizeX, sizeY);
    }
}

