/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tesseract;

import buildcraft.api.tools.IToolWrench;
import cofh.util.CoreUtils;
import cofh.util.IInitializer;
import cofh.util.ItemUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.tesseract.TileTesseractEnergy;
import thermalexpansion.block.tesseract.TileTesseractItem;
import thermalexpansion.block.tesseract.TileTesseractLiquid;
import thermalexpansion.block.tesseract.TileTesseractRoot;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.util.Utils;
import thermalexpansion.util.crafting.TransposerManager;

public class BlockTesseract
extends BlockTERoot
implements IInitializer {
    public static final String[] NAMES = new String[]{"energy", "liquid", "item"};
    public static final int SEND = 0;
    public static final int RECV = 1;
    public static final int SEND_RECV = 2;
    public static final int ENERGY_TESSERACT_MAX_TRANSFER = 500;
    public static String playerName = "[None]";
    public static boolean[] enable = new boolean[Types.values().length];
    public static int renderPass = 0;
    public static ItemStack tesseractEnergy;
    public static ItemStack tesseractLiquid;
    public static ItemStack tesseractItem;

    public BlockTesseract(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(2000.0f);
        this.func_71864_b("thermalexpansion.tesseract");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == Types.ITEM.ordinal()) {
            return new TileTesseractItem();
        }
        if (metadata == Types.LIQUID.ordinal()) {
            return new TileTesseractLiquid();
        }
        if (metadata == Types.ENERGY.ordinal()) {
            return new TileTesseractEnergy();
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public float func_71908_a(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof TileTesseractRoot) {
            return ForgeHooks.blockStrength((Block)(((TileTesseractRoot)theTile).canPlayerBreak(player.field_71092_bJ) ? this : Block.field_71986_z), (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        }
        return ForgeHooks.blockStrength((Block)this, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof TileTesseractRoot) {
            ((TileTesseractRoot)theTile).removeFromRegistry();
            playerName = ((TileTesseractRoot)theTile).owner;
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        NBTTagCompound tag = null;
        if (!playerName.equals("[None]")) {
            tag = new NBTTagCompound();
            tag.func_74778_a("owner", playerName);
            playerName = "[None]";
        }
        ItemStack retStack = new ItemStack(this.field_71990_ca, 1, this.func_71899_b(metadata));
        retStack.func_77982_d(tag);
        ret.add(retStack);
        return ret;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        TileTesseractRoot theTile = (TileTesseractRoot)world.func_72796_p(x, y, z);
        if (theTile == null) {
            return false;
        }
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (CoreUtils.isServerWorld((World)world) && (theTile.isOwner(player.field_71092_bJ) || CoreUtils.isOp((EntityPlayer)player))) {
                    this.dismantleBlock(player, world, x, y, z, false);
                    ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                }
                return true;
            }
            return false;
        }
        if (CoreUtils.isClientWorld((World)world)) {
            return true;
        }
        if (ItemUtils.isHoldingItemStack((ItemStack)TEItems.multimeter, (EntityPlayer)player)) {
            if (theTile.frequency == -1) {
                player.func_70006_a("Device Disabled - Owner: " + theTile.owner);
            } else if (theTile.isPrivate()) {
                player.func_70006_a("Frequency (Private): " + theTile.frequency + " - Owner: " + theTile.owner);
            } else {
                player.func_70006_a("Frequency: " + theTile.frequency + " - Owner: " + theTile.owner);
            }
            switch (theTile.mode) {
                case 0: {
                    player.func_70006_a("Mode: Send - Outputs: " + theTile.getValidOutputs().size());
                    break;
                }
                case 1: {
                    player.func_70006_a("Mode: Receive - Inputs: " + theTile.getValidInputs().size());
                    break;
                }
                case 2: {
                    player.func_70006_a("Mode: Send/Receive - Inputs: " + theTile.getValidInputs().size() + " - Outputs: " + theTile.getValidOutputs().size());
                }
            }
            return false;
        }
        if (theTile.isOwner(player.field_71092_bJ) && ItemUtils.isHoldingItemStack((ItemStack)TEItems.dustPlatinum, (EntityPlayer)player)) {
            if (theTile.setSave()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)player.func_71045_bC()));
                }
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.endermen.portal", 0.75f, 1.0f);
            }
            return true;
        }
        if (theTile.isOwner(player.field_71092_bJ) && ItemUtils.isHoldingItem((Item)Item.field_77751_aT, (EntityPlayer)player)) {
            if (theTile.clearSave()) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.25f, 1.0f);
            }
            return true;
        }
        return theTile.openGui(player);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack theItem) {
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof TileTesseractRoot) {
            ((TileTesseractRoot)theTile).setOwnerName(((EntityPlayer)living).field_71092_bJ);
        }
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public int func_71856_s_() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return TEProps.renderIdTesseract;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        TileTesseractRoot theTile = (TileTesseractRoot)world.func_72796_p(x, y, z);
        NBTTagCompound tag = null;
        if (theTile != null) {
            if (!theTile.owner.equals("[None]")) {
                tag = new NBTTagCompound();
                tag.func_74778_a("owner", theTile.owner);
                if (theTile.saveSettings) {
                    tag.func_74768_a("frequency", theTile.frequency);
                    tag.func_74774_a("mode", theTile.mode);
                    tag.func_74774_a("access", theTile.access);
                    tag.func_74757_a("red.disable", theTile.getRedstoneDisable());
                    tag.func_74757_a("red.state", theTile.getRedstoneState());
                }
            }
            theTile.removeFromRegistry();
        }
        return super.dismantleBlock(player, tag, world, x, y, z, returnBlock);
    }

    public void initialize() {
        TileTesseractEnergy.initialize();
        TileTesseractLiquid.initialize();
        TileTesseractItem.initialize();
        tesseractEnergy = new ItemStack(TEBlocks.blockTesseract, 1, Types.ENERGY.ordinal());
        tesseractLiquid = new ItemStack(TEBlocks.blockTesseract, 1, Types.LIQUID.ordinal());
        tesseractItem = new ItemStack(TEBlocks.blockTesseract, 1, Types.ITEM.ordinal());
        ItemRegistry.registerItem("tesseractEnergy", tesseractEnergy);
        ItemRegistry.registerItem("tesseractLiquid", tesseractLiquid);
        ItemRegistry.registerItem("tesseractItem", tesseractItem);
    }

    public void loadRecipes() {
        if (enable[Types.ENERGY.ordinal()] || enable[Types.LIQUID.ordinal()] || enable[Types.ITEM.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TEItems.tesseractFrameEmpty, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotTin", Character.valueOf('G'), TEBlocks.blockGlass, Character.valueOf('X'), Item.field_77702_n}));
            TransposerManager.getInstance().addFillRecipe(1600, TEItems.tesseractFrameEmpty, TEItems.tesseractFrameFull, new LiquidStack(TELiquids.blockEnder.field_71990_ca, 1000), false, false);
        }
        if (enable[Types.ENERGY.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tesseractEnergy, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.tesseractFrameFull, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), TEItems.powerCoilElectrum, Character.valueOf('X'), "ingotElectrum", Character.valueOf('Y'), "ingotSilver"}));
        }
        if (enable[Types.LIQUID.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tesseractLiquid, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.tesseractFrameFull, Character.valueOf('I'), "ingotTin", Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), "ingotSilver"}));
        }
        if (enable[Types.ITEM.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tesseractItem, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.tesseractFrameFull, Character.valueOf('I'), "ingotTin", Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), "ingotSilver"}));
        }
    }

    static {
        String category = "block.feature";
        BlockTesseract.enable[Types.ENERGY.ordinal()] = ThermalExpansion.config.get(category, "Tesseract.Energy", true);
        BlockTesseract.enable[Types.LIQUID.ordinal()] = ThermalExpansion.config.get(category, "Tesseract.Liquid", true);
        BlockTesseract.enable[Types.ITEM.ordinal()] = ThermalExpansion.config.get(category, "Tesseract.Item", true);
    }

    public static enum Packets {
        DESCRIPTION,
        ENTRY,
        NAME_LIST,
        TILE_INFO;

    }

    public static enum Types {
        ENERGY,
        LIQUID,
        ITEM;

    }
}

