/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidRegistry;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachineRoot;

public class TileWaterGen
extends TileMachineRoot
implements ITankContainer {
    public static final int ID = Machines.Types.WATER_GEN.ordinal();
    public static int genRate = 1000;
    public static int transferRate = genRate / 40;
    int numAdjacentSources;
    boolean initialized = false;
    public static final int MAX_LIQUID = 4000;
    LiquidTankAdv myTank = new LiquidTankAdv(LiquidRegistry.WATER_ID, 0, 4000);
    int outputTrackerLiquid;

    public static void initialize() {
        Machines.guiIds[TileWaterGen.ID] = ThermalExpansion.proxy.registerGui("WaterGen", true);
        GameRegistry.registerTileEntityWithAlternatives(TileWaterGen.class, (String)"cofh.thermalexpansion.WaterGen", (String[])new String[]{"thermalexpansion.factory.WaterGen"});
    }

    public TileWaterGen() {
        this.sideCache = new byte[]{1, 1, 1, 1, 1, 1};
        this.myTank.setLocked(true);
        this.myTank.setTankPressure(1);
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidTankAdv getTank() {
        return this.myTank;
    }

    @Override
    public void onBlockAdded() {
        this.updateAdjacentSources();
    }

    @Override
    public void onNeighborBlockChange() {
        this.updateAdjacentSources();
    }

    protected void updateAdjacentSources() {
        this.numAdjacentSources = 0;
        int id = this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        int meta = this.field_70331_k.func_72805_g(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        if (meta == 0 && (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca)) {
            ++this.numAdjacentSources;
        }
        id = this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        meta = this.field_70331_k.func_72805_g(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        if (meta == 0 && (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca)) {
            ++this.numAdjacentSources;
        }
        id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        if (meta == 0 && (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca)) {
            ++this.numAdjacentSources;
        }
        id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        if (meta == 0 && (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca)) {
            ++this.numAdjacentSources;
        }
    }

    public int getScaledLiquid(int id, int scale) {
        if (id == LiquidRegistry.WATER_ID) {
            if (this.myTank.getLiquidAmount() >= 4000) {
                return scale;
            }
            return this.myTank.getLiquidAmount() * scale / 4000;
        }
        return 0;
    }

    protected boolean canStart() {
        if (this.field_70331_k.func_72807_a(this.field_70329_l, this.field_70327_n) == BiomeGenBase.field_76778_j) {
            return false;
        }
        return this.myTank.getLiquidAmount() <= 4000;
    }

    protected void transferLiquid() {
        if (this.myTank.getLiquidAmount() < transferRate) {
            return;
        }
        for (int i = this.outputTrackerLiquid + 1; i <= this.outputTrackerLiquid + 6; ++i) {
            int[] coords;
            TileEntity tile;
            int side = i % 6;
            if (this.sideCache[side] != 1 || !((tile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2])) instanceof ITankContainer) || tile instanceof TileWaterGen) continue;
            this.myTank.adjustLiquid(-((ITankContainer)tile).fill(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), new LiquidStack(LiquidRegistry.WATER_ID, transferRate), true));
            this.outputTrackerLiquid = side;
            break;
        }
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (!this.initialized) {
            this.updateAdjacentSources();
            this.initialized = true;
        }
        boolean curActive = this.isActive;
        this.transferLiquid();
        if (this.isActive) {
            if (this.field_70331_k.func_72820_D() % 40L == 0L) {
                if (this.numAdjacentSources >= 2) {
                    int waterToAdd = MathHelper.minI((int)genRate, (int)(4000 - this.myTank.getLiquidAmount()));
                    this.myTank.adjustLiquid(waterToAdd);
                } else {
                    int waterToAdd = MathHelper.minI((int)1, (int)(4000 - this.myTank.getLiquidAmount()));
                    this.myTank.adjustLiquid(waterToAdd);
                }
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            }
        } else if (this.canStart() && this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.numAdjacentSources = j;
                return;
            }
            case 1: {
                this.myTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.numAdjacentSources);
        iCrafting.func_71112_a(container, 1, this.myTank.getLiquidAmount());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.numAdjacentSources = data.func_74762_e("process.sources");
        this.outputTrackerLiquid = data.func_74762_e("output.liquid");
        this.myTank.setLiquidAmount(data.func_74762_e("qty.water"));
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("process.sources", this.numAdjacentSources);
        data.func_74768_a("output.liquid", this.outputTrackerLiquid);
        data.func_74768_a("qty.water", this.myTank.getLiquidAmount());
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return new ILiquidTank[0];
        }
        if (this.sideCache[direction.ordinal()] != 1) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.sideCache[direction.ordinal()] != 1) {
            return null;
        }
        return this.myTank;
    }

    static {
        int rate = ThermalExpansion.config.get("tweak", "WaterGen.Rate", genRate / 40);
        if (rate > 0 && rate <= 50) {
            genRate = rate * 40;
            transferRate = genRate / 40;
        } else {
            ThermalExpansion.log.log(Level.INFO, "'WaterGen.Rate' config value is out of acceptable range. Using default.");
        }
    }
}

