/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.util.IInitializer;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.device.TileEnergyCell;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.util.crafting.TransposerManager;

public class BlockEnergyCell
extends BlockTERoot
implements IInitializer {
    public static boolean enable;
    public static int renderPass;
    public static ItemStack energyCell;

    public BlockEnergyCell(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(20.0f);
        this.func_71894_b(150.0f);
        this.func_71864_b("thermalexpansion.energycell");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEnergyCell();
    }

    public static ItemStack setDefaultTag(ItemStack theStack, int energyStored) {
        theStack.func_77982_d(new NBTTagCompound());
        theStack.field_77990_d.func_74776_a("energy.stored", (float)energyStored);
        theStack.field_77990_d.func_74768_a("energy.send", 50);
        theStack.field_77990_d.func_74768_a("energy.receive", 100);
        theStack.field_77990_d.func_74757_a("red.disable", false);
        theStack.field_77990_d.func_74757_a("red.state", false);
        return theStack;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        if (enable) {
            list.add(BlockEnergyCell.setDefaultTag(new ItemStack(itemId, 1, 0), 0));
            list.add(BlockEnergyCell.setDefaultTag(new ItemStack(itemId, 1, 0), 600000));
        }
    }

    @Override
    public int func_71899_b(int i) {
        return i;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public int func_71856_s_() {
        return 1;
    }

    public int func_71857_b() {
        return TEProps.renderIdEnergyCell;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        TileEnergyCell theTile = (TileEnergyCell)world.func_72796_p(x, y, z);
        NBTTagCompound tag = null;
        if (theTile != null) {
            tag = new NBTTagCompound();
            tag.func_74776_a("energy.stored", theTile.getEnergy());
            tag.func_74768_a("energy.send", theTile.energySend);
            tag.func_74768_a("energy.receive", theTile.energyReceive);
            tag.func_74757_a("red.disable", theTile.getRedstoneDisable());
            tag.func_74757_a("red.state", theTile.getRedstoneState());
        }
        return super.dismantleBlock(player, tag, world, x, y, z, returnBlock);
    }

    public void initialize() {
        TileEnergyCell.initialize();
        energyCell = new ItemStack(TEBlocks.blockEnergyCell, 1, 0);
        BlockEnergyCell.setDefaultTag(energyCell, 0);
        ItemRegistry.registerItem("energyCell", energyCell);
    }

    public void loadRecipes() {
        if (enable) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TEItems.energyFrameEmpty, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotElectrum", Character.valueOf('G'), TEBlocks.blockGlass, Character.valueOf('X'), Item.field_77702_n}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(energyCell, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.energyFrameFull, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), TEItems.powerCoilElectrum, Character.valueOf('X'), "ingotElectrum", Character.valueOf('Y'), "ingotElectrum"}));
            TransposerManager.getInstance().addFillRecipe(1600, TEItems.energyFrameEmpty, TEItems.energyFrameFull, new LiquidStack(TELiquids.blockRedstone.field_71990_ca, 4000), false, false);
        }
    }

    static {
        renderPass = 0;
        String category = "block.feature";
        enable = ThermalExpansion.config.get(category, "EnergyCell.Enable", true);
    }
}

