/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TileConduitRoot
extends TileEntity {
    protected boolean needsGrid = true;
    protected boolean conduitInvalid = false;
    protected boolean placingBlock = true;
    public byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};
    public byte mode = 0;
    public byte outputTracker = 0;

    public int getLightValue() {
        return 0;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.conduitInvalid) {
            for (int s = 6; s < 6; ++s) {
                this.sideCache[s] = 0;
            }
            this.onBlockAdded();
            this.conduitInvalid = false;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.breakBlock();
    }

    public abstract int getRenderId();

    public abstract LiquidStack getRenderLiquid();

    public abstract int getRenderLiquidLevel();

    public abstract void debugOutput();

    public abstract void breakBlock();

    public abstract void onBlockAdded();

    public abstract void changeMode(EntityPlayer var1);

    public abstract void checkConnections();

    public abstract void onNeighborBlockChange();

    public abstract boolean canTransfer();

    public abstract boolean wrenchAction(EntityPlayer var1, int var2);

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.placingBlock = false;
        this.sideCache = data.func_74770_j("side.array");
        if (this.sideCache.length == 0) {
            this.sideCache = new byte[]{0, 0, 0, 0, 0, 0};
        }
        this.mode = data.func_74771_c("mode");
        this.outputTracker = data.func_74771_c("sendTracker");
        this.mode = (byte)(this.mode % 2);
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("mode", this.mode);
        data.func_74774_a("output", this.outputTracker);
        data.func_74773_a("side.array", this.sideCache);
        data.func_74778_a("version", "2.4.6.0");
    }

    public static enum LiquidRenderInfo {
        EMPTY,
        LOW,
        LOW_MED,
        MEDIUM,
        MED_HIGH,
        HIGH,
        FULL;

    }

    protected static class SideInfo {
        public static final byte NONE = 0;
        public static final byte CONDUIT = 1;
        public static final byte OTHER = 2;
        public static final byte INVENTORY = 3;

        protected SideInfo() {
        }
    }
}

