/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.core.SafeTimeTracker;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidRegistry;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.conduit.LiquidTankGrid;
import thermalexpansion.block.conduit.TileConduitLiquid;
import thermalexpansion.block.conduit.TileConduitRoot;

public class GridLiquid {
    List conduitList = new LinkedList();
    List outputList = new LinkedList();
    List inputList = new LinkedList();
    World worldObj;
    SafeTimeTracker tracker = new SafeTimeTracker();
    boolean recentUpdate = false;
    public LiquidTankGrid myTank;
    public static int minLiquidTime = 100;
    public int conduitCount = 0;
    public int conduitTick = 0;
    public int liquidThroughput = 100;
    public int liquidPerConduit = 500;
    public int liquidID = 0;
    public int liquidMeta = 0;
    public int liquidLevel = 0;
    public int recentLiquidID = 0;
    public int recentLiquidMeta = 0;

    public GridLiquid(World world) {
        this.worldObj = world;
        this.myTank = new LiquidTankGrid(1000, this);
    }

    public void setLiquidData(LiquidStack liquid, boolean isFill) {
        int viscosity = 0;
        if (liquid != null) {
            viscosity = LiquidRegistry.getLiquidViscosity((LiquidStack)liquid);
        }
        if (viscosity <= 0) {
            viscosity = 100;
        }
        if (viscosity > 200) {
            viscosity = 200;
        }
        this.liquidThroughput = viscosity;
        this.liquidPerConduit = 5 * viscosity;
        this.recalcTank();
        if (liquid != null && isFill) {
            this.tracker.markTime(this.worldObj);
            this.recentUpdate = true;
            this.recentLiquidID = liquid.itemID;
            this.recentLiquidMeta = liquid.itemMeta;
        }
    }

    public void addConduit(TileConduitLiquid theCond) {
        if (!this.contains(theCond)) {
            this.conduitList.add(theCond);
        }
        this.recalcTank();
        this.addLiquid(theCond);
        if (this.myTank.getLiquid() != null) {
            theCond.liquidID = this.myTank.getLiquid().itemID;
            theCond.liquidMeta = this.myTank.getLiquid().itemMeta;
        }
        theCond.updateConnections();
    }

    public void addNode(TileConduitLiquid theCond) {
        if (theCond.mode == 0) {
            if (!this.outputList.contains((Object)theCond)) {
                this.outputList.add(theCond);
            }
            this.inputList.remove((Object)theCond);
        }
        if (theCond.mode == 1) {
            if (!this.inputList.contains((Object)theCond)) {
                this.inputList.add(theCond);
            }
            this.outputList.remove((Object)theCond);
        }
        this.recalcTank();
        this.addLiquid(theCond);
        if (this.myTank.getLiquid() != null) {
            theCond.liquidID = this.myTank.getLiquid().itemID;
            theCond.liquidMeta = this.myTank.getLiquid().itemMeta;
        }
        theCond.updateConnections();
    }

    public void removeConduit(TileConduitLiquid theCond) {
        this.conduitList.remove((Object)theCond);
        if (this.isGridEmpty() && this.myTank.getLiquid() != null) {
            theCond.liquidAmount = this.myTank.getLiquid().amount;
            theCond.liquidID = this.myTank.getLiquid().itemID;
            theCond.liquidMeta = this.myTank.getLiquid().itemMeta;
            this.myTank.getLiquid().amount = 0;
        }
    }

    public void removeNode(TileConduitLiquid theCond) {
        this.outputList.remove((Object)theCond);
        this.inputList.remove((Object)theCond);
        if (this.isGridEmpty() && this.myTank.getLiquid() != null) {
            theCond.liquidAmount = this.myTank.getLiquid().amount;
            theCond.liquidID = this.myTank.getLiquid().itemID;
            theCond.liquidMeta = this.myTank.getLiquid().itemMeta;
            this.myTank.getLiquid().amount = 0;
        }
    }

    public void unloadConduit(TileConduitLiquid theCond) {
        this.myTank.drain(theCond.lastWriteStorage, true);
        if (theCond.isNode) {
            this.removeNode(theCond);
        } else {
            this.removeConduit(theCond);
        }
        this.recalcTank();
    }

    public boolean isGridEmpty() {
        return this.outputList.size() == 0 && this.inputList.size() == 0 && this.conduitList.size() == 0;
    }

    public void addLiquid(TileConduitLiquid theCond) {
        if (theCond.liquidAmount > 0 && theCond.liquidID > 0) {
            if (this.myTank.getLiquid() == null) {
                this.myTank.setLiquid(new LiquidStack(theCond.liquidID, theCond.liquidAmount, theCond.liquidMeta));
            } else {
                this.myTank.fill(new LiquidStack(theCond.liquidID, theCond.liquidAmount, theCond.liquidMeta), true);
            }
            theCond.liquidAmount = 0;
        }
    }

    public void changeMode(TileConduitLiquid theCond) {
        this.inputList.remove((Object)theCond);
        this.outputList.remove((Object)theCond);
        if (theCond.mode == 0) {
            this.outputList.add(theCond);
        } else {
            this.inputList.add(theCond);
        }
    }

    public void transferLiquid(TileConduitLiquid theCond) {
        block18: {
            block16: {
                int i;
                TileConduitLiquid theTile;
                int randCond;
                int a;
                int curLiquidUsed;
                block17: {
                    if (this.outputList.size() <= 0 || !((Object)((Object)((TileConduitLiquid)((Object)this.outputList.get(0))))).equals((Object)theCond) || this.myTank.getLiquid() == null) break block16;
                    int distAmount = MathHelper.minI((int)(this.getLiquidAmount() / this.outputList.size()), (int)this.getLiquidThroughput());
                    curLiquidUsed = 0;
                    if (distAmount <= 0) break block17;
                    for (int a2 = 0; a2 < this.outputList.size(); ++a2) {
                        int i2;
                        TileConduitLiquid theTile2 = (TileConduitLiquid)((Object)this.outputList.get(a2));
                        curLiquidUsed = distAmount;
                        for (i2 = theTile2.outputTracker; i2 < 6 && curLiquidUsed > 0; curLiquidUsed -= theTile2.transferLiquid(i2, curLiquidUsed), ++i2) {
                        }
                        for (i2 = 0; i2 < theTile2.outputTracker && curLiquidUsed > 0; curLiquidUsed -= theTile2.transferLiquid(i2, curLiquidUsed), ++i2) {
                        }
                        theTile2.outputTracker = this.increaseTracker(theTile2.sideCache, theTile2.outputTracker);
                    }
                    break block18;
                }
                if (this.getLiquidAmount() % this.outputList.size() <= 0) break block18;
                curLiquidUsed = this.getLiquidAmount() % this.outputList.size();
                for (a = randCond = theCond.field_70331_k.field_73012_v.nextInt(this.outputList.size()); a < this.outputList.size(); ++a) {
                    theTile = (TileConduitLiquid)((Object)this.outputList.get(a));
                    for (i = theTile.outputTracker; i < 6 && curLiquidUsed > 0; curLiquidUsed -= theTile.transferLiquid(i, curLiquidUsed), ++i) {
                    }
                    for (i = 0; i < theTile.outputTracker && curLiquidUsed > 0; curLiquidUsed -= theTile.transferLiquid(i, curLiquidUsed), ++i) {
                    }
                    theTile.outputTracker = this.increaseTracker(theTile.sideCache, theTile.outputTracker);
                    if (curLiquidUsed != 0) continue;
                    return;
                }
                for (a = 0; a < randCond; ++a) {
                    theTile = (TileConduitLiquid)((Object)this.outputList.get(a));
                    for (i = theTile.outputTracker; i < 6 && curLiquidUsed > 0; curLiquidUsed -= theTile.transferLiquid(i, curLiquidUsed), ++i) {
                    }
                    for (i = 0; i < theTile.outputTracker && curLiquidUsed > 0; curLiquidUsed -= theTile.transferLiquid(i, curLiquidUsed), ++i) {
                    }
                    theTile.outputTracker = this.increaseTracker(theTile.sideCache, theTile.outputTracker);
                    if (curLiquidUsed != 0) continue;
                    return;
                }
                break block18;
            }
            if (this.inputList.size() > 0 && ((Object)((Object)((TileConduitLiquid)((Object)this.inputList.get(0))))).equals((Object)theCond) && this.getLiquidAmount() < this.myTank.getCapacity()) {
                int i;
                TileConduitLiquid theTile;
                int randCond;
                int a;
                for (a = randCond = theCond.field_70331_k.field_73012_v.nextInt(this.inputList.size()); a < this.inputList.size(); ++a) {
                    theTile = (TileConduitLiquid)((Object)this.inputList.get(a));
                    for (i = theTile.outputTracker; i < 6; ++i) {
                        theTile.extractLiquid(i);
                    }
                    for (i = 0; i < theTile.outputTracker; ++i) {
                        theTile.extractLiquid(i);
                    }
                    theTile.outputTracker = this.increaseTracker(theTile.sideCache, theTile.outputTracker);
                }
                for (a = 0; a < randCond; ++a) {
                    theTile = (TileConduitLiquid)((Object)this.inputList.get(a));
                    for (i = theTile.outputTracker; i < 6; ++i) {
                        theTile.extractLiquid(i);
                    }
                    for (i = 0; i < theTile.outputTracker; ++i) {
                        theTile.extractLiquid(i);
                    }
                    theTile.outputTracker = this.increaseTracker(theTile.sideCache, theTile.outputTracker);
                }
            }
        }
    }

    public byte increaseTracker(byte[] sideList, byte curTrack) {
        byte i;
        for (i = curTrack = (byte)(curTrack + 1); i < 6; i = (byte)(i + 1)) {
            if (sideList[i] <= 1) continue;
            return i;
        }
        for (i = 0; i < curTrack; i = (byte)(i + 1)) {
            if (sideList[i] <= 1) continue;
            return i;
        }
        return 0;
    }

    public void setNewGrid(GridLiquid newGrid) {
        Iterator anIt = this.conduitList.iterator();
        TileConduitLiquid aConduit2 = null;
        while (anIt.hasNext()) {
            aConduit2 = (TileConduitLiquid)((Object)anIt.next());
            aConduit2.myGrid = newGrid;
            newGrid.addConduit(aConduit2);
        }
        for (TileConduitLiquid aConduit2 : this.outputList) {
            aConduit2.myGrid = newGrid;
            newGrid.addNode(aConduit2);
        }
        for (TileConduitLiquid aConduit2 : this.inputList) {
            aConduit2.myGrid = newGrid;
            newGrid.addNode(aConduit2);
        }
        this.conduitList = null;
        this.outputList = null;
        this.inputList = null;
        newGrid.recalcTank();
        newGrid.myTank.fillWithoutLoss(this.myTank.getLiquid());
        this.myTank = new LiquidTankGrid(0, this);
    }

    public void destroy() {
        int i;
        if (this.getLiquidAmount() <= 0) {
            return;
        }
        int distAmount = this.getLiquidAmount() / this.conduitCount;
        int overFlow = this.getLiquidAmount() % this.conduitCount;
        for (i = 0; i < this.outputList.size(); ++i) {
            ((TileConduitLiquid)((Object)this.outputList.get((int)i))).liquidAmount = distAmount;
            ((TileConduitLiquid)((Object)this.outputList.get((int)i))).liquidID = this.myTank.getLiquid().itemID;
            ((TileConduitLiquid)((Object)this.outputList.get((int)i))).liquidMeta = this.myTank.getLiquid().itemMeta;
            if (overFlow <= 0) continue;
            ((TileConduitLiquid)((Object)this.outputList.get((int)i))).liquidAmount += overFlow;
            overFlow = 0;
        }
        for (i = 0; i < this.inputList.size(); ++i) {
            ((TileConduitLiquid)((Object)this.inputList.get((int)i))).liquidAmount = distAmount;
            ((TileConduitLiquid)((Object)this.inputList.get((int)i))).liquidID = this.myTank.getLiquid().itemID;
            ((TileConduitLiquid)((Object)this.inputList.get((int)i))).liquidMeta = this.myTank.getLiquid().itemMeta;
            if (overFlow <= 0) continue;
            ((TileConduitLiquid)((Object)this.inputList.get((int)i))).liquidAmount += overFlow;
            overFlow = 0;
        }
        for (i = 0; i < this.conduitList.size(); ++i) {
            ((TileConduitLiquid)((Object)this.conduitList.get((int)i))).liquidAmount = distAmount;
            ((TileConduitLiquid)((Object)this.conduitList.get((int)i))).liquidID = this.myTank.getLiquid().itemID;
            ((TileConduitLiquid)((Object)this.conduitList.get((int)i))).liquidMeta = this.myTank.getLiquid().itemMeta;
            if (overFlow <= 0) continue;
            ((TileConduitLiquid)((Object)this.conduitList.get((int)i))).liquidAmount += overFlow;
            overFlow = 0;
        }
    }

    public int getSharedAmount(TileConduitLiquid theCond) {
        return this.conduitCount == 1 ? this.getLiquidAmount() : (this.isFirst(theCond) ? this.getLiquidAmount() / this.conduitCount + this.getLiquidAmount() % this.conduitCount : this.getLiquidAmount() / this.conduitCount);
    }

    private void recalcTank() {
        this.conduitCount = this.conduitList.size() + this.outputList.size() + this.inputList.size();
        this.myTank.setCapacity(this.conduitCount * this.liquidPerConduit);
    }

    public boolean contains(TileConduitLiquid theCond) {
        return this.conduitList.contains((Object)theCond) || this.outputList.contains((Object)theCond) || this.inputList.contains((Object)theCond);
    }

    public boolean isFirst(TileConduitLiquid theCond) {
        if (this.conduitList.size() > 0) {
            return ((Object)((Object)((TileConduitLiquid)((Object)this.conduitList.get(0))))).equals((Object)theCond);
        }
        if (this.outputList.size() > 0) {
            return ((Object)((Object)((TileConduitLiquid)((Object)this.outputList.get(0))))).equals((Object)theCond);
        }
        if (this.inputList.size() > 0) {
            return ((Object)((Object)((TileConduitLiquid)((Object)this.inputList.get(0))))).equals((Object)theCond);
        }
        return false;
    }

    public int getLiquidThroughput() {
        if (this.myTank.getLiquid() == null) {
            return 0;
        }
        int capacity = this.myTank.getCapacity();
        if (this.myTank.getLiquid().amount >= capacity * 3 / 4) {
            return this.liquidThroughput;
        }
        if (this.myTank.getLiquid().amount <= capacity / 4) {
            return this.liquidThroughput >> 1;
        }
        return (this.liquidThroughput >> 1) + (this.liquidThroughput >> 1) * (this.myTank.getLiquid().amount - (capacity >> 2)) / (capacity >> 1);
    }

    public int getLiquidAmount() {
        return this.myTank.getLiquid() == null ? 0 : this.myTank.getLiquid().amount;
    }

    public void updateRender(TileConduitLiquid theCond) {
        ++this.conduitTick;
        if (this.conduitTick >= this.conduitCount) {
            this.conduitTick = 0;
            if (this.tracker.markTimeIfDelay(this.worldObj, minLiquidTime) && this.recentUpdate) {
                this.recentUpdate = false;
            }
            if (this.myTank.getLiquid() != null && this.myTank.getCapacity() > 0) {
                this.liquidID = this.myTank.getLiquid().itemID;
                this.liquidMeta = this.myTank.getLiquid().itemMeta;
                double fullPercent = 10000 * this.myTank.getLiquid().amount / this.myTank.getCapacity();
                if (fullPercent >= 0.0) {
                    int n = this.liquidLevel == TileConduitRoot.LiquidRenderInfo.LOW_MED.ordinal() ? 500 : 700;
                    if (fullPercent <= (double)n) {
                        this.liquidLevel = TileConduitRoot.LiquidRenderInfo.LOW.ordinal();
                        return;
                    }
                }
                if (fullPercent >= 500.0) {
                    int n = this.liquidLevel == TileConduitRoot.LiquidRenderInfo.MEDIUM.ordinal() ? 2000 : 2500;
                    if (fullPercent <= (double)n) {
                        this.liquidLevel = TileConduitRoot.LiquidRenderInfo.LOW_MED.ordinal();
                        return;
                    }
                }
                if (fullPercent >= 2000.0) {
                    int n = this.liquidLevel == TileConduitRoot.LiquidRenderInfo.MED_HIGH.ordinal() ? 4000 : 4500;
                    if (fullPercent <= (double)n) {
                        this.liquidLevel = TileConduitRoot.LiquidRenderInfo.MEDIUM.ordinal();
                        return;
                    }
                }
                if (fullPercent >= 4000.0) {
                    int n = this.liquidLevel == TileConduitRoot.LiquidRenderInfo.HIGH.ordinal() ? 6000 : 6500;
                    if (fullPercent <= (double)n) {
                        this.liquidLevel = TileConduitRoot.LiquidRenderInfo.MED_HIGH.ordinal();
                        return;
                    }
                }
                if (fullPercent >= 6000.0) {
                    int n = this.liquidLevel == TileConduitRoot.LiquidRenderInfo.FULL.ordinal() ? 8000 : 8500;
                    if (fullPercent <= (double)n) {
                        this.liquidLevel = TileConduitRoot.LiquidRenderInfo.HIGH.ordinal();
                        return;
                    }
                }
                this.liquidLevel = TileConduitRoot.LiquidRenderInfo.FULL.ordinal();
                return;
            }
            if (this.liquidLevel != TileConduitRoot.LiquidRenderInfo.EMPTY.ordinal() && !this.recentUpdate) {
                this.liquidID = 0;
                this.liquidMeta = 0;
                this.liquidLevel = TileConduitRoot.LiquidRenderInfo.EMPTY.ordinal();
                return;
            }
            if (this.recentUpdate && this.liquidID != this.recentLiquidID) {
                this.liquidID = this.recentLiquidID;
                this.liquidMeta = this.recentLiquidMeta;
                this.liquidLevel = TileConduitRoot.LiquidRenderInfo.LOW.ordinal();
                return;
            }
        }
    }
}

