/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion;

import buildcraft.api.gates.ActionManager;
import cofh.CoFHWorld;
import cofh.api.world.WeightedRandomBlock;
import cofh.core.CoFHProps;
import cofh.gui.GuiHandler;
import cofh.util.ConfigHandler;
import cofh.util.Localization;
import cofh.util.version.VersionHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.MinecraftForge;
import thermalexpansion.api.ThermalExpansionInfo;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileRockGen;
import thermalexpansion.block.simple.BlockOre;
import thermalexpansion.block.tesseract.TesseractRegistry;
import thermalexpansion.core.Proxy;
import thermalexpansion.core.TEProps;
import thermalexpansion.entity.TEPlayerTracker;
import thermalexpansion.gui.CreativeTabTE;
import thermalexpansion.item.TEItems;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.plugins.PluginProxy;
import thermalexpansion.plugins.TEPlugins;
import thermalexpansion.plugins.buildcraft.triggers.TriggerProviderEnergy;
import thermalexpansion.plugins.buildcraft.triggers.TriggerProviderTesseract;
import thermalexpansion.plugins.buildcraft.triggers.TriggerRegistry;
import thermalexpansion.util.crafting.CrucibleManager;
import thermalexpansion.util.crafting.FurnaceManager;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.SawmillManager;
import thermalexpansion.util.crafting.SmelterManager;
import thermalexpansion.util.crafting.TransposerManager;

@Mod(name="Thermal Expansion", version="2.4.6.0", useMetadata=false, modid="ThermalExpansion", dependencies="required-after:Forge@[7.8.0.688,);required-after:CoFHCore@[1.5.2.5,);before:IC2;before:Metallurgy")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class ThermalExpansion {
    @SidedProxy(clientSide="thermalexpansion.core.ProxyClient", serverSide="thermalexpansion.core.Proxy")
    public static Proxy proxy;
    @SidedProxy(clientSide="thermalexpansion.plugins.PluginProxyClient", serverSide="thermalexpansion.plugins.PluginProxy")
    public static PluginProxy pluginProxy;
    @Mod.Instance(value="ThermalExpansion")
    public static ThermalExpansion instance;
    public static final boolean DEBUG = false;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final GuiHandler guiHandler;
    public static final VersionHandler version;
    public static final CreativeTabs tab;
    public static final Material clothFireproof;
    public static final Material woodFireproof;
    public static final EnumArmorMaterial ARMOR_INVAR;
    public static final Material liquidRedstone;
    public static final Material liquidGlowstone;
    public static final Material liquidEnder;

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        File oldFile = new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/telenames.cfg");
        if (oldFile.exists()) {
            oldFile.renameTo(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/tesseracts.cfg"));
        }
        TesseractRegistry.linkConf = new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/tesseracts.cfg"));
        TesseractRegistry.linkConf.load();
        TELiquids.registerDispenserHandlers();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        version.checkForNewVersion();
        boolean optionColorBlind = false;
        boolean optionDrawBorders = true;
        int tweakLavaMJ = TEProps.lavaMJ;
        File oldFile = new File(CoFHProps.configDir, "/cofh/thermalexpansion.cfg");
        if (oldFile.exists()) {
            oldFile.renameTo(new File(CoFHProps.configDir, "/cofh/ThermalExpansion.cfg"));
        }
        config.setConfiguration(new Configuration(new File(event.getModConfigurationDirectory(), "cofh/ThermalExpansion.cfg")));
        this.cleanConfig(true);
        TEItems.configure();
        TEBlocks.configure();
        TELiquids.configure();
        TEPlugins.configure();
        String category = "general";
        TEProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", true);
        TEProps.enableWrenchLogging = config.get(category, "LogWrenchDismantle", TEProps.enableWrenchLogging);
        optionColorBlind = config.get(category, "ColorBlindTextures", false);
        optionDrawBorders = config.get(category, "DrawGUISlotBorders", true);
        category = "tweak";
        tweakLavaMJ = config.get(category, "LavaMJValue", tweakLavaMJ);
        String version = config.get("general", "Version", "2.4.6.0");
        if (optionColorBlind) {
            TEProps.textureGuiCommon = "/mods/thermalexpansion/textures/gui/elements/SlotsCB.png";
            BlockMachine.textureSelection = "SideConfig_CB_";
        }
        TEProps.enableGuiBorders = optionDrawBorders;
        Localization.addLocalization((String)"/mods/thermalexpansion/lang/", (String)"en_US");
        if (tweakLavaMJ >= 1000 && tweakLavaMJ < 36000) {
            TEProps.lavaMJ = tweakLavaMJ;
            ThermalExpansionInfo.lavaFuelValue = tweakLavaMJ * 18 / 20;
        } else {
            log.log(Level.INFO, "'LavaMJValue' config value is out of acceptable range. Using default.");
        }
        if (VersionHandler.beforeTargetVersion((String)version, (String)"2.1.7.0")) {
            config.removeProperty("tweak", "factory.crucible.netherrack.energy");
            config.removeProperty("tweak", "core.lava.mj");
            config.get("tweak", "Crucible.Netherrack.Energy", 12000);
            config.get("tweak", "LavaMJValue", 20000);
        }
        if (VersionHandler.beforeTargetVersion((String)version, (String)"2.3.0.0")) {
            config.removeProperty("tweak", "factory.rockGen.stone.lava");
            config.get("tweak", "RockGen.Stone.Lava", 0);
            TileRockGen.processLava[1] = 0;
            oldFile = new File(event.getModConfigurationDirectory(), "cofh/telenames.cfg");
            if (oldFile.exists()) {
                oldFile.delete();
            }
        }
        config.init();
        TEItems.initialize();
        TEBlocks.initialize();
        TELiquids.initialize();
        TEPlugins.initialize();
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
        this.loadWorldGeneration();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)TEPlayerTracker.instance);
        ActionManager.registerTriggerProvider(TriggerProviderEnergy.instance);
        ActionManager.registerTriggerProvider(TriggerProviderTesseract.instance);
        FurnaceManager.initialize();
        PulverizerManager.initialize();
        SawmillManager.initialize();
        SmelterManager.initialize();
        CrucibleManager.initialize();
        TransposerManager.initialize();
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        FurnaceManager.loadRecipes();
        PulverizerManager.loadRecipes();
        SawmillManager.loadRecipes();
        SmelterManager.loadRecipes();
        CrucibleManager.loadRecipes();
        TransposerManager.loadRecipes();
        TEItems.loadRecipes();
        TEBlocks.loadRecipes();
        TELiquids.loadRecipes();
        TEPlugins.loadRecipes();
        proxy.registerPacketInformation();
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        pluginProxy.registerRenderInformation();
        TriggerRegistry.resolveIDs();
        this.cleanConfig(false);
        config.cleanUp(false);
    }

    void loadWorldGeneration() {
        int i;
        String category = "world.thermalexpansion";
        List[] oreList = new List[TEProps.Ores.values().length];
        for (i = 0; i < oreList.length; ++i) {
            oreList[i] = new ArrayList();
        }
        oreList[TEProps.Ores.COPPER.ordinal()].add(new WeightedRandomBlock(BlockOre.oreCopper));
        oreList[TEProps.Ores.TIN.ordinal()].add(new WeightedRandomBlock(BlockOre.oreTin));
        oreList[TEProps.Ores.SILVER.ordinal()].add(new WeightedRandomBlock(BlockOre.oreSilver, 90));
        oreList[TEProps.Ores.LEAD.ordinal()].add(new WeightedRandomBlock(BlockOre.oreLead, 80));
        oreList[TEProps.Ores.NICKEL.ordinal()].add(new WeightedRandomBlock(BlockOre.oreNickel));
        if (BlockOre.enable[TEProps.Ores.LEAD.ordinal()]) {
            oreList[TEProps.Ores.SILVER.ordinal()].add(new WeightedRandomBlock(BlockOre.oreLead, 10));
        }
        if (BlockOre.enable[TEProps.Ores.SILVER.ordinal()]) {
            oreList[TEProps.Ores.LEAD.ordinal()].add(new WeightedRandomBlock(BlockOre.oreSilver, 20));
        }
        for (i = 0; i < oreList.length; ++i) {
            CoFHWorld.addFeature((String)category, (List)oreList[i], (String)BlockOre.NAMES[i], (int)TEProps.oreClusterSize[i], (int)TEProps.oreNumCluster[i], (int)TEProps.oreMinY[i], (int)TEProps.oreMaxY[i], (int)0, (boolean)true, (boolean)BlockOre.enable[i]);
        }
    }

    void cleanConfig(boolean preInit) {
        if (preInit) {
            String category = "block";
            config.renameProperty(category, "block.energy.storage", category, "EnergyCell", true);
            config.renameProperty(category, "block.energy.conduit", category, "Conduit", true);
            config.renameProperty(category, "block.core.ore", category, "Ore", true);
            config.renameProperty(category, "block.energy.cell", category, "EnergyCell", true);
            config.renameProperty(category, "block.energy.engine", category, "Engine", true);
            config.renameProperty(category, "block.factory.machine", category, "Machine", true);
            config.renameProperty(category, "block.factory.glass", category, "Glass", true);
            config.renameProperty(category, "block.factory.tank", category, "Tank", true);
            config.renameProperty(category, "block.factory.rockwool", category, "Rockwool", true);
            config.renameProperty(category, "block.transport.conduit", category, "Conduit", true);
            config.renameProperty(category, "block.transport.teleport", category, "Tesseract", true);
            category = "block.feature";
            config.renameProperty(category, "energy.engine.magmatic", category, "Engine.Magmatic", true);
            config.renameProperty(category, "energy.engine.steam", category, "Engine.Steam", true);
            config.renameProperty(category, "energy.storage.cell", category, "EnergyCell.Enable", true);
            config.renameProperty(category, "factory.machine.furnace", category, "Machine.Furnace", true);
            config.renameProperty(category, "factory.machine.pulverizer", category, "Machine.Pulverizer", true);
            config.renameProperty(category, "factory.machine.sawmill", category, "Machine.Sawmill", true);
            config.renameProperty(category, "factory.machine.smelter", category, "Machine.Smelter", true);
            config.renameProperty(category, "factory.machine.crucible", category, "Machine.Crucible", true);
            config.renameProperty(category, "factory.machine.transposer", category, "Machine.Transposer", true);
            config.renameProperty(category, "factory.machine.iceGen", category, "Machine.IceGen", true);
            config.renameProperty(category, "factory.machine.rockGen", category, "Machine.RockGen", true);
            config.renameProperty(category, "factory.machine.waterGen", category, "Machine.WaterGen", true);
            config.renameProperty(category, "factory.tank.portable", category, "Tank.Portable", true);
            config.renameProperty(category, "transport.conduit.energy", category, "Conduit.Energy", true);
            config.renameProperty(category, "transport.conduit.liquid", category, "Conduit.Liquid", true);
            config.renameProperty(category, "transport.teleport.energy", category, "Tesseract.Energy", true);
            config.renameProperty(category, "transport.teleport.liquid", category, "Tesseract.Liquid", true);
            config.renameProperty(category, "transport.teleport.items", category, "Tesseract.Item", true);
            category = "item";
            config.renameProperty(category, "liquid.energy.redstone", category, "Liquid", true);
            config.renameProperty(category, "item.energy.mjreader", category, "Tool.Multimeter", true);
            config.renameProperty(category, "item.core.wrench", category, "Tool.Wrench", true);
            config.renameProperty(category, "item.transport.multimeter", category, "Tool.Multimeter", true);
            config.renameProperty(category, "item.core.component", category, "Component", true);
            config.renameProperty(category, "item.core.material", category, "Material", true);
            config.renameProperty(category, "item.core.liquid", category, "Liquid", true);
            config.renameProperty("item.feature", "wrench.logDismantle", "general", "LogWrenchDismantle", true);
            category = "general";
            config.renameProperty(category, "tutorial.tabs", category, "tabs.tutorial", true);
            config.renameProperty(category, "graphics.colorblind", category, "ColorBlindTextures", true);
            config.renameProperty(category, "graphics.slotborders", category, "DrawGUISlotBorders", true);
            config.renameProperty(category, "update.notifications", category, "EnableUpdateNotifications", true);
            category = "triggers";
            config.renameProperty(category, "noEnergy", category, "ContainsEnergy", true);
            config.renameProperty(category, "containsEnergy", category, "ContainsEnergy", true);
            config.renameProperty(category, "spaceForEnergy", category, "SpaceForEnergy", true);
            config.renameProperty(category, "fullEnergy", category, "FullEnergy", true);
            config.renameProperty(category, "hasOutputs", category, "HasOutputs", true);
            config.renameProperty(category, "noOutputs", category, "NoOutputs", true);
            config.renameProperty(category, "hasInputs", category, "HasInputs", true);
            config.renameProperty(category, "noInputs", category, "NoInputs", true);
            category = "tweak";
            config.renameProperty(category, "factory.crafting.machineFrame.useSteel", "tweak.recipe", "MachineFrame.UseSteel", true);
            config.renameProperty(category, "factory.crafting.machines.useGears", "tweak.recipe", "Machines.UseGears", true);
            config.renameProperty(category, "factory.crafting.pulverizer.alternate", "tweak.recipe", "Pulverizer.AddDiamonds", true);
            config.renameProperty(category, "factory.crafting.smelter.alternate", "tweak.recipe", "Smelter.AddDiamonds", true);
            config.renameProperty(category, "factory.crucible.netherrack.energy", category, "Crucible.Netherrack.Energy", true);
            config.renameProperty(category, "factory.pulverizer.recipe.IngotsToDust", category, "Pulverizer.IngotsToDust", true);
            config.renameProperty(category, "factory.pulverizer.recipe.sandstone", category, "Pulverizer.Sandstone", true);
            config.renameProperty(category, "factory.pulverizer.recipe.netherrack", category, "Pulverizer.Netherrack", true);
            config.renameProperty(category, "factory.pulverizer.recipe.wool", category, "Pulverizer.Wool", false);
            config.renameProperty(category, "factory.pulverizer.recipe.reed", category, "Pulverizer.Reed", true);
            config.renameProperty(category, "factory.pulverizer.recipe.bone", category, "Pulverizer.Bone", true);
            config.renameProperty(category, "factory.pulverizer.recipe.blazerod", category, "Pulverizer.BlazeRod", true);
            config.renameProperty(category, "factory.rockGen.cobblestone.lava", category, "RockGen.Cobblestone.Lava", true);
            config.renameProperty(category, "factory.rockGen.cobblestone.water", category, "RockGen.Cobblestone.Water", true);
            config.renameProperty(category, "factory.rockGen.cobblestone.time", category, "RockGen.Cobblestone.Time", true);
            config.renameProperty(category, "factory.rockGen.stone.lava", category, "RockGen.Stone.Lava", true);
            config.renameProperty(category, "factory.rockGen.stone.water", category, "RockGen.Stone.Water", true);
            config.renameProperty(category, "factory.rockGen.stone.time", category, "RockGen.Stone.Time", true);
            config.renameProperty(category, "factory.rockGen.obsidian.lava", category, "RockGen.Obsidian.Lava", true);
            config.renameProperty(category, "factory.rockGen.obsidian.water", category, "RockGen.Obsidian.Water", true);
            config.renameProperty(category, "factory.rockGen.obsidian.time", category, "RockGen.Obsidian.Time", true);
            config.renameProperty(category, "factory.waterGen.rate", category, "WaterGen.Rate", true);
            config.renameProperty(category, "transport.conduit.energy.loss", category, "Redstone.Energy.Loss", true);
            config.renameProperty(category, "core.lava.mj", category, "LavaMJValue", true);
            config.renameProperty(category, "transport.teleport.energy.loss", category, "EnergyFramework.Tesseract.Loss", true);
            config.renameProperty(category, "transport.teleport.energy.maxTransfer", category, "EnergyFramework.Tesseract.MaxTransfer", true);
            config.renameProperty(category, "plugins.turtlesCanBreakBlocks", category, "Plugins.CC.TurtlesCanBreakBlocks", true);
            config.renameProperty(category, "EnergyFramework.Tesseract.Loss", category, "Tesseract.Energy.Loss", true);
            config.renameProperty(category, "EnergyFramework.Tesseract.MaxTransfer", category, "Tesseract.Energy.MaxTransfer", true);
            config.renameProperty("tweak.recipehandlers", "factory.furnace.override", "tweak.craftinghandlers", "Furnace.Override", true);
            config.renameProperty("tweak.recipehandlers", "factory.pulverizer.override", "tweak.craftinghandlers", "Pulverizer.Override", true);
            config.renameProperty("tweak.recipehandlers", "factory.sawmill.override", "tweak.craftinghandlers", "Sawmill.Override", true);
            config.renameProperty("tweak.recipehandlers", "factory.smelter.override", "tweak.craftinghandlers", "Smelter.Override", true);
            config.renameProperty("tweak.recipehandlers", "factory.crucible.override", "tweak.craftinghandlers", "Crucible.Override", true);
            config.renameProperty("tweak.recipehandlers", "factory.transposer.override", "tweak.craftinghandlers", "Transposer.Override", true);
            config.renameProperty("world.gen", "ore.copper", "world.feature", "Ore.Copper", true);
            config.renameProperty("world.gen", "ore.tin", "world.feature", "Ore.Tin", true);
            config.renameProperty("world.gen", "ore.silver", "world.feature", "Ore.Silver", true);
            config.renameProperty("world.gen", "ore.lead", "world.feature", "Ore.Lead", true);
            config.renameProperty("world.feature", "ore.copper", "world.feature", "Ore.Copper", true);
            config.renameProperty("world.feature", "ore.tin", "world.feature", "Ore.Tin", true);
            config.renameProperty("world.feature", "ore.silver", "world.feature", "Ore.Silver", true);
            config.renameProperty("world.feature", "ore.lead", "world.feature", "Ore.Lead", true);
            config.renameProperty("world.feature", "ore.ferrous", "world.feature", "Ore.Nickel", true);
            category = "world.tweak";
            config.renameProperty(category, "ore.copper.minY", category, "Ore.Copper.MinY", true);
            config.renameProperty(category, "ore.tin.minY", category, "Ore.Tin.MinY", true);
            config.renameProperty(category, "ore.silver.minY", category, "Ore.Silver.MinY", true);
            config.renameProperty(category, "ore.lead.minY", category, "Ore.Lead.MinY", true);
            config.renameProperty(category, "ore.ferrous.minY", category, "Ore.Nickel.MinY", true);
            config.renameProperty(category, "ore.copper.maxY", category, "Ore.Copper.MaxY", true);
            config.renameProperty(category, "ore.tin.maxY", category, "Ore.Tin.MaxY", true);
            config.renameProperty(category, "ore.silver.maxY", category, "Ore.Silver.MaxY", true);
            config.renameProperty(category, "ore.lead.maxY", category, "Ore.Lead.MaxY", true);
            config.renameProperty(category, "ore.ferrous.maxY", category, "Ore.Nickel.MaxY", true);
            config.renameProperty(category, "ore.copper.numClusters", category, "Ore.Copper.NumClusters", true);
            config.renameProperty(category, "ore.tin.numClusters", category, "Ore.Tin.NumClusters", true);
            config.renameProperty(category, "ore.silver.numClusters", category, "Ore.Silver.NumClusters", true);
            config.renameProperty(category, "ore.lead.numClusters", category, "Ore.Lead.NumClusters", true);
            config.renameProperty(category, "ore.ferrous.numClusters", category, "Ore.Nickel.NumClusters", true);
            config.renameProperty(category, "ore.copper.clusterSize", category, "Ore.Copper.ClusterSize", true);
            config.renameProperty(category, "ore.tin.clusterSize", category, "Ore.Tin.ClusterSize", true);
            config.renameProperty(category, "ore.silver.clusterSize", category, "Ore.Silver.ClusterSize", true);
            config.renameProperty(category, "ore.lead.clusterSize", category, "Ore.Lead.ClusterSize", true);
            config.renameProperty(category, "ore.ferrous.clusterSize", category, "Ore.Nickel.ClusterSize", true);
            config.renameProperty("item.plugin", "BuildCraft.Pipe.Insertion", "item", "BuildCraft.Pipe.Insertion", true);
            config.renameProperty("item.plugin", "BuildCraft.Pipe.Redstone", "item", "BuildCraft.Pipe.Redstone", true);
        } else {
            String category = "block";
            config.removeProperty(category, "block.energy.conduit");
            config.removeProperty(category, "block.factory.conduit");
            config.removeProperty(category, "block.machine");
            config.removeProperty(category, "block.ore");
            config.removeProperty(category, "block.rockwool");
            category = "block.feature";
            config.removeProperty(category, "machine.crucible");
            config.removeProperty(category, "machine.filler");
            config.removeProperty(category, "factory.machine.filler");
            config.removeProperty(category, "machine.furnace");
            config.removeProperty(category, "machine.iceGen");
            config.removeProperty(category, "machine.pulverizer");
            config.removeProperty(category, "machine.rockGen");
            config.removeProperty(category, "machine.sawmill");
            config.removeProperty(category, "machine.smelter");
            config.removeProperty(category, "machine.waterGen");
            config.removeProperty(category, "energy.conduit");
            config.removeProperty(category, "energy.storage");
            category = "general";
            config.removeProperty(category, "tabs.info");
            config.removeProperty(category, "tabs.tutorial");
            category = "item";
            config.removeProperty(category, "item.alloy");
            config.removeProperty(category, "item.mineral");
            config.removeProperty(category, "item.pulverized");
            config.removeProperty(category, "item.reconfigTool");
            config.removeProperty(category, "item.factory.component");
            config.removeProperty(category, "item.energy.component");
            config.removeProperty(category, "Liquid");
            category = "tweak";
            config.removeProperty(category, "Plugins.CC.TurtlesCanBreakBlocks");
            config.removeProperty(category, "machine.crucible.recipe.netherrack.mj");
            config.removeProperty(category, "energy.grid.loss");
            config.removeProperty(category, "energy.grid.allowRedstoneEngines");
            config.removeProperty(category, "factory.tank.updateTime");
            config.removeProperty(category, "transport.conduit.energy.allowRedstoneEngines");
            config.removeProperty(category, "transport.conduit.liquid.updateTime");
            category = "world.gen";
            config.removeProperty(category, "ore.copper");
            config.removeProperty(category, "ore.tin");
            config.removeProperty(category, "ore.silver");
            config.removeProperty(category, "ore.lead");
            config.removeProperty("world.feature", "vanilla.augment");
            category = "world.tweak";
            config.removeProperty(category, "vanilla.augment.iron.clusterSize");
            config.removeProperty(category, "vanilla.augment.iron.numClusters");
            config.removeProperty(category, "vanilla.augment.gold.clusterSize");
            config.removeProperty(category, "vanilla.augment.gold.numClusters");
            config.removeProperty(category, "vanilla.augment.diamond.clusterSize");
            config.removeProperty(category, "vanilla.augment.diamond.numClusters");
            config.renameProperty("item", "BuildCraft.Pipe.Insertion", "item.plugin", "BuildCraft.Pipe.Insertion", true);
            config.renameProperty("item", "BuildCraft.Pipe.Redstone", "item.plugin", "BuildCraft.Pipe.Redstone", true);
        }
    }

    static {
        log = Logger.getLogger("ThermalExpansion");
        config = new ConfigHandler("2.4.6.0", 2001, 20001);
        guiHandler = new GuiHandler();
        version = new VersionHandler("Thermal Expansion", "2.4.6.0", "https://dl.dropboxusercontent.com/u/57416963/Minecraft/Mods/ThermalExpansion/version.txt", log);
        tab = new CreativeTabTE();
        log.setParent(FMLLog.getLogger());
        clothFireproof = new Material(MapColor.field_76278_e);
        woodFireproof = new Material(MapColor.field_76283_o);
        ARMOR_INVAR = EnumHelper.addArmorMaterial((String)"TE_INVAR", (int)25, (int[])new int[]{2, 7, 5, 2}, (int)12);
        liquidRedstone = new MaterialLiquid(MapColor.field_76275_f);
        liquidGlowstone = new MaterialLiquid(MapColor.field_76277_d);
        liquidEnder = new MaterialLiquid(MapColor.field_76289_i);
    }
}

