/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ClientUtils;
import codechicken.core.ServerUtils;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.RemoteTexManager;
import codechicken.wirelessredstone.addons.TriangTexManager;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WRAddonEventHandler
implements ITickHandler,
IPlayerTracker {
    public void onPlayerLogin(sq player) {
        RedstoneEtherAddons.server().onLogin(player);
    }

    public void onPlayerLogout(sq player) {
        RedstoneEtherAddons.server().onLogout(player);
    }

    public void onPlayerChangedDimension(sq player) {
        RedstoneEtherAddons.server().onDimensionChange(player);
    }

    public void onPlayerRespawn(sq player) {
        RedstoneEtherAddons.server().onLogin(player);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            RedstoneEtherAddons.server().processSMPMaps((aab)tickData[0]);
        }
        if (type.contains(TickType.SERVER)) {
            RedstoneEtherAddons.server().processTrackers();
        }
        if (type.contains(TickType.CLIENT) && ClientUtils.inWorld()) {
            TriangTexManager.processAllTextures();
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.SERVER)) {
            RedstoneEtherAddons.server().tickTriangs();
            RedstoneEtherAddons.server().updateREPTimeouts();
        }
        if (type.contains(TickType.CLIENT) && ClientUtils.inWorld()) {
            RedstoneEtherAddons.client().tick();
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD, TickType.SERVER, TickType.CLIENT, TickType.RENDER);
    }

    public String getLabel() {
        return "WR-CBE Addons";
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.I) {
            RedstoneEtherAddons.loadClientManager();
        } else {
            RedstoneEtherAddons.loadServerWorld();
        }
    }

    @ForgeSubscribe
    public void onChunkUnload(ChunkEvent.Unload event) {
        abw chunk = event.getChunk();
        int i = 0;
        while (i < chunk.j.length) {
            int j = 0;
            while (j < chunk.j[i].size()) {
                Object o = chunk.j[i].get(j);
                if (o instanceof EntityWirelessTracker) {
                    ((EntityWirelessTracker)((Object)o)).onChunkUnload();
                }
                ++j;
            }
            ++i;
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onTextureLoad(TextureStitchEvent.Pre event) {
        if (event.map.a == 1) {
            RemoteTexManager.load(event.map);
            TriangTexManager.loadTextures();
        }
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.I) {
            return;
        }
        if (!ServerUtils.mc().m()) {
            RedstoneEtherAddons.unloadServer();
        }
    }
}

