/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.colour.Colour;
import codechicken.core.colour.ColourARGB;
import codechicken.core.render.TextureSpecial;
import codechicken.core.render.TextureUtils;
import codechicken.wirelessredstone.core.RedstoneEther;

public class RemoteTexManager {
    private static Colour[] texGrad;
    private static Colour[] texOff;
    private static Colour[] texOn;
    private static byte[] imageData;
    private static TextureSpecial[] icons;

    static {
        imageData = new byte[1024];
        icons = new TextureSpecial[32];
    }

    public static void load(bir registrar) {
        int i = 0;
        while (i < icons.length) {
            RemoteTexManager.icons[i] = TextureUtils.getTextureSpecial((ly)registrar, (String)("wrcbe_addons:remote_" + i));
            ++i;
        }
        texOn = TextureUtils.loadTextureColours((String)"/mods/wrcbe_addons/textures/items/remoteOn.png");
        texOff = TextureUtils.loadTextureColours((String)"/mods/wrcbe_addons/textures/items/remoteOff.png");
        texGrad = TextureUtils.loadTextureColours((String)"/mods/wrcbe_addons/textures/items/remoteGrad.png");
        i = 0;
        while (i < 14) {
            RemoteTexManager.processTexture(RedstoneEther.colours[i], false, RemoteTexManager.getIconIndex(i, false));
            RemoteTexManager.processTexture(RedstoneEther.colours[i], true, RemoteTexManager.getIconIndex(i, true));
            ++i;
        }
        RemoteTexManager.processTexture(-1, false, RemoteTexManager.getIconIndex(-1, false));
        RemoteTexManager.processTexture(-1, true, RemoteTexManager.getIconIndex(-1, true));
    }

    private static void processTexture(int colour, boolean on, int i) {
        RemoteTexManager.mergeTexturesWithColour((Colour)new ColourARGB(colour), on);
        bio t = TextureUtils.createTextureObject((String)icons[i].i(), (int)16, (int)16);
        TextureUtils.write((byte[])imageData, (int)16, (int)16, (bio)t, (int)0, (int)0);
        icons[i].addTexture(t);
    }

    public static lx getIcon(int colourid, boolean on) {
        return icons[RemoteTexManager.getIconIndex(colourid, on)];
    }

    public static int getIconIndex(int colourid, boolean on) {
        return colourid + 1 + (on ? 16 : 0);
    }

    private static void mergeTexturesWithColour(Colour texcolour, boolean on) {
        int i = 0;
        while (i < 256) {
            Colour colour = RemoteTexManager.texGrad[i].a == 0 ? (on ? texOn[i] : texOff[i]) : texGrad[i].copy().multiply(texcolour);
            RemoteTexManager.imageData[i * 4 + 0] = colour.r;
            RemoteTexManager.imageData[i * 4 + 1] = colour.g;
            RemoteTexManager.imageData[i * 4 + 2] = colour.b;
            RemoteTexManager.imageData[i * 4 + 3] = colour.a;
            ++i;
        }
    }
}

