/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Vector3;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.ItemWirelessMap;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.Remote;
import codechicken.wirelessredstone.addons.Sniffer;
import codechicken.wirelessredstone.addons.WRAddonSPH;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.FreqCoord;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessReceivingDevice;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RedstoneEtherServerAddons
extends RedstoneEtherAddons {
    private HashMap playerInfos = new HashMap();
    private HashMap trackerPlayerMap = new HashMap();
    private HashSet playerTrackers = new HashSet();
    int trackerTicks = 0;

    public void setTriangRequired(sq player, int freq, boolean required) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (required) {
            info.triangSet.add(freq);
        } else {
            info.triangSet.remove(freq);
        }
    }

    private RedstoneEtherAddons.AddonPlayerInfo getPlayerInfo(sq player) {
        return (RedstoneEtherAddons.AddonPlayerInfo)this.playerInfos.get(player.bS);
    }

    @Override
    public boolean isRemoteOn(sq player, int freq) {
        Remote currentremote = this.getPlayerInfo((sq)player).remote;
        return currentremote == null ? false : currentremote.getFreq() == freq;
    }

    public int getRemoteFreq(sq player) {
        Remote currentremote = this.getPlayerInfo((sq)player).remote;
        if (currentremote == null) {
            return 0;
        }
        return currentremote.getFreq();
    }

    @Override
    public void activateRemote(aab world, sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.remote != null) {
            if (info.remote.isBeingHeld()) {
                return;
            }
            this.deactivateRemote(world, player);
        }
        if (RedstoneEther.server().isPlayerJammed(player)) {
            return;
        }
        info.remote = new Remote(player);
        info.remote.metaOn();
        RedstoneEther.server().addTransmittingDevice((WirelessTransmittingDevice)info.remote);
    }

    @Override
    public boolean deactivateRemote(aab world, sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.remote == null) {
            return false;
        }
        info.remote.metaOff();
        RedstoneEther.server().removeTransmittingDevice((WirelessTransmittingDevice)info.remote);
        info.remote = null;
        return true;
    }

    public void addSniffer(sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.sniffer != null) {
            this.remSniffer(player);
        }
        info.sniffer = new Sniffer(player);
        RedstoneEther.server().addReceivingDevice((WirelessReceivingDevice)info.sniffer);
        byte[] ethercopy = new byte[625];
        int freq = 1;
        while (freq <= 5000) {
            int arrayindex = freq - 1 >> 3;
            int bit = freq - 1 & 7;
            if (RedstoneEther.server().isFreqOn(freq)) {
                int n = arrayindex;
                ethercopy[n] = (byte)(ethercopy[n] | 1 << bit);
            }
            ++freq;
        }
        WRAddonSPH.sendEtherCopyTo(player, ethercopy);
    }

    public void remSniffer(sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.sniffer == null) {
            return;
        }
        RedstoneEther.server().removeReceivingDevice((WirelessReceivingDevice)info.sniffer);
        info.sniffer = null;
    }

    public void processSMPMaps(aab world) {
        RedstoneEther.loadServerWorld((aab)world);
        int dimension = CommonUtils.getDimension((aab)world);
        ArrayList players = ServerUtils.getPlayersInDimension((int)dimension);
        Map txnodes = RedstoneEther.server().getTransmittersInDimension(dimension);
        Set devices = RedstoneEther.server().getTransmittingDevicesInDimension(dimension);
        for (sq player : players) {
            wm helditem = player.cd();
            if (helditem == null || helditem.b() != WirelessRedstoneAddons.wirelessMap || RedstoneEther.server().isPlayerJammed(player)) continue;
            ItemWirelessMap map = (ItemWirelessMap)helditem.b();
            ajl mapdata = map.a(helditem, world);
            if (mapdata.c != player.ar) continue;
            WirelessMapNodeStorage mapnodes = this.getMapNodes(player);
            TreeSet oldnodes = mapnodes.nodes;
            int lastdevices = mapnodes.devices.size();
            this.updatePlayerMapData(player, world, mapdata, txnodes, devices);
            TreeSet addednodes = new TreeSet(mapnodes.nodes);
            TreeSet<FreqCoord> removednodes = new TreeSet<FreqCoord>();
            if (oldnodes.size() != 0) {
                for (FreqCoord node : oldnodes) {
                    if (addednodes.remove(node)) continue;
                    removednodes.add(node);
                }
            }
            if (addednodes.size() == 0 && removednodes.size() == 0 && devices.size() == 0 && lastdevices <= 0) continue;
            WRAddonSPH.sendMapUpdatePacketTo(player, helditem.k(), mapdata, addednodes, removednodes, mapnodes.devices);
        }
    }

    private void updatePlayerMapData(sq player, aab world, ajl mapdata, Map txnodes, Set devices) {
        TreeSet<FreqCoord> mnodes = new TreeSet<FreqCoord>();
        TreeSet<FreqCoord> mdevices = new TreeSet<FreqCoord>();
        int blockwidth = 1 << mapdata.d;
        int minx = mapdata.a - blockwidth * 64;
        int minz = mapdata.b - blockwidth * 64;
        int maxx = mapdata.a + blockwidth * 64;
        int maxz = mapdata.b + blockwidth * 64;
        for (Map.Entry entry : txnodes.entrySet()) {
            BlockCoord node = (BlockCoord)entry.getKey();
            RedstoneEther.TXNodeInfo info = (RedstoneEther.TXNodeInfo)entry.getValue();
            if (!info.on || node.x <= minx || node.x >= maxx || node.z <= minz || node.z >= maxz || !RedstoneEther.server().canBroadcastOnFrequency(player, info.freq)) continue;
            mnodes.add(new FreqCoord(node.x - mapdata.a, node.y, node.z - mapdata.b, info.freq));
        }
        for (WirelessTransmittingDevice device : devices) {
            Vector3 pos = device.getPosition();
            if (!(pos.x > (double)minx) || !(pos.x < (double)maxx) || !(pos.z > (double)minz) || !(pos.z < (double)maxz) || !RedstoneEther.server().canBroadcastOnFrequency(player, device.getFreq())) continue;
            mdevices.add(new FreqCoord((int)pos.x, (int)pos.y, (int)pos.z, device.getFreq()));
        }
        WirelessMapNodeStorage mapnodes = this.getMapNodes(player);
        mapnodes.nodes = mnodes;
        mapnodes.devices = mdevices;
    }

    public void onLogin(sq player) {
        this.playerInfos.put(player.bS, new RedstoneEtherAddons.AddonPlayerInfo());
    }

    public void onLogout(sq player) {
        this.playerInfos.remove(player.bS);
    }

    public void onDimensionChange(sq player) {
        this.deactivateRemote(player.q, player);
        this.remSniffer(player);
        this.playerInfos.put(player.bS, new RedstoneEtherAddons.AddonPlayerInfo());
        Iterator iterator = this.playerTrackers.iterator();
        while (iterator.hasNext()) {
            EntityWirelessTracker tracker = (EntityWirelessTracker)((Object)iterator.next());
            if (!tracker.attachedPlayerName.equals(player.bS)) continue;
            tracker.copyToDimension(player.ar);
            iterator.remove();
        }
    }

    public WirelessMapNodeStorage getMapNodes(sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        return info.mapNodes;
    }

    public void updateSMPMapInfo(aab world, sq player, ajl mapdata, int mapno) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (!info.mapInfoSet.contains(mapno)) {
            WRAddonSPH.sendMapInfoTo(player, mapno, mapdata);
            info.mapInfoSet.add(mapno);
        }
    }

    public void clearMapNodes(sq player) {
        this.getPlayerInfo((sq)player).mapNodes.clear();
    }

    public void tickTriangs() {
        for (Map.Entry entry : this.playerInfos.entrySet()) {
            jc player = ServerUtils.getPlayer((String)((String)entry.getKey()));
            for (Integer freq : ((RedstoneEtherAddons.AddonPlayerInfo)entry.getValue()).triangSet) {
                Vector3 strengthvec;
                double spinto = !RedstoneEther.server().isFreqOn(freq.intValue()) ? -1.0 : (this.isRemoteOn((sq)player, freq) ? -2.0 : ((strengthvec = this.getBroadcastVector((sq)player, freq)) == null ? -2.0 : (double)(player.A + 180.0f) * 0.017453292519943 - Math.atan2(-strengthvec.x, strengthvec.z)));
                WRAddonSPH.sendTriangAngleTo((sq)player, freq, (float)spinto);
            }
        }
    }

    public Vector3 getBroadcastVector(sq player, int freq) {
        double distancePow2;
        Vector3 vecTransmitter;
        Vector3 vecAmplitude = new Vector3(0.0, 0.0, 0.0);
        Vector3 vecPlayer = new Vector3(player.u, 0.0, player.w);
        for (FreqCoord node : RedstoneEther.server().getActiveTransmittersOnFreq(freq, player.ar)) {
            vecTransmitter = new Vector3((double)node.x + 0.5, 0.0, (double)node.z + 0.5);
            distancePow2 = vecTransmitter.subtract(vecPlayer).magSquared();
            vecAmplitude.add(vecTransmitter.multiply(1.0 / distancePow2));
        }
        for (WirelessTransmittingDevice device : RedstoneEther.server().getTransmittingDevicesOnFreq(freq)) {
            if (device.getAttachedEntity() == player) {
                return null;
            }
            if (device.getDimension() != player.ar) continue;
            vecTransmitter = device.getPosition();
            vecTransmitter.y = 0.0;
            distancePow2 = vecTransmitter.subtract(vecPlayer).magSquared();
            vecAmplitude.add(vecTransmitter.multiply(1.0 / distancePow2));
        }
        if (vecAmplitude.isZero()) {
            return null;
        }
        return vecAmplitude;
    }

    public void addTracker(EntityWirelessTracker tracker) {
        this.trackerPlayerMap.put(tracker, new HashSet());
        if (tracker.attachedPlayerName != null) {
            this.playerTrackers.add(tracker);
        }
    }

    public void removeTracker(EntityWirelessTracker tracker) {
        HashSet trackedPlayers = (HashSet)this.trackerPlayerMap.get((Object)tracker);
        if (trackedPlayers != null) {
            for (jc player : trackedPlayers) {
                WRAddonSPH.sendRemoveTrackerTo(player, tracker);
            }
        }
        this.trackerPlayerMap.remove((Object)tracker);
        if (!tracker.attachedInOtherDimension()) {
            this.playerTrackers.remove((Object)tracker);
        }
    }

    public void updateTracker(EntityWirelessTracker tracker) {
        HashSet trackedPlayers = (HashSet)this.trackerPlayerMap.get((Object)tracker);
        if (trackedPlayers == null) {
            trackedPlayers = new HashSet();
            this.trackerPlayerMap.put(tracker, trackedPlayers);
        }
        for (jc player : trackedPlayers) {
            WRAddonSPH.sendTrackerUpdatePacketTo(player, tracker);
        }
        if (tracker.attachedPlayerName != null) {
            this.playerTrackers.add(tracker);
        } else {
            this.playerTrackers.remove((Object)tracker);
        }
    }

    public void processTrackers() {
        ++this.trackerTicks;
        HashSet playerEntities = new HashSet(ServerUtils.getAllPlayers());
        boolean updateFree = this.trackerTicks % 5 == 0;
        boolean updateAttached = this.trackerTicks % 100 == 0;
        Iterator iterator = this.trackerPlayerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            HashSet trackedPlayers = (HashSet)entry.getValue();
            HashSet<jc> playersToTrack = new HashSet<jc>();
            EntityWirelessTracker tracker = (EntityWirelessTracker)((Object)entry.getKey());
            zu chunk = new zu(tracker.aj, tracker.al);
            for (sq entityPlayer : playerEntities) {
                jc player = (jc)entityPlayer;
                if (tracker.M) {
                    WRAddonSPH.sendRemoveTrackerTo(player, tracker);
                    continue;
                }
                if (tracker.getDimension() == player.ar && !player.f.contains(chunk) && !tracker.attachedToLogout()) {
                    playersToTrack.add(player);
                    if (trackedPlayers.contains(player) && (!tracker.isAttachedToEntity() || !updateAttached) && (tracker.isAttachedToEntity() || !updateFree)) continue;
                    WRAddonSPH.sendTrackerUpdatePacketTo(player, tracker);
                    continue;
                }
                if (!trackedPlayers.contains(player)) continue;
                WRAddonSPH.sendRemoveTrackerTo(player, tracker);
            }
            if (tracker.M) {
                iterator.remove();
                continue;
            }
            trackedPlayers.clear();
            trackedPlayers.addAll(playersToTrack);
        }
    }

    public boolean detonateREP(sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.activeREP == null) {
            return false;
        }
        if (info.activeREP.M) {
            info.activeREP = null;
            return false;
        }
        info.activeREP.detonate();
        info.activeREP.w();
        return true;
    }

    @Override
    public void invalidateREP(sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info != null) {
            info.activeREP = null;
        }
    }

    public void updateREPTimeouts() {
        for (Map.Entry entry : this.playerInfos.entrySet()) {
            RedstoneEtherAddons.AddonPlayerInfo info = (RedstoneEtherAddons.AddonPlayerInfo)entry.getValue();
            if (info.REPThrowTimeout <= 0) continue;
            --info.REPThrowTimeout;
        }
    }

    public void throwREP(wm itemstack, aab world, sq player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.REPThrowTimeout > 0) {
            return;
        }
        if (!player.ce.d) {
            --itemstack.a;
        }
        EntityREP activeREP = new EntityREP(world, (ng)player);
        world.d((mp)activeREP);
        WRAddonSPH.sendSpawnREP(activeREP);
        world.a((mp)player, "random.bow", 0.5f, 0.4f / (world.s.nextFloat() * 0.4f + 0.8f));
        info.activeREP = activeREP;
        info.REPThrowTimeout = 40;
    }
}

