/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.vector;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.vector.Vector3;

public class VectorHelper {
    public static final int[][] RELATIVE_MATRIX = new int[][]{{3, 2, 1, 0, 5, 4}, {4, 5, 0, 1, 2, 3}, {0, 1, 3, 2, 5, 4}, {0, 1, 2, 3, 4, 5}, {0, 1, 5, 4, 3, 2}, {0, 1, 4, 5, 2, 3}};

    public static ForgeDirection getOrientationFromSide(ForgeDirection forgeDirection, ForgeDirection forgeDirection2) {
        if (forgeDirection != ForgeDirection.UNKNOWN && forgeDirection2 != ForgeDirection.UNKNOWN) {
            return ForgeDirection.getOrientation((int)RELATIVE_MATRIX[forgeDirection.ordinal()][forgeDirection2.ordinal()]);
        }
        return ForgeDirection.UNKNOWN;
    }

    public static TileEntity getConnectorFromSide(World world, Vector3 vector3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = VectorHelper.getTileEntityFromSide(world, vector3, forgeDirection);
        if (tileEntity instanceof IConnector && ((IConnector)tileEntity).canConnect(VectorHelper.getOrientationFromSide(forgeDirection, ForgeDirection.NORTH))) {
            return tileEntity;
        }
        return null;
    }

    public static TileEntity getTileEntityFromSide(World world, Vector3 vector3, ForgeDirection forgeDirection) {
        return vector3.clone().modifyPositionFromSide(forgeDirection).getTileEntity((IBlockAccess)world);
    }
}

