/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.vector;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector2;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3(Entity entity) {
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
    }

    public Vector3(TileEntity tileEntity) {
        this.x = tileEntity.field_70329_l;
        this.y = tileEntity.field_70330_m;
        this.z = tileEntity.field_70327_n;
    }

    public Vector3(Vec3 vec3) {
        this.x = vec3.field_72450_a;
        this.y = vec3.field_72448_b;
        this.z = vec3.field_72449_c;
    }

    public Vector3(MovingObjectPosition movingObjectPosition) {
        this.x = movingObjectPosition.field_72311_b;
        this.y = movingObjectPosition.field_72312_c;
        this.z = movingObjectPosition.field_72309_d;
    }

    public Vector3(ChunkCoordinates chunkCoordinates) {
        this.x = chunkCoordinates.field_71574_a;
        this.y = chunkCoordinates.field_71572_b;
        this.z = chunkCoordinates.field_71573_c;
    }

    public Vector3(ForgeDirection forgeDirection) {
        this.x = forgeDirection.offsetX;
        this.y = forgeDirection.offsetY;
        this.z = forgeDirection.offsetZ;
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public int getBlockID(IBlockAccess iBlockAccess) {
        return iBlockAccess.func_72798_a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(IBlockAccess iBlockAccess) {
        return iBlockAccess.func_72805_g(this.intX(), this.intY(), this.intZ());
    }

    public TileEntity getTileEntity(IBlockAccess iBlockAccess) {
        return iBlockAccess.func_72796_p(this.intX(), this.intY(), this.intZ());
    }

    public boolean setBlock(World world, int n, int n2, int n3) {
        return world.func_72832_d(this.intX(), this.intY(), this.intZ(), n, n2, n3);
    }

    public boolean setBlock(World world, int n, int n2) {
        return this.setBlock(world, n, n2, 3);
    }

    public boolean setBlock(World world, int n) {
        return this.setBlock(world, n, 0);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.multiply(1.0 / d);
        }
        return this;
    }

    public static double distance(Vector3 vector3, Vector3 vector32) {
        double d = vector3.x - vector32.x;
        double d2 = vector3.y - vector32.y;
        double d3 = vector3.z - vector32.z;
        return MathHelper.func_76133_a((double)(d * d + d2 * d2 + d3 * d3));
    }

    public double distanceTo(Vector3 vector3) {
        double d = vector3.x - this.x;
        double d2 = vector3.y - this.y;
        double d3 = vector3.z - this.z;
        return MathHelper.func_76133_a((double)(d * d + d2 * d2 + d3 * d3));
    }

    public Vector3 add(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
        return this;
    }

    public Vector3 add(double d) {
        this.x += d;
        this.y += d;
        this.z += d;
        return this;
    }

    public Vector3 subtract(Vector3 vector3) {
        this.x -= vector3.x;
        this.y -= vector3.y;
        this.z -= vector3.z;
        return this;
    }

    public Vector3 invert() {
        this.multiply(-1.0);
        return this;
    }

    public Vector3 multiply(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vector3 multiply(Vector3 vector3) {
        this.x *= vector3.x;
        this.y *= vector3.y;
        this.z *= vector3.z;
        return this;
    }

    public static Vector3 subtract(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x - vector32.x, vector3.y - vector32.y, vector3.z - vector32.z);
    }

    public static Vector3 add(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x + vector32.x, vector3.y + vector32.y, vector3.z + vector32.z);
    }

    public static Vector3 add(Vector3 vector3, double d) {
        return new Vector3(vector3.x + d, vector3.y + d, vector3.z + d);
    }

    public static Vector3 multiply(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x * vector32.x, vector3.y * vector32.y, vector3.z * vector32.z);
    }

    public static Vector3 multiply(Vector3 vector3, double d) {
        return new Vector3(vector3.x * d, vector3.y * d, vector3.z * d);
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public List getEntitiesWithin(World world, Class clazz) {
        return world.func_72872_a(clazz, AxisAlignedBB.func_72330_a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3 modifyPositionFromSide(ForgeDirection forgeDirection, double d) {
        switch (forgeDirection.ordinal()) {
            case 0: {
                this.y -= d;
                break;
            }
            case 1: {
                this.y += d;
                break;
            }
            case 2: {
                this.z -= d;
                break;
            }
            case 3: {
                this.z += d;
                break;
            }
            case 4: {
                this.x -= d;
                break;
            }
            case 5: {
                this.x += d;
            }
        }
        return this;
    }

    public Vector3 modifyPositionFromSide(ForgeDirection forgeDirection) {
        this.modifyPositionFromSide(forgeDirection, 1.0);
        return this;
    }

    public static Vector3 readFromNBT(NBTTagCompound nBTTagCompound) {
        Vector3 vector3 = new Vector3();
        vector3.x = nBTTagCompound.func_74769_h("x");
        vector3.y = nBTTagCompound.func_74769_h("y");
        vector3.z = nBTTagCompound.func_74769_h("z");
        return vector3;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74780_a("x", this.x);
        nBTTagCompound.func_74780_a("y", this.y);
        nBTTagCompound.func_74780_a("z", this.z);
        return nBTTagCompound;
    }

    public int hashCode() {
        return ("X:" + this.x + "Y:" + this.y + "Z:" + this.z).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Vector3) {
            Vector3 vector3 = (Vector3)object;
            return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
        }
        return false;
    }

    public String toString() {
        return "Vector3 [" + this.x + "," + this.y + "," + this.z + "]";
    }
}

