/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.oredict.OreDictTracker;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUnifier;
import powercrystals.minefactoryreloaded.gui.container.ContainerUnifier;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityUnifier
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private LiquidTank _tank;
    private LiquidStack _biofuel;
    private LiquidStack _ethanol;
    private Map _preferredOutputs = new HashMap();

    public TileEntityUnifier() {
        this._tank = new LiquidTank(4000);
        this._biofuel = LiquidDictionary.getLiquid((String)"biofuel", (int)1);
        this._ethanol = LiquidDictionary.getLiquid((String)"ethanol", (int)1);
    }

    @Override
    public String getGuiBackground() {
        return "unifier.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUnifier(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerUnifier getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerUnifier(this, inventoryPlayer);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            ItemStack itemStack = null;
            if (this._inventory[0] != null) {
                List list = OreDictTracker.getNamesFromItem((ItemStack)this._inventory[0]);
                if (list == null || list.size() != 1) {
                    itemStack = this._inventory[0].func_77946_l();
                } else if (this._preferredOutputs.containsKey(list.get(0))) {
                    itemStack = ((ItemStack)this._preferredOutputs.get(list.get(0))).func_77946_l();
                    itemStack.field_77994_a = this._inventory[0].field_77994_a;
                } else {
                    itemStack = ((ItemStack)OreDictionary.getOres((String)((String)list.get(0))).get(0)).func_77946_l();
                    itemStack.field_77994_a = this._inventory[0].field_77994_a;
                }
                this.moveItemStack(itemStack);
            }
        }
    }

    private void moveItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        int n = itemStack.field_77994_a;
        if (this._inventory[1] == null) {
            n = Math.min(this.func_70297_j_(), itemStack.func_77976_d());
        } else {
            if (itemStack.field_77993_c != this._inventory[1].field_77993_c || itemStack.func_77960_j() != this._inventory[1].func_77960_j()) {
                return;
            }
            if (itemStack.func_77978_p() != null || this._inventory[1].func_77978_p() != null) {
                return;
            }
            n = Math.min(this._inventory[0].field_77994_a, this._inventory[1].func_77976_d() - this._inventory[1].field_77994_a);
        }
        if (this._inventory[1] == null) {
            this._inventory[1] = itemStack.func_77946_l();
            this._inventory[0].field_77994_a -= itemStack.field_77994_a;
        } else {
            this._inventory[1].field_77994_a += n;
            this._inventory[0].field_77994_a -= n;
        }
        if (this._inventory[0].field_77994_a == 0) {
            this._inventory[0] = null;
        }
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._preferredOutputs.clear();
        for (int i = 2; i < 11; ++i) {
            List list;
            if (this._inventory[i] == null || (list = OreDictTracker.getNamesFromItem((ItemStack)this._inventory[i])) == null) continue;
            for (String string : list) {
                this._preferredOutputs.put(string, this._inventory[i].func_77946_l());
            }
        }
    }

    public int func_70302_i_() {
        return 11;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n < 2;
    }

    public String func_70303_b() {
        return "Unifier";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 11;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        if (this._biofuel == null || this._ethanol == null || liquidStack == null) {
            return 0;
        }
        if (liquidStack.itemID == this._ethanol.itemID && liquidStack.itemMeta == this._ethanol.itemMeta) {
            return this._tank.fill(new LiquidStack(this._biofuel.itemID, liquidStack.amount, this._biofuel.itemMeta), bl);
        }
        if (liquidStack.itemID == this._biofuel.itemID && liquidStack.itemMeta == this._biofuel.itemMeta) {
            return this._tank.fill(new LiquidStack(this._ethanol.itemID, liquidStack.amount, this._ethanol.itemMeta), bl);
        }
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.fill(ForgeDirection.UNKNOWN, liquidStack, bl);
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this._tank.drain(n, bl);
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return this._tank.drain(n2, bl);
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }
}

