/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.minefactoryreloaded.core.GrinderDamageSource;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntitySlaughterhouse
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private HarvestAreaManager _areaManager;
    private LiquidTank _tank;
    private DamageSource _damageSource = new GrinderDamageSource("slaughterhouse");

    public TileEntitySlaughterhouse() {
        super(Machine.Slaughterhouse);
        this._areaManager = new HarvestAreaManager(this, 2, 2, 1);
        this._tank = new LiquidTank(4000);
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public String func_70303_b() {
        return "Slaughterhouse";
    }

    @Override
    public String getGuiBackground() {
        return "slaughterhouse.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean activateMachine() {
        double d = 0.0;
        List list = this.field_70331_k.func_72872_a(EntityLiving.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
        for (Object e : list) {
            EntityLiving entityLiving;
            if (e instanceof EntityPlayer || e instanceof EntityAgeable && ((EntityAgeable)e).func_70874_b() < 0 || (entityLiving = (EntityLiving)e).func_70630_aN() <= 0) continue;
            d = Math.pow(entityLiving.field_70121_D.func_72320_b(), 2.0);
            if (this.field_70331_k.func_82736_K().func_82766_b("doMobLoot")) {
                try {
                    this.field_70331_k.func_82736_K().func_82764_b("doMobLoot", "false");
                    entityLiving.func_70097_a(this._damageSource, 500000);
                    break;
                }
                finally {
                    this.field_70331_k.func_82736_K().func_82764_b("doMobLoot", "true");
                }
            }
            entityLiving.func_70097_a(this._damageSource, 500000);
            break;
        }
        if (d == 0.0) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        if (this.field_70331_k.field_73012_v.nextInt(8) == 0) {
            this._tank.fill(LiquidDictionary.getLiquid((String)"pinkslime", (int)((int)(100.0 * d))), true);
        } else {
            this._tank.fill(LiquidDictionary.getLiquid((String)"meat", (int)((int)(100.0 * d))), true);
        }
        this.setIdleTicks(10);
        return true;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }
}

