/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiSewer;
import powercrystals.minefactoryreloaded.gui.container.ContainerSewer;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntitySewer
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private LiquidTank _tank = new LiquidTank(1000);
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 0, 1, 0);
    private int _tick;
    private long _nextSewerCheckTick;
    private boolean _jammed;

    public TileEntitySewer() {
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
    }

    @Override
    public String getGuiBackground() {
        return "sewagecollector.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiSewer(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerSewer getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerSewer(this, inventoryPlayer);
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public void func_70316_g() {
        Object object;
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ++this._tick;
        if (this._nextSewerCheckTick <= this.field_70331_k.func_82737_E()) {
            object = new Area(BlockPosition.fromFactoryTile((IRotateableTile)this), this._areaManager.getRadius(), 0, 0);
            this._jammed = false;
            for (BlockPosition blockPosition : object.getPositionsBottomFirst()) {
                if (this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z) != ((Block)MineFactoryReloadedCore.machineBlocks.get((Object)Integer.valueOf((int)0))).field_71990_ca || this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z) != Machine.Sewer.getMeta() || blockPosition.x == this.field_70329_l && blockPosition.y == this.field_70330_m && blockPosition.z == this.field_70327_n) continue;
                this._jammed = true;
                break;
            }
            this._nextSewerCheckTick = this.field_70331_k.func_82737_E() + 800L + (long)this.field_70331_k.field_73012_v.nextInt(800);
        }
        if (this._tick >= 31 && !this._jammed) {
            this._tick = 0;
            object = this.field_70331_k.func_72872_a(EntityLiving.class, this._areaManager.getHarvestArea().toAxisAlignedBB());
            double d = 0.0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof EntityAnimal || e instanceof EntityVillager) {
                    d += Math.pow(((EntityLiving)e).field_70121_D.func_72320_b(), 2.0);
                    continue;
                }
                if (!(e instanceof EntityPlayer) || !((EntityPlayer)e).func_70093_af()) continue;
                d += Math.pow(((EntityLiving)e).field_70121_D.func_72320_b(), 2.0);
            }
            this._tank.fill(LiquidDictionary.getLiquid((String)"sewage", (int)((int)(25.0 * d))), true);
        }
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        return this._tank;
    }

    public int func_70302_i_() {
        return 1;
    }

    public String func_70303_b() {
        return "Sewer";
    }
}

