/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiPlanter;
import powercrystals.minefactoryreloaded.gui.container.ContainerPlanter;
import powercrystals.minefactoryreloaded.gui.container.ContainerUpgradable;
import powercrystals.minefactoryreloaded.item.ItemUpgrade;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityPlanter
extends TileEntityFactoryPowered {
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);

    public TileEntityPlanter() {
        super(Machine.Planter);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
    }

    @Override
    public String getGuiBackground() {
        return "planter.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiPlanter(this.getContainer(inventoryPlayer), (TileEntityFactoryPowered)this);
    }

    @Override
    public ContainerUpgradable getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerPlanter(this, inventoryPlayer);
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[9]);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = this._areaManager.getNextBlock().copy();
        ++blockPosition.y;
        ItemStack itemStack = this._inventory[this.getPlanterSlotIdFromBp(blockPosition)];
        for (int i = 10; i <= 25; ++i) {
            IFactoryPlantable iFactoryPlantable;
            ItemStack itemStack2 = this.func_70301_a(i);
            if (itemStack2 == null || itemStack != null && (itemStack.field_77993_c != itemStack2.field_77993_c || itemStack.func_77960_j() != itemStack2.func_77960_j()) || !MFRRegistry.getPlantables().containsKey(new Integer(itemStack2.field_77993_c)) || !(iFactoryPlantable = (IFactoryPlantable)MFRRegistry.getPlantables().get(new Integer(itemStack2.field_77993_c))).canBePlantedHere(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2)) continue;
            iFactoryPlantable.prePlant(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2);
            this.field_70331_k.func_72832_d(blockPosition.x, blockPosition.y, blockPosition.z, iFactoryPlantable.getPlantedBlockId(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2), iFactoryPlantable.getPlantedBlockMetadata(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2), 3);
            iFactoryPlantable.postPlant(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, itemStack2);
            this.func_70298_a(i, 1);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public String func_70303_b() {
        return "Planter";
    }

    private int getPlanterSlotIdFromBp(BlockPosition blockPosition) {
        int n = this._areaManager.getRadius();
        int n2 = Math.round(1.49f * (float)(blockPosition.x - this.field_70329_l) / (float)n);
        int n3 = Math.round(1.49f * (float)(blockPosition.z - this.field_70327_n) / (float)n);
        return 4 + n2 + 3 * n3;
    }

    public int func_70302_i_() {
        return 26;
    }

    @Override
    public int getEnergyStoredMax() {
        return 8000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n > 8;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 17;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (n > 9) {
            return true;
        }
        if (n == 9) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n >= 10;
    }
}

