/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquidRouter;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerLiquidRouter;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityLiquidRouter
extends TileEntityFactoryInventory
implements ITankContainer {
    private LiquidTank[] _bufferTanks = new LiquidTank[6];
    private static final ForgeDirection[] _outputDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};

    public TileEntityLiquidRouter() {
        for (int i = 0; i < 6; ++i) {
            this._bufferTanks[i] = new LiquidTank(1000);
            this._bufferTanks[i].setTankPressure(-1);
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        for (int i = 0; i < 6; ++i) {
            if (this._bufferTanks[i].getLiquid() == null || this._bufferTanks[i].getLiquid().amount <= 0) continue;
            this._bufferTanks[i].getLiquid().amount -= this.pumpLiquid(this._bufferTanks[i].getLiquid(), true);
        }
    }

    private int pumpLiquid(LiquidStack liquidStack, boolean bl) {
        if (liquidStack == null || liquidStack.itemID <= 0 || liquidStack.amount <= 0) {
            return 0;
        }
        int n = liquidStack.amount;
        int[] nArray = this.getRoutesForLiquid(liquidStack);
        int[] nArray2 = this.getDefaultRoutes();
        if (this.hasRoutes(nArray)) {
            n = this.weightedRouteLiquid(liquidStack, nArray, n, bl);
        } else if (this.hasRoutes(nArray2)) {
            n = this.weightedRouteLiquid(liquidStack, nArray2, n, bl);
        }
        return liquidStack.amount - n;
    }

    private int weightedRouteLiquid(LiquidStack liquidStack, int[] nArray, int n, boolean bl) {
        TileEntity tileEntity;
        int n2;
        if (n >= this.totalWeight(nArray)) {
            n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                TileEntity tileEntity2 = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)_outputDirections[i]);
                int n3 = n2 * nArray[i] / this.totalWeight(nArray);
                if (tileEntity2 != null && tileEntity2 instanceof ITankContainer && n3 > 0 && (n -= ((ITankContainer)tileEntity2).fill(_outputDirections[i].getOpposite(), new LiquidStack(liquidStack.itemID, n3, liquidStack.itemMeta), bl)) <= 0) break;
            }
        }
        if (0 < n && n < this.totalWeight(nArray) && (tileEntity = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)_outputDirections[n2 = this.weightedRandomSide(nArray)])) != null && tileEntity instanceof ITankContainer) {
            n -= ((ITankContainer)tileEntity).fill(_outputDirections[n2].getOpposite(), new LiquidStack(liquidStack.itemID, n, liquidStack.itemMeta), bl);
        }
        return n;
    }

    private int weightedRandomSide(int[] nArray) {
        int n = this.field_70331_k.field_73012_v.nextInt(this.totalWeight(nArray));
        for (int i = 0; i < nArray.length; ++i) {
            if ((n -= nArray[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    private int totalWeight(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private boolean hasRoutes(int[] nArray) {
        for (int n : nArray) {
            if (n <= 0) continue;
            return true;
        }
        return false;
    }

    private int[] getRoutesForLiquid(LiquidStack liquidStack) {
        int[] nArray = new int[6];
        for (int i = 0; i < 6; ++i) {
            nArray[i] = LiquidContainerRegistry.containsLiquid((ItemStack)this._inventory[i], (LiquidStack)liquidStack) ? this._inventory[i].field_77994_a : 0;
        }
        return nArray;
    }

    private int[] getDefaultRoutes() {
        int[] nArray = new int[6];
        for (int i = 0; i < 6; ++i) {
            nArray[i] = LiquidContainerRegistry.isEmptyContainer((ItemStack)this._inventory[i]) ? this._inventory[i].field_77994_a : 0;
        }
        return nArray;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        return this.pumpLiquid(liquidStack, bl);
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.pumpLiquid(liquidStack, bl);
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._bufferTanks[forgeDirection.ordinal()]};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        if (LiquidContainerRegistry.containsLiquid((ItemStack)this._inventory[forgeDirection.ordinal()], (LiquidStack)liquidStack)) {
            return this._bufferTanks[forgeDirection.ordinal()];
        }
        return null;
    }

    public int func_70302_i_() {
        return 6;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return false;
    }

    public String func_70303_b() {
        return "Liquid Router";
    }

    @Override
    public String getGuiBackground() {
        return "liquidrouter.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquidRouter((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerLiquidRouter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLiquidRouter(this, inventoryPlayer);
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }
}

