/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFisher
extends TileEntityFactoryPowered {
    public TileEntityFisher() {
        super(Machine.Fisher);
    }

    @Override
    public String getGuiBackground() {
        return "fisher.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = BlockPosition.fromFactoryTile((IRotateableTile)this);
        blockPosition.moveDown(1);
        Area area = new Area(blockPosition, 1, 0, 0);
        for (BlockPosition blockPosition2 : area.getPositionsBottomFirst()) {
            if (this.field_70331_k.func_72798_a(blockPosition2.x, blockPosition2.y, blockPosition2.z) == Block.field_71943_B.field_71990_ca) continue;
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        this.setWorkDone(this.getWorkDone() + 1);
        if (this.getWorkDone() > this.getWorkMax()) {
            UtilInventory.dropStack((TileEntity)this, (ItemStack)new ItemStack(Item.field_77754_aU), (ForgeDirection)this.getDropDirection());
            this.setWorkDone(0);
        }
        return true;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 900;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    public String func_70303_b() {
        return "Fisher";
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }
}

