/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityComposter
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private LiquidTank _tank = new LiquidTank(4000);

    public TileEntityComposter() {
        super(Machine.Composter);
    }

    @Override
    public String getGuiBackground() {
        return "composter.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean activateMachine() {
        if (this._tank.getLiquid() != null && this._tank.getLiquid().amount >= 20) {
            this.setWorkDone(this.getWorkDone() + 1);
            if (this.getWorkDone() >= this.getWorkMax()) {
                UtilInventory.dropStack((TileEntity)this, (ItemStack)new ItemStack(MineFactoryReloadedCore.fertilizerItem), (ForgeDirection)this.getDropDirection());
                this.setWorkDone(0);
            }
            this._tank.drain(20, true);
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 100;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, LiquidStack liquidStack, boolean bl) {
        if (liquidStack == null || liquidStack.itemID != LiquidDictionary.getCanonicalLiquid((String)"sewage").itemID) {
            return 0;
        }
        return this._tank.fill(liquidStack, bl);
    }

    public int fill(int n, LiquidStack liquidStack, boolean bl) {
        return this.fill(ForgeDirection.UNKNOWN, liquidStack, bl);
    }

    public LiquidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public LiquidStack drain(int n, int n2, boolean bl) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection forgeDirection) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection forgeDirection, LiquidStack liquidStack) {
        if (liquidStack != null && liquidStack.itemID == LiquidDictionary.getCanonicalLiquid((String)"sewage").itemID) {
            return this._tank;
        }
        return null;
    }

    @Override
    public String func_70303_b() {
        return "Composter";
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }
}

