/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.core.util.Util;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityBlockBreaker
extends TileEntityFactoryPowered {
    public TileEntityBlockBreaker() {
        super(Machine.BlockBreaker);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = BlockPosition.fromFactoryTile((IRotateableTile)this);
        blockPosition.moveForwards(1);
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        int n2 = this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        Block block = Block.field_71973_m[n];
        if (block != null && !block.isAirBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z) && !Util.isBlockUnbreakable((World)this.field_70331_k, (int)blockPosition.x, (int)blockPosition.y, (int)blockPosition.z) && block.func_71934_m(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z) >= 0.0f) {
            ArrayList arrayList = block.getBlockDropped(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, n2, 0);
            for (ItemStack itemStack : arrayList) {
                UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection)this.getDropDirection());
            }
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_70331_k.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, n + (n2 << 12));
            }
            this.field_70331_k.func_94571_i(blockPosition.x, blockPosition.y, blockPosition.z);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    @Override
    public int getEnergyStoredMax() {
        return 64000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 20;
    }

    @Override
    public String func_70303_b() {
        return "Block Breaker";
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean canRotate() {
        return true;
    }
}

