/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.core.power.PowerProviderAdvanced;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class TileEntityFactoryPowered
extends TileEntityFactoryInventory
implements IPowerReceptor,
IEnergySink,
IVoltage,
IConnector {
    public static final int energyPerEU = 4;
    public static final int energyPerMJ = 10;
    public static final int wPerEnergy = 7;
    private int _energyStored;
    protected int _energyActivation;
    private int _workDone;
    private int _idleTicks;
    private IPowerProvider _powerProvider;
    private boolean _isAddedToIC2EnergyNet;
    private boolean _addToNetOnNextTick;
    private int _ueBuffer;

    protected TileEntityFactoryPowered(Machine machine) {
        this(machine.getActivationEnergyMJ());
    }

    protected TileEntityFactoryPowered(int n) {
        this._energyActivation = n * 10;
        this._powerProvider = new PowerProviderAdvanced();
        this._powerProvider.configure(25, 10, 10, 1, 1000);
        this.setIsActive(false);
    }

    public abstract String func_70303_b();

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this._energyStored = Math.min(this._energyStored, this.getEnergyStoredMax());
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._addToNetOnNextTick) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this._addToNetOnNextTick = false;
            this._isAddedToIC2EnergyNet = true;
        }
        if (this.getPowerProvider() != null) {
            this.getPowerProvider().update(this);
            int n = Math.min((this.getEnergyStoredMax() - this.getEnergyStored()) / 10, 100);
            if (this._energyStored < this.getEnergyStoredMax() && this.getPowerProvider().useEnergy(1.0f, n, false) > 0.0f) {
                int n2 = (int)this.getPowerProvider().useEnergy(1.0f, n, true);
                this._energyStored += n2 * 10;
            }
        }
        ElectricityPack electricityPack = new ElectricityPack((double)((this.getEnergyStoredMax() - this.getEnergyStored()) * 7) / this.getVoltage(), this.getVoltage());
        ElectricityPack electricityPack2 = ElectricityNetworkHelper.consumeFromMultipleSides(this, electricityPack);
        this._ueBuffer = (int)((double)this._ueBuffer + electricityPack2.getWatts());
        int n = Math.min(this._ueBuffer / 7, this.getEnergyStoredMax() - this.getEnergyStored());
        this._energyStored += n;
        this._ueBuffer -= n * 7;
        this.setIsActive(this._energyStored >= this._energyActivation * 2);
        if (Util.isRedstonePowered((TileEntity)this)) {
            this.setIdleTicks(this.getIdleTicksMax());
        } else if (this._idleTicks > 0) {
            --this._idleTicks;
        } else if (this._energyStored >= this._energyActivation && this.activateMachine()) {
            this._energyStored -= this._energyActivation;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this._isAddedToIC2EnergyNet) {
            this._addToNetOnNextTick = true;
        }
    }

    public void func_70313_j() {
        if (this._isAddedToIC2EnergyNet) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this._isAddedToIC2EnergyNet = false;
        }
        ElectricityNetworkHelper.invalidate(this);
        super.func_70313_j();
    }

    protected abstract boolean activateMachine();

    public void onBlockBroken() {
        if (this._isAddedToIC2EnergyNet) {
            this._isAddedToIC2EnergyNet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public abstract int getEnergyStoredMax();

    public void setEnergyStored(int n) {
        this._energyStored = n;
    }

    public int getWorkDone() {
        return this._workDone;
    }

    public abstract int getWorkMax();

    public void setWorkDone(int n) {
        this._workDone = n;
    }

    public int getIdleTicks() {
        return this._idleTicks;
    }

    public abstract int getIdleTicksMax();

    public void setIdleTicks(int n) {
        this._idleTicks = n;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("energyStored", this._energyStored);
        nBTTagCompound.func_74768_a("workDone", this._workDone);
        nBTTagCompound.func_74768_a("ueBuffer", this._ueBuffer);
        this._powerProvider.writeToNBT(nBTTagCompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._energyStored = Math.min(nBTTagCompound.func_74762_e("energyStored"), this.getEnergyStoredMax());
        this._workDone = Math.min(nBTTagCompound.func_74762_e("workDone"), this.getWorkMax());
        this._ueBuffer = nBTTagCompound.func_74762_e("ueBuffer");
        this._powerProvider.readFromNBT(nBTTagCompound);
        this._powerProvider.configure(25, 10, 10, 1, 1000);
    }

    @Override
    public void setPowerProvider(IPowerProvider iPowerProvider) {
        this._powerProvider = iPowerProvider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this._powerProvider;
    }

    @Override
    public int powerRequest(ForgeDirection forgeDirection) {
        return Math.max((this.getEnergyStoredMax() - this.getEnergyStored()) / 10, 0);
    }

    @Override
    public final void doWork() {
    }

    @Override
    public int demandsEnergy() {
        return (this.getEnergyStoredMax() - this._energyStored) / 4;
    }

    @Override
    public int injectEnergy(Direction direction, int n) {
        int n2 = Math.min(this.demandsEnergy(), n);
        this._energyStored += n2 * 4;
        return n - n2;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this._isAddedToIC2EnergyNet;
    }

    @Override
    public int getMaxSafeInput() {
        return 128;
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }

    @Override
    public boolean canConnect(ForgeDirection forgeDirection) {
        return true;
    }
}

