/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import powercrystals.core.random.WeightedRandomItemStack;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.IRandomMobProvider;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;

public abstract class MFRRegistry {
    private static Map _plantables = new HashMap();
    private static Map _harvestables = new HashMap();
    private static Map _fertilizers = new HashMap();
    private static Map _fertilizables = new HashMap();
    private static Map _ranchables = new HashMap();
    private static Map _grindables = new HashMap();
    private static Map _breederFoods = new HashMap();
    private static Map _liquidDrinkHandlers = new HashMap();
    private static List _fruitLogBlocks = new ArrayList();
    private static Map _fruitBlocks = new HashMap();
    private static List _sludgeDrops = new ArrayList();
    private static List _eggHandlers = new ArrayList();
    private static List _safariNetHandlers = new ArrayList();
    private static List _rubberTreeBiomes = new ArrayList();
    private static List _safariNetBlacklist = new ArrayList();
    private static List _randomMobProviders = new ArrayList();
    private static List _redNetLogicCircuits = new ArrayList();
    private static List _laserOres = new ArrayList();
    private static List _autoSpawnerBlacklist = new ArrayList();
    private static ItemStack[] _laserPreferredOres = new ItemStack[16];

    public static void registerPlantable(IFactoryPlantable iFactoryPlantable) {
        _plantables.put(new Integer(iFactoryPlantable.getSeedId()), iFactoryPlantable);
    }

    public static Map getPlantables() {
        return _plantables;
    }

    public static void registerHarvestable(IFactoryHarvestable iFactoryHarvestable) {
        _harvestables.put(iFactoryHarvestable.getPlantId(), iFactoryHarvestable);
    }

    public static Map getHarvestables() {
        return _harvestables;
    }

    public static void registerFertilizable(IFactoryFertilizable iFactoryFertilizable) {
        _fertilizables.put(iFactoryFertilizable.getFertilizableBlockId(), iFactoryFertilizable);
    }

    public static Map getFertilizables() {
        return _fertilizables;
    }

    public static void registerFertilizer(IFactoryFertilizer iFactoryFertilizer) {
        Integer n = new Integer(iFactoryFertilizer.getFertilizerId());
        if (!_fertilizers.containsKey(n)) {
            _fertilizers.put(n, iFactoryFertilizer);
        }
    }

    public static Map getFertilizers() {
        return _fertilizers;
    }

    public static void registerRanchable(IFactoryRanchable iFactoryRanchable) {
        _ranchables.put(iFactoryRanchable.getRanchableEntity(), iFactoryRanchable);
    }

    public static Map getRanchables() {
        return _ranchables;
    }

    public static void registerGrindable(IFactoryGrindable iFactoryGrindable) {
        _grindables.put(iFactoryGrindable.getGrindableEntity(), iFactoryGrindable);
    }

    public static Map getGrindables() {
        return _grindables;
    }

    public static void registerSludgeDrop(int n, ItemStack itemStack) {
        _sludgeDrops.add(new WeightedRandomItemStack(n, itemStack.func_77946_l()));
    }

    public static List getSludgeDrops() {
        return _sludgeDrops;
    }

    public static void registerBreederFood(Class clazz, ItemStack itemStack) {
        if (_breederFoods.containsKey(clazz)) {
            ((List)_breederFoods.get(clazz)).add(itemStack);
        } else {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            arrayList.add(itemStack.func_77946_l());
            _breederFoods.put(clazz, arrayList);
        }
    }

    public static Map getBreederFoods() {
        return _breederFoods;
    }

    public static void registerMobEggHandler(IMobEggHandler iMobEggHandler) {
        _eggHandlers.add(iMobEggHandler);
    }

    public static List getModMobEggHandlers() {
        return _eggHandlers;
    }

    public static void registerSafariNetHandler(ISafariNetHandler iSafariNetHandler) {
        _safariNetHandlers.add(iSafariNetHandler);
    }

    public static List getSafariNetHandlers() {
        return _safariNetHandlers;
    }

    public static void registerRubberTreeBiome(String string) {
        _rubberTreeBiomes.add(string);
    }

    public static List getRubberTreeBiomes() {
        return _rubberTreeBiomes;
    }

    public static void registerSafariNetBlacklist(Class clazz) {
        _safariNetBlacklist.add(clazz);
    }

    public static List getSafariNetBlacklist() {
        return _safariNetBlacklist;
    }

    public static void registerRandomMobProvider(IRandomMobProvider iRandomMobProvider) {
        _randomMobProviders.add(iRandomMobProvider);
    }

    public static List getRandomMobProviders() {
        return _randomMobProviders;
    }

    public static void registerLiquidDrinkHandler(int n, ILiquidDrinkHandler iLiquidDrinkHandler) {
        _liquidDrinkHandlers.put(n, iLiquidDrinkHandler);
    }

    public static Map getLiquidDrinkHandlers() {
        return _liquidDrinkHandlers;
    }

    public static void registerRedNetLogicCircuit(IRedNetLogicCircuit iRedNetLogicCircuit) {
        _redNetLogicCircuits.add(iRedNetLogicCircuit);
    }

    public static List getRedNetLogicCircuits() {
        return _redNetLogicCircuits;
    }

    public static void registerLaserOre(int n, ItemStack itemStack) {
        _laserOres.add(new WeightedRandomItemStack(n, itemStack.func_77946_l()));
    }

    public static List getLaserOres() {
        return _laserOres;
    }

    public static void registerFruitLogBlockId(Integer n) {
        _fruitLogBlocks.add(n);
    }

    public static List getFruitLogBlockIds() {
        return _fruitLogBlocks;
    }

    public static void registerFruit(IFactoryFruit iFactoryFruit) {
        _fruitBlocks.put(iFactoryFruit.getSourceBlockId(), iFactoryFruit);
    }

    public static Map getFruits() {
        return _fruitBlocks;
    }

    public static void registerAutoSpawnerBlacklist(String string) {
        _autoSpawnerBlacklist.add(string);
    }

    public static List getAutoSpawnerBlacklist() {
        return _autoSpawnerBlacklist;
    }

    public static void setLaserPreferredOre(int n, ItemStack itemStack) {
        MFRRegistry._laserPreferredOres[n] = itemStack;
    }

    public static ItemStack getLaserPreferredOre(int n) {
        return _laserPreferredOres[n];
    }
}

