/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class PowerProvider
implements IPowerProvider {
    protected int latency;
    protected int minEnergyReceived;
    protected int maxEnergyReceived;
    protected int maxEnergyStored;
    protected int minActivationEnergy;
    protected float energyStored = 0.0f;
    protected int powerLoss = 1;
    protected int powerLossRegularity = 100;
    public SafeTimeTracker timeTracker = new SafeTimeTracker();
    public SafeTimeTracker energyLossTracker = new SafeTimeTracker();
    public int[] powerSources = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public SafeTimeTracker getTimeTracker() {
        return this.timeTracker;
    }

    @Override
    public int getLatency() {
        return this.latency;
    }

    @Override
    public int getMinEnergyReceived() {
        return this.minEnergyReceived;
    }

    @Override
    public int getMaxEnergyReceived() {
        return this.maxEnergyReceived;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public int getActivationEnergy() {
        return this.minActivationEnergy;
    }

    @Override
    public float getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public void configure(int n, int n2, int n3, int n4, int n5) {
        this.latency = n;
        this.minEnergyReceived = n2;
        this.maxEnergyReceived = n3;
        this.maxEnergyStored = n5;
        this.minActivationEnergy = n4;
    }

    @Override
    public void configurePowerPerdition(int n, int n2) {
        this.powerLoss = n;
        this.powerLossRegularity = n2;
    }

    @Override
    public boolean update(IPowerReceptor iPowerReceptor) {
        if (!this.preConditions(iPowerReceptor)) {
            return false;
        }
        TileEntity tileEntity = (TileEntity)iPowerReceptor;
        boolean bl = false;
        if (this.energyStored >= (float)this.minActivationEnergy) {
            if (this.latency == 0) {
                iPowerReceptor.doWork();
                bl = true;
            } else if (this.timeTracker.markTimeIfDelay(tileEntity.field_70331_k, this.latency)) {
                iPowerReceptor.doWork();
                bl = true;
            }
        }
        if (this.powerLoss > 0 && this.energyLossTracker.markTimeIfDelay(tileEntity.field_70331_k, this.powerLossRegularity)) {
            this.energyStored -= (float)this.powerLoss;
            if (this.energyStored < 0.0f) {
                this.energyStored = 0.0f;
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (this.powerSources[i] <= 0) continue;
            int n = i;
            this.powerSources[n] = this.powerSources[n] - 1;
        }
        return bl;
    }

    @Override
    public boolean preConditions(IPowerReceptor iPowerReceptor) {
        return true;
    }

    @Override
    public float useEnergy(float f, float f2, boolean bl) {
        float f3 = 0.0f;
        if (this.energyStored >= f) {
            if (this.energyStored <= f2) {
                f3 = this.energyStored;
                if (bl) {
                    this.energyStored = 0.0f;
                }
            } else {
                f3 = f2;
                if (bl) {
                    this.energyStored -= f2;
                }
            }
        }
        return f3;
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.latency = nBTTagCompound.func_74762_e("latency");
        this.minEnergyReceived = nBTTagCompound.func_74762_e("minEnergyReceived");
        this.maxEnergyReceived = nBTTagCompound.func_74762_e("maxEnergyReceived");
        this.maxEnergyStored = nBTTagCompound.func_74762_e("maxStoreEnergy");
        this.minActivationEnergy = nBTTagCompound.func_74762_e("minActivationEnergy");
        try {
            this.energyStored = nBTTagCompound.func_74760_g("storedEnergy");
        }
        catch (Throwable throwable) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("latency", this.latency);
        nBTTagCompound.func_74768_a("minEnergyReceived", this.minEnergyReceived);
        nBTTagCompound.func_74768_a("maxEnergyReceived", this.maxEnergyReceived);
        nBTTagCompound.func_74768_a("maxStoreEnergy", this.maxEnergyStored);
        nBTTagCompound.func_74768_a("minActivationEnergy", this.minActivationEnergy);
        nBTTagCompound.func_74776_a("storedEnergy", this.energyStored);
    }

    @Override
    public void receiveEnergy(float f, ForgeDirection forgeDirection) {
        this.powerSources[forgeDirection.ordinal()] = 2;
        this.energyStored += f;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public boolean isPowerSource(ForgeDirection forgeDirection) {
        return this.powerSources[forgeDirection.ordinal()] != 0;
    }
}

