/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class Position {
    public double x;
    public double y;
    public double z;
    public ForgeDirection orientation;

    public Position(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(double d, double d2, double d3, ForgeDirection forgeDirection) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.orientation = forgeDirection;
    }

    public Position(Position position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.orientation = position.orientation;
    }

    public Position(NBTTagCompound nBTTagCompound) {
        this.x = nBTTagCompound.func_74769_h("i");
        this.y = nBTTagCompound.func_74769_h("j");
        this.z = nBTTagCompound.func_74769_h("k");
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(TileEntity tileEntity) {
        this.x = tileEntity.field_70329_l;
        this.y = tileEntity.field_70330_m;
        this.z = tileEntity.field_70327_n;
    }

    public void moveRight(double d) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= d;
                break;
            }
            case NORTH: {
                this.x += d;
                break;
            }
            case EAST: {
                this.z += d;
                break;
            }
            case WEST: {
                this.z -= d;
                break;
            }
        }
    }

    public void moveLeft(double d) {
        this.moveRight(-d);
    }

    public void moveForwards(double d) {
        switch (this.orientation) {
            case UP: {
                this.y += d;
                break;
            }
            case DOWN: {
                this.y -= d;
                break;
            }
            case SOUTH: {
                this.z += d;
                break;
            }
            case NORTH: {
                this.z -= d;
                break;
            }
            case EAST: {
                this.x += d;
                break;
            }
            case WEST: {
                this.x -= d;
                break;
            }
        }
    }

    public void moveBackwards(double d) {
        this.moveForwards(-d);
    }

    public void moveUp(double d) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += d;
                break;
            }
        }
    }

    public void moveDown(double d) {
        this.moveUp(-d);
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74780_a("i", this.x);
        nBTTagCompound.func_74780_a("j", this.y);
        nBTTagCompound.func_74780_a("k", this.z);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public Position min(Position position) {
        return new Position(position.x > this.x ? this.x : position.x, position.y > this.y ? this.y : position.y, position.z > this.z ? this.z : position.z);
    }

    public Position max(Position position) {
        return new Position(position.x < this.x ? this.x : position.x, position.y < this.y ? this.y : position.y, position.z < this.z ? this.z : position.z);
    }
}

