/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Mod.Blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFluidRoot
extends Block {
    public static final Map displacementIds = new HashMap();
    public int quantaPerBlock = 8;
    public float quantaPerBlockFloat = 8.0f;
    public int density = 1;
    public int densityDir = -1;
    public int tickRate = 20;
    public int renderPass = 1;
    public int maxScaledLight = 0;

    public BlockFluidRoot(int id, Material material) {
        super(id, material);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_71907_b(true);
        this.func_71896_v();
    }

    public BlockFluidRoot setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidRoot setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidRoot setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidRoot setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockFluidRoot setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(bId)) {
            return (Boolean)displacementIds.get(bId);
        }
        Material material = Block.field_71973_m[bId].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76237_B;
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(bId)) {
            if (((Boolean)displacementIds.get(bId)).booleanValue()) {
                Block.field_71973_m[bId].func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
                return true;
            }
            return false;
        }
        Material material = Block.field_71973_m[bId].field_72018_cp;
        if (material.func_76230_c() || material == Material.field_76237_B) {
            return false;
        }
        Block.field_71973_m[bId].func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
        return true;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public boolean func_82506_l() {
        return false;
    }

    public boolean func_71913_a(int meta, boolean fullHit) {
        return fullHit && meta == this.quantaPerBlock - 1;
    }

    public boolean func_71918_c(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int func_71925_a(Random par1Random) {
        return 0;
    }

    public int func_71859_p_(World world) {
        return this.tickRate;
    }

    public void func_71901_a(World world, int x, int y, int z, Entity entity, Vec3 vec) {
        if (this.densityDir > 0) {
            return;
        }
        Vec3 vec_flow = this.getFlowVector((IBlockAccess)world, x, y, z);
        vec.field_72450_a += vec_flow.field_72450_a * (double)(this.quantaPerBlock * 4);
        vec.field_72448_b += vec_flow.field_72448_b * (double)(this.quantaPerBlock * 4);
        vec.field_72449_c += vec_flow.field_72449_c * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y, z);
        }
        int data = world.func_72805_g(x, y, z);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_71870_f(IBlockAccess world, int x, int y, int z) {
        float lightUp;
        float lightThis = world.func_72801_o(x, y, z);
        return lightThis > (lightUp = world.func_72801_o(x, y + 1, z)) ? lightThis : lightUp;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71874_e(IBlockAccess world, int x, int y, int z) {
        int lightThis = world.func_72802_i(x, y, z, 0);
        int lightUp = world.func_72802_i(x, y + 1, z, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71856_s_() {
        return this.renderPass;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return !world.func_72804_r(x, y, z);
        }
        Material mat = world.func_72803_f(x, y, z);
        return mat == this.field_72018_cp ? false : super.func_71877_c(world, x, y, z, side);
    }

    public static final int getDensity(IBlockAccess world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (!(block instanceof BlockFluidRoot)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidRoot)block).density;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getFlowDirection(IBlockAccess world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (!(Block.field_71973_m[world.func_72798_a(x, y, z)] instanceof BlockFluidRoot)) {
            return -1000.0;
        }
        Vec3 vec = ((BlockFluidRoot)block).getFlowVector(world, x, y, z);
        return vec.field_72450_a == 0.0 && vec.field_72449_c == 0.0 ? -1000.0 : Math.atan2(vec.field_72449_c, vec.field_72450_a) - 1.5707963267948966;
    }

    public final int getQuantaValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) == 0) {
            return 0;
        }
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return -1;
        }
        int quantaRemaining = world.func_72805_g(x, y, z) + 1;
        return quantaRemaining;
    }

    public final int getQuantaValueBelow(IBlockAccess world, int x, int y, int z, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(IBlockAccess world, int x, int y, int z, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(IBlockAccess world, int x, int y, int z) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public Vec3 getFlowVector(IBlockAccess world, int x, int y, int z) {
        Vec3 vec = world.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y, z);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y, z2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.func_72803_f(x2, y, z2).func_76230_c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y - 1, z2)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.func_72441_c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.func_72441_c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
        }
        if (world.func_72798_a(x, y + 1, z) == this.field_71990_ca) {
            boolean flag = false;
            if (this.func_71924_d(world, x, y, z - 1, 2)) {
                flag = true;
            } else if (this.func_71924_d(world, x, y, z + 1, 3)) {
                flag = true;
            } else if (this.func_71924_d(world, x - 1, y, z, 4)) {
                flag = true;
            } else if (this.func_71924_d(world, x + 1, y, z, 5)) {
                flag = true;
            } else if (this.func_71924_d(world, x, y + 1, z - 1, 2)) {
                flag = true;
            } else if (this.func_71924_d(world, x, y + 1, z + 1, 3)) {
                flag = true;
            } else if (this.func_71924_d(world, x - 1, y + 1, z, 4)) {
                flag = true;
            } else if (this.func_71924_d(world, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec = vec.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.func_72432_b();
        return vec;
    }

    static {
        displacementIds.put(Block.field_72054_aE.field_71990_ca, false);
        displacementIds.put(Block.field_72045_aL.field_71990_ca, false);
        displacementIds.put(Block.field_72053_aD.field_71990_ca, false);
        displacementIds.put(Block.field_72042_aI.field_71990_ca, false);
        displacementIds.put(Block.field_72040_aX.field_71990_ca, false);
    }
}

