/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.Lib;

import com.google.common.collect.BiMap;
import com.google.common.io.ByteStreams;
import denoflionsx.denLib.Mod.denLibMod;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.liquids.LiquidStack;

public class denLib {
    public static boolean debug = false;

    public static class RandomUtils {
        public static void throwCustomException(String why) {
            try {
                throw new Exception(why);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    public static class FileUtils {
        public static ArrayList getClassesInJar(File source, Class target) {
            ArrayList classes = new ArrayList();
            try {
                JarFile jarFile = new JarFile(source);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    className = className.replace('/', '.');
                    if (debug) {
                        denLibMod.Proxy.print(className);
                    }
                    Class<?> c = null;
                    try {
                        c = Class.forName(className);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    catch (NoSuchFieldError ex) {
                        denLibMod.Proxy.print("Skipping " + className + " due to SideOnly = CLIENT.");
                        ex.printStackTrace();
                        continue;
                    }
                    if (c.isInterface()) continue;
                    for (Class<?> q : c.getInterfaces()) {
                        if (!q.getName().equals(target.getName())) continue;
                        classes.add(c.newInstance());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return classes;
        }

        public static void saveBiMapToFile(BiMap map, File f) {
            FileUtils.saveObjectToFile(map, f);
        }

        public static BiMap readBiMapFromFile(File f) {
            return (BiMap)FileUtils.readObjectFromFile(f);
        }

        private static void saveObjectToFile(Object o, File f) {
            try {
                byte[] array = FileUtils.turnObjectToByteArray(o);
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(array);
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private static byte[] turnObjectToByteArray(Object o) {
            try {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                ObjectOutputStream b1 = new ObjectOutputStream(b);
                b1.writeObject(o);
                byte[] array = b.toByteArray();
                b.close();
                b1.close();
                return array;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static Object readObjectFromByteArray(byte[] bytes) {
            try {
                ByteArrayInputStream b2 = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(b2);
                Object o = ois.readObject();
                ois.close();
                return o;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private static Object readObjectFromFile(File f) {
            try {
                FileInputStream fis = new FileInputStream(f.getAbsolutePath());
                byte[] b = ByteStreams.toByteArray((InputStream)fis);
                fis.close();
                return FileUtils.readObjectFromByteArray(b);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static byte[] createSha1(File file) throws Exception {
            FileInputStream fis = new FileInputStream(file);
            return FileUtils.createSha1(fis);
        }

        public static byte[] createSha1(InputStream fis) throws Exception {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            int n = 0;
            byte[] buffer = new byte[8192];
            while (n != -1) {
                n = fis.read(buffer);
                if (n <= 0) continue;
                digest.update(buffer, 0, n);
            }
            fis.close();
            return digest.digest();
        }
    }

    public static class LiquidStackUtils {
        public static LiquidStack getNewStackCapacity(LiquidStack stack, int capacity) {
            LiquidStack t = stack.copy();
            t.amount = capacity;
            return t;
        }
    }

    public static class NetUtils {
        public static String[] readFileFromURL(String URL2) {
            ArrayList<String> l = new ArrayList<String>();
            try {
                String str;
                URL url = new URL(URL2);
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((str = in.readLine()) != null) {
                    l.add(str);
                }
                in.close();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return l.toArray(new String[l.size()]);
        }

        public static URL newUrlFromString(String s) {
            try {
                return new URL(s);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static File readBinaryFromNet(URL u, File saveTo) {
            try {
                int offset;
                URLConnection uc = u.openConnection();
                String contentType = uc.getContentType();
                int contentLength = uc.getContentLength();
                if (contentType.startsWith("text/") || contentLength == -1) {
                    throw new IOException("This is not a binary file.");
                }
                InputStream raw = uc.getInputStream();
                BufferedInputStream in = new BufferedInputStream(raw);
                byte[] data = new byte[contentLength];
                int bytesRead = 0;
                for (offset = 0; offset < contentLength && (bytesRead = ((InputStream)in).read(data, offset, data.length - offset)) != -1; offset += bytesRead) {
                }
                ((InputStream)in).close();
                if (offset != contentLength) {
                    throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
                }
                FileOutputStream out = new FileOutputStream(saveTo.getAbsolutePath());
                out.write(data);
                out.flush();
                out.close();
                return saveTo;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static class StringUtils {
        public static final String readError = "Error";

        public static String removeSpaces(String s) {
            return s.replaceAll("\\s", "");
        }

        public static String[] splitByNewLine(String s) {
            return s.split("[\r\n]+");
        }

        public static String scanFileContents(InputStream stream) {
            Scanner s = new Scanner(stream).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }

        public static String[] readFileContentsAutomated(File configDir, String name) {
            ClassLoader c = Thread.currentThread().getContextClassLoader();
            InputStream i = null;
            if (configDir != null) {
                File f1 = new File(configDir.getAbsolutePath() + "/" + name);
                if (f1.exists()) {
                    try {
                        i = new FileInputStream(f1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        i = c.getResourceAsStream(name);
                    }
                    catch (Exception ex) {
                        denLibMod.Proxy.warning("Error reading file " + name + "!");
                    }
                }
            }
            if (i != null) {
                return StringUtils.readInputStream(i);
            }
            return new String[]{readError};
        }

        public static String[] readInputStream(InputStream stream) {
            String f = StringUtils.scanFileContents(stream);
            String[] p = StringUtils.splitByNewLine(f);
            return p;
        }

        public static String[] readFileContentsAutomated(File configDir, String name, Object instance) {
            InputStream i = null;
            if (configDir != null) {
                File f1 = new File(configDir.getAbsolutePath() + "/" + name);
                if (f1.exists()) {
                    try {
                        i = new FileInputStream(f1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        i = instance.getClass().getResourceAsStream(name);
                    }
                    catch (Exception ex) {
                        denLibMod.Proxy.warning("Error reading file " + name + " from instance of " + instance.getClass().getName() + "!");
                    }
                }
            }
            if (i != null) {
                return StringUtils.readInputStream(i);
            }
            return new String[]{readError};
        }

        public static String Hash(String tag) {
            byte[] bytes = tag.getBytes();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] md5 = md.digest(bytes);
                String hash = "";
                for (byte b : md5) {
                    hash = hash + String.valueOf(b);
                }
                tag = hash = hash.replace("-", "");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return tag;
        }

        public static String Hash(String[] input) {
            String i = "";
            for (String s : input) {
                i = i + s;
            }
            return StringUtils.Hash(i);
        }
    }

    public static class NBTUtils {
        public static void writeNBTToFile(File file, NBTTagCompound tag) {
            try {
                FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
                DataOutputStream dos = new DataOutputStream(fos);
                NBTTagCompound.func_74731_a((NBTBase)tag, (DataOutput)dos);
                dos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public static NBTTagCompound readNBTFromFile(File file) {
            try {
                FileInputStream fis = new FileInputStream(file.getAbsolutePath());
                DataInputStream dis = new DataInputStream(fis);
                NBTTagCompound read = (NBTTagCompound)NBTTagCompound.func_74739_b((DataInput)dis);
                return read;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static void saveObjectToNBTFile(File file, Object o) {
            try {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                ObjectOutputStream b1 = new ObjectOutputStream(b);
                b1.writeObject(o);
                byte[] by = b.toByteArray();
                NBTTagCompound save = new NBTTagCompound();
                save.func_74773_a("object", by);
                NBTUtils.writeNBTToFile(file, save);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public static Object restoreObjectFromNBTFile(File file) {
            try {
                NBTTagCompound read = NBTUtils.readNBTFromFile(file);
                ByteArrayInputStream b2 = new ByteArrayInputStream(read.func_74770_j("object"));
                ObjectInputStream ois = new ObjectInputStream(b2);
                Object o = ois.readObject();
                ois.close();
                return o;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static class ReflectionHelper {
        public static Object getStaticField(Class c, String f) {
            try {
                return c.getDeclaredField(f).get(null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static Object getStaticField(Field f) {
            try {
                return f.get(null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static void setStaticField(Field f, Object value) {
            try {
                f.set(null, value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public static Field getStaticField(String c, String f) {
            try {
                return Class.forName(c).getField(f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static String findStringInNestedClass(Class first, String name) {
            try {
                for (Field field : first.getDeclaredFields()) {
                    if (!field.getName().equals(name)) continue;
                    return field.get(null).toString();
                }
                for (AnnotatedElement annotatedElement : first.getDeclaredClasses()) {
                    for (Field f : ((Class)annotatedElement).getDeclaredFields()) {
                        if (!f.getName().equals(name)) continue;
                        return f.get(null).toString();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return "Error";
        }
    }
}

