/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.raytracer;

import cofh.codechicken.core.vec.BlockCoord;
import cofh.codechicken.core.vec.Cuboid6;
import cofh.codechicken.core.vec.Vector3;
import cofh.util.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;
    public static RayTracer instance = new RayTracer();

    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    public MovingObjectPosition rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, start, end, cuboid);
        }
        if (this.s_side < 0) {
            return null;
        }
        MovingObjectPosition mop = new MovingObjectPosition(0, 0, 0, this.s_side, this.s_vec.toVec3D());
        mop.field_72313_a = null;
        return mop;
    }

    public MovingObjectPosition rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockCoord pos) {
        MovingObjectPosition mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.field_72313_a = EnumMovingObjectType.TILE;
            mop.field_72311_b = pos.x;
            mop.field_72312_c = pos.y;
            mop.field_72309_d = pos.z;
        }
        return mop;
    }

    public MovingObjectPosition rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, Entity e) {
        MovingObjectPosition mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.field_72313_a = EnumMovingObjectType.ENTITY;
            mop.field_72308_g = e;
        }
        return mop;
    }

    public MovingObjectPosition rayTraceCuboids(Vector3 start, Vector3 end, List cuboids) {
        double c_dist = Double.MAX_VALUE;
        MovingObjectPosition c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            MovingObjectPosition mop = this.rayTraceCuboid(start, end, cuboid);
            if (mop == null || !(this.s_dist < c_dist)) continue;
            mop.subHit = cuboid.index;
            c_dist = this.s_dist;
            c_hit = mop;
            this.c_cuboid = cuboid;
        }
        return c_hit;
    }

    public MovingObjectPosition rayTraceCuboids(Vector3 start, Vector3 end, List cuboids, BlockCoord pos, Block block) {
        MovingObjectPosition mop = this.rayTraceCuboids(start, end, cuboids);
        if (mop != null) {
            mop.field_72313_a = EnumMovingObjectType.TILE;
            mop.field_72311_b = pos.x;
            mop.field_72312_c = pos.y;
            mop.field_72309_d = pos.z;
            if (block != null) {
                this.c_cuboid.add(new Vector3(-pos.x, -pos.y, -pos.z)).setBlockBounds(block);
            }
        }
        return mop;
    }

    public static MovingObjectPosition retraceBlock(World world, EntityPlayer player, int x, int y, int z) {
        Vec3 headVec = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + 1.62 - (double)player.field_70129_M), (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        double reach = world.field_72995_K ? RayTracer.getBlockReachDistance_client() : RayTracer.getBlockReachDistance_server((EntityPlayerMP)player);
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return Block.field_71973_m[world.func_72798_a(x, y, z)].func_71878_a(world, x, y, z, headVec, endVec);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static MovingObjectPosition reTrace(World world, EntityPlayer player, double reach) {
        Vec3 headVec = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + 1.62 - (double)player.field_70129_M), (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_72831_a(headVec, endVec, true, false);
    }

    public static class IndexedCuboid6
    extends Cuboid6 {
        public int index;

        public IndexedCuboid6(int index, Cuboid6 cuboid) {
            super(cuboid);
            this.index = index;
        }
    }
}

