/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.liquid;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidRegistry {
    public static final int LAVA_ID = Block.field_71938_D.field_71990_ca;
    public static final int WATER_ID = Block.field_71943_B.field_71990_ca;
    private static Map liquidMap = new HashMap();

    public static boolean liquidRegistered(LiquidStack liquid) {
        if (liquid == null) {
            return true;
        }
        return liquidMap.containsKey(Arrays.asList(liquid.itemID, liquid.itemMeta));
    }

    public static boolean registerLiquid(LiquidStack liquid, int light, int viscosity, boolean isCompressible) {
        if (liquid == null || light < 0 || viscosity < 0) {
            return false;
        }
        if (LiquidRegistry.liquidRegistered(liquid)) {
            return false;
        }
        LiquidEntry data = new LiquidEntry(liquid, light, viscosity, isCompressible);
        liquidMap.put(Arrays.asList(liquid.itemID, liquid.itemMeta), data);
        return true;
    }

    public static int getLiquidLightLevel(LiquidStack liquid) {
        if (liquid == null) {
            return 0;
        }
        LiquidEntry data = (LiquidEntry)liquidMap.get(Arrays.asList(liquid.itemID, liquid.itemMeta));
        return data == null ? 0 : data.light;
    }

    public static int getLiquidViscosity(LiquidStack liquid) {
        if (liquid == null) {
            return 100;
        }
        LiquidEntry data = (LiquidEntry)liquidMap.get(Arrays.asList(liquid.itemID, liquid.itemMeta));
        return data == null ? 100 : data.viscosity;
    }

    public static boolean isLiquidCompressible(LiquidStack liquid) {
        if (liquid == null) {
            return false;
        }
        LiquidEntry data = (LiquidEntry)liquidMap.get(Arrays.asList(liquid.itemID, liquid.itemMeta));
        return data == null ? false : data.isCompressible;
    }

    static {
        LiquidRegistry.registerLiquid(LiquidDictionary.getCanonicalLiquid((String)"Lava"), 15, 60, false);
        LiquidRegistry.registerLiquid(LiquidDictionary.getCanonicalLiquid((String)"Water"), 0, 100, false);
    }

    public static class LiquidEntry {
        final int liquidId;
        final int liquidMeta;
        final int light;
        final int viscosity;
        final boolean isCompressible;

        public LiquidEntry(int liquidId, int liquidMeta, int light, int viscosity, boolean isCompressible) {
            this.liquidId = liquidId;
            this.liquidMeta = liquidMeta;
            this.light = light;
            this.viscosity = viscosity;
            this.isCompressible = isCompressible;
        }

        public LiquidEntry(LiquidStack liquid, int light, int viscosity, boolean isCompressible) {
            this.liquidId = liquid.itemID;
            this.liquidMeta = liquid.itemMeta;
            this.light = light;
            this.viscosity = viscosity;
            this.isCompressible = isCompressible;
        }
    }
}

