/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.inventory;

import cofh.util.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class TinyItemStack {
    public int itemID = -1;
    public int metadata = -1;
    public int stackSize = -1;
    public int maxStack = -1;
    public NBTTagCompound nbt;
    public boolean altered = false;
    public String oreName;

    public TinyItemStack(String oreDictName) {
        this.oreName = oreDictName;
        ArrayList theResult = OreDictionary.getOres((String)oreDictName);
        if (theResult.size() > 0) {
            this.itemID = ((ItemStack)theResult.get((int)0)).field_77993_c;
            this.metadata = ((ItemStack)theResult.get(0)).func_77960_j();
            this.stackSize = ((ItemStack)theResult.get((int)0)).field_77994_a;
            this.maxStack = ((ItemStack)theResult.get(0)).func_77976_d();
            this.nbt = ((ItemStack)theResult.get((int)0)).field_77990_d;
        }
    }

    public TinyItemStack(ItemStack aStack) {
        if (aStack != null) {
            this.itemID = aStack.field_77993_c;
            this.metadata = aStack.func_77960_j();
            this.stackSize = aStack.field_77994_a;
            this.maxStack = aStack.func_77976_d();
            this.nbt = aStack.field_77990_d;
        }
    }

    public TinyItemStack(int id, int damage, int stackSize, int maxStackSize) {
        this.itemID = id;
        this.metadata = damage;
        this.stackSize = stackSize;
        this.maxStack = maxStackSize;
    }

    public TinyItemStack(int id, int damage, int stackSize) {
        this.itemID = id;
        this.metadata = damage;
        this.stackSize = stackSize;
        this.maxStack = CoreUtils.getMaxStackForId(id);
    }

    public TinyItemStack() {
    }

    public void setAltered() {
        this.altered = true;
    }

    public int hashCode() {
        if (this.oreName != null) {
            return this.oreName.hashCode();
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.itemID;
        result = 31 * result + this.metadata;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return this.itemID == -1;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TinyItemStack other = (TinyItemStack)obj;
        if (this.itemID != other.itemID) {
            return false;
        }
        if (this.metadata == -1 || other.metadata == -1) {
            return true;
        }
        return this.metadata == other.metadata;
    }

    public ItemStack toQuickItemStack() {
        return this.itemID == -1 ? null : new ItemStack(this.itemID, this.stackSize, this.metadata);
    }

    public ItemStack toItemStack() {
        if (this.itemID == -1) {
            return null;
        }
        if (this.nbt != null) {
            ItemStack toReturn = new ItemStack(this.itemID, this.stackSize, this.metadata);
            toReturn.field_77990_d = this.nbt;
            return toReturn;
        }
        return new ItemStack(this.itemID, this.stackSize, this.metadata);
    }

    public TinyItemStack(TinyItemStack toCopy) {
        this.itemID = toCopy.itemID;
        this.metadata = toCopy.metadata;
        this.stackSize = toCopy.stackSize;
        this.maxStack = toCopy.maxStack;
        this.nbt = (NBTTagCompound)toCopy.nbt.func_74737_b();
    }

    public TinyItemStack clone() {
        return new TinyItemStack(this);
    }

    public String toString() {
        return this.stackSize + "x" + Item.field_77698_e[this.itemID].func_77658_a() + "@" + this.metadata;
    }
}

