/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import cofh.util.BlockUtils;
import net.minecraft.tileentity.TileEntity;

public class Coord
implements Comparable {
    public int x;
    public int y;
    public int z;

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(TileEntity tile) {
        this.x = tile.field_70329_l;
        this.y = tile.field_70330_m;
        this.z = tile.field_70327_n;
    }

    public void step(int dir) {
        this.x += BlockUtils.SIDE_COORD_MOD[dir][0];
        this.y += BlockUtils.SIDE_COORD_MOD[dir][1];
        this.z += BlockUtils.SIDE_COORD_MOD[dir][2];
    }

    public void step(int dir, int dist) {
        switch (dir) {
            case 0: {
                this.y -= dist;
                break;
            }
            case 1: {
                this.y += dist;
                break;
            }
            case 2: {
                this.z -= dist;
                break;
            }
            case 3: {
                this.z += dist;
                break;
            }
            case 4: {
                this.x -= dist;
                break;
            }
            default: {
                this.x += dist;
            }
        }
    }

    public Coord copy() {
        return new Coord(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Coord)) {
            return false;
        }
        Coord otherCoord = (Coord)obj;
        return this.x == otherCoord.x && this.y == otherCoord.y && this.z == otherCoord.z;
    }

    public int hashCode() {
        return Integer.valueOf(this.x).hashCode() + 31 * (Integer.valueOf(this.y).hashCode() + 31 * Integer.valueOf(this.z).hashCode());
    }

    public int compareTo(Coord otherCoord) {
        if (this.x == otherCoord.x) {
            if (this.y == otherCoord.y) {
                return this.z - otherCoord.z;
            }
            return this.y - otherCoord.y;
        }
        return this.x - otherCoord.x;
    }
}

