/*
 * Decompiled with CFR 0.152.
 */
package cofh.render;

import cofh.codechicken.core.render.CCRenderState;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static float[][] angleBaseYNeg;
    public static float[][] angleBaseYPos;
    public static float[][] angleBaseXPos;
    public static final float factor = 0.0625f;
    public static final RenderItem itemRenderer;
    public static final double RENDER_OFFSET = 0.00390625;
    public static final String MC_BLOCK_SHEET = "/terrain.png";
    public static final String MC_ITEM_SHEET = "/gui/items.png";

    public static void renderItemStack(int xPos, int yPos, float tickPlace, ItemStack stack, Minecraft mc) {
        if (stack != null) {
            float var6 = (float)stack.field_77992_b - tickPlace;
            if (var6 > 0.0f) {
                GL11.glPushMatrix();
                float var7 = 1.0f + var6 / 5.0f;
                GL11.glTranslatef((float)(xPos + 8), (float)(yPos + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / var7), (float)((var7 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(xPos + 8)), (float)(-(yPos + 12)), (float)0.0f);
            }
            itemRenderer.func_82406_b(mc.field_71466_p, mc.field_71446_o, stack, xPos, yPos);
            if (var6 > 0.0f) {
                GL11.glPopMatrix();
            }
            itemRenderer.func_77021_b(mc.field_71466_p, mc.field_71446_o, stack, xPos, yPos);
        }
    }

    public static void renderItemAsBlock(RenderBlocks renderer, ItemStack item, double translateX, double translateY, double translateZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Block block = Block.field_71981_t;
        Icon texture = item.func_77954_c();
        if (texture == null) {
            return;
        }
        renderer.func_83018_a(block);
        GL11.glTranslated((double)translateX, (double)translateY, (double)translateZ);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78381_a();
    }

    public static RenderEngine engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void bindItemTexture(ItemStack stack) {
        RenderUtils.engine().func_98187_b(stack.func_94608_d() == 0 ? MC_BLOCK_SHEET : MC_ITEM_SHEET);
    }

    public static void bindTexture(String string) {
        RenderUtils.engine().func_98187_b(string);
    }

    @SideOnly(value=Side.CLIENT)
    public static Icon getLiquidTexture(LiquidStack liquid) {
        if (liquid.canonical() == null || liquid.canonical().getRenderingIcon() == null) {
            return BlockFluid.func_94424_b((String)"lava");
        }
        return liquid.canonical().getRenderingIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public static String getLiquidTextureSheet(LiquidStack liquid) {
        if (liquid.canonical() == null || liquid.canonical().getTextureSheet() == null) {
            return MC_BLOCK_SHEET;
        }
        return liquid.canonical().getTextureSheet();
    }

    public static void setLiquidRenderColor(LiquidStack liquid) {
        CCRenderState.setColourOpaque(liquid.asItemStack().func_77973_b().func_82790_a(liquid.asItemStack(), 0));
    }

    public static void preRender() {
        CCRenderState.reset();
        CCRenderState.pullLightmap();
        CCRenderState.useNormals(true);
    }

    public static void beforeWorldRender(IBlockAccess world, int x, int y, int z) {
        CCRenderState.reset();
        CCRenderState.setBrightness(world, x, y, z);
        CCRenderState.useModelColours(true);
    }

    public static void afterWorldRender(IBlockAccess world, int x, int y, int z) {
        CCRenderState.useModelColours(false);
    }

    public static void setTextureSheet(String textureSheet) {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b(textureSheet);
    }

    public static void setLiquidTextureSheet(LiquidStack liquid) {
        RenderUtils.setTextureSheet(RenderUtils.getLiquidTextureSheet(liquid));
    }

    public static void setBlockTextureSheet() {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b(MC_BLOCK_SHEET);
    }

    public static void setItemTextureSheet() {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b(MC_ITEM_SHEET);
    }

    public static void setDefaultFontTextureSheet() {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/font/default.png");
    }

    public static void setSGAFontTextureSheet() {
        FMLClientHandler.instance().getClient().field_71446_o.func_98187_b("/font/alternate.png");
    }

    static {
        float pi;
        angleBaseYNeg = new float[6][3];
        angleBaseYPos = new float[6][3];
        angleBaseXPos = new float[6][3];
        itemRenderer = new RenderItem();
        RenderUtils.angleBaseYNeg[0][2] = pi = (float)Math.PI;
        RenderUtils.angleBaseYNeg[2][0] = -pi / 2.0f;
        RenderUtils.angleBaseYNeg[3][0] = pi / 2.0f;
        RenderUtils.angleBaseYNeg[4][2] = pi / 2.0f;
        RenderUtils.angleBaseYNeg[5][2] = -pi / 2.0f;
        RenderUtils.angleBaseYPos[1][2] = pi;
        RenderUtils.angleBaseYPos[2][0] = pi / 2.0f;
        RenderUtils.angleBaseYPos[3][0] = -pi / 2.0f;
        RenderUtils.angleBaseYPos[4][2] = -pi / 2.0f;
        RenderUtils.angleBaseYPos[5][2] = pi / 2.0f;
        RenderUtils.angleBaseXPos[0][0] = -pi / 2.0f;
        RenderUtils.angleBaseXPos[1][0] = pi / 2.0f;
        RenderUtils.angleBaseXPos[2][1] = pi;
        RenderUtils.angleBaseXPos[4][1] = -pi / 2.0f;
        RenderUtils.angleBaseXPos[5][1] = pi / 2.0f;
    }
}

