/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui;

import cofh.gui.SessionVars;
import cofh.gui.element.ElementRoot;
import cofh.gui.element.TabRoot;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiRoot
extends GuiContainer {
    public static final SoundManager guiSoundManager = FMLClientHandler.instance().getClient().field_71416_A;
    public static final FontRenderer guiFontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected String texture;
    protected String name;
    protected boolean drawInventory = true;
    protected ArrayList tabList = new ArrayList();
    protected ArrayList elementList = new ArrayList();
    public static final String TEX_ARROW_LEFT = "/mods/cofh/textures/gui/elements/Progress_Arrow_Left.png";
    public static final String TEX_ARROW_RIGHT = "/mods/cofh/textures/gui/elements/Progress_Arrow_Right.png";
    public static final String TEX_DROP_LEFT = "/mods/cofh/textures/gui/elements/Progress_Fluid_Left.png";
    public static final String TEX_DROP_RIGHT = "/mods/cofh/textures/gui/elements/Progress_Fluid_Right.png";
    public static final String TEX_BUBBLE = "/mods/cofh/textures/gui/elements/Scale_Bubble.png";
    public static final String TEX_CRUSH = "/mods/cofh/textures/gui/elements/Scale_Crush.png";
    public static final String TEX_SAW = "/mods/cofh/textures/gui/elements/Scale_Saw.png";
    public static final String TEX_FLAME = "/mods/cofh/textures/gui/elements/Scale_Flame.png";
    public static final String TEX_SNOWFLAKE = "/mods/cofh/textures/gui/elements/Scale_Snowflake.png";
    public static final int PROGRESS = 24;
    public static final int SPEED = 16;

    public GuiRoot(Container container) {
        super(container);
    }

    public GuiRoot(Container container, String texture) {
        super(container);
        this.texture = texture;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabList.clear();
        this.elementList.clear();
    }

    protected void func_74189_g(int x, int y) {
        this.field_73886_k.func_78276_b(CoreUtils.localize(this.name), this.getCenteredOffset(CoreUtils.localize(this.name)), 6, 0x404040);
        if (this.drawInventory) {
            this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
        }
        GL11.glDisable((int)2896);
        this.drawTooltips();
        GL11.glEnable((int)2896);
    }

    protected void func_74185_a(float f, int x, int y) {
        this.updateElements();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(this.texture);
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        for (ElementRoot e : this.elementList) {
            e.draw();
        }
        this.drawTabs();
    }

    protected void updateElements() {
    }

    protected void drawTooltips() {
        TabRoot tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null) {
            this.drawTooltip(tab.getTooltip());
            return;
        }
        for (ElementRoot e : this.elementList) {
            if (!e.intersectsWith(this.mouseX, this.mouseY)) continue;
            this.drawTooltip(e.getTooltip());
            return;
        }
    }

    protected void drawTooltip(String tooltip) {
        if (tooltip == null || tooltip.equals("")) {
            return;
        }
        this.func_74190_a(tooltip, this.mouseX, this.mouseY);
    }

    public void func_73867_d() {
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        this.mouseX = x - this.field_74198_m;
        this.mouseY = y - this.field_74197_n;
        super.func_73867_d();
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        TabRoot tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null && !tab.handleMouseClicked(this.mouseX, this.mouseY, mouseButton)) {
            for (TabRoot other : this.tabList) {
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
        }
    }

    public TabRoot addTab(TabRoot tab) {
        this.tabList.add(tab);
        if (SessionVars.getOpenedLeftTab() != null && tab.getClass().equals(SessionVars.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (SessionVars.getOpenedRightTab() != null && tab.getClass().equals(SessionVars.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    public ElementRoot addElement(ElementRoot element) {
        this.elementList.add(element);
        return element;
    }

    public ItemStack getItemStackOnCursor() {
        return this.field_73882_e.field_71439_g.field_71071_by.func_70445_o();
    }

    public void mouseClicked(int mouseButton) {
        super.func_73864_a(this.field_74198_m + this.mouseX, this.field_74197_n + this.mouseY, mouseButton);
    }

    public Slot getSlotAtPosition() {
        return this.func_74187_b(this.field_74198_m + this.mouseX, this.field_74197_n + this.mouseY);
    }

    public boolean isMouseOverSlot(Slot slot) {
        return slot == null ? false : this.func_74188_c(slot.field_75223_e, slot.field_75221_f, 16, 16, this.field_74198_m + this.mouseX, this.field_74197_n + this.mouseY);
    }

    public void drawSlotHighlight(Slot slot) {
        if (slot == null) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.func_73733_a(slot.field_75223_e, slot.field_75221_f, slot.field_75223_e + 16, slot.field_75221_f + 16, -2130706433, -2130706433);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void drawItem(ItemStack stack, int par2, int par3) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 500.0f;
        GuiRoot.field_74196_a.field_77023_b = 500.0f;
        field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, stack, par2, par3);
        this.field_73735_i = 0.0f;
        GuiRoot.field_74196_a.field_77023_b = 0.0f;
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78381_a();
    }

    public void drawIcon(Icon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderUtils.setBlockTextureSheet();
        } else {
            RenderUtils.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(x, y, icon, 16, 16);
    }

    public void drawIcon(String iconName, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderUtils.setBlockTextureSheet();
        } else {
            RenderUtils.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(x, y, IconRegistry.getIcon(iconName), 16, 16);
    }

    public void drawButton(Icon icon, int x, int y, int spriteSheet, int mode) {
        switch (mode) {
            case 0: {
                this.drawIcon(IconRegistry.getIcon("IconButton"), x, y, 1);
                break;
            }
            case 1: {
                this.drawIcon(IconRegistry.getIcon("IconButtonHighlight"), x, y, 1);
                break;
            }
            default: {
                this.drawIcon(IconRegistry.getIcon("IconButtonInactive"), x, y, 1);
            }
        }
        this.drawIcon(icon, x, y, spriteSheet);
    }

    public void drawButton(String iconName, int x, int y, int spriteSheet, int mode) {
        switch (mode) {
            case 0: {
                this.drawIcon(IconRegistry.getIcon("IconButton"), x, y, 1);
                break;
            }
            case 1: {
                this.drawIcon(IconRegistry.getIcon("IconButtonHighlight"), x, y, 1);
                break;
            }
            default: {
                this.drawIcon(IconRegistry.getIcon("IconButtonInactive"), x, y, 1);
            }
        }
        this.drawIcon(iconName, x, y, spriteSheet);
    }

    public void drawLiquid(int i, int j, LiquidStack theLiquid, int width, int height) {
        RenderUtils.setLiquidTextureSheet(theLiquid);
        int x = 0;
        int y = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (x = 0; x < width; x += 16) {
            for (y = 0; y < height; y += 16) {
                drawWidth = MathHelper.minI(width - x, 16);
                drawHeight = MathHelper.minI(height - y, 16);
                this.drawScaledTexturedModelRectFromIcon(i + x, j + y, RenderUtils.getLiquidTexture(theLiquid), drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, Icon theIcon, int width, int height) {
        double minU = theIcon.func_94209_e();
        double maxU = theIcon.func_94212_f();
        double minV = theIcon.func_94206_g();
        double maxV = theIcon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
    }

    protected void drawTabs() {
        int yPosRight = 4;
        int yPosLeft = 4;
        for (TabRoot tab : this.tabList) {
            tab.update();
            if (!tab.isVisible()) continue;
            if (tab.side == 0) {
                tab.draw(this.field_74198_m, this.field_74197_n + yPosLeft);
                yPosLeft += tab.currentHeight;
                continue;
            }
            tab.draw(this.field_74198_m + this.field_74194_b, this.field_74197_n + yPosRight);
            yPosRight += tab.currentHeight;
        }
    }

    protected TabRoot getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (TabRoot tab : this.tabList) {
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.field_74194_b;
        yShift = 4;
        for (TabRoot tab : this.tabList) {
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }
}

