/*
 * Decompiled with CFR 0.152.
 */
package cofh.codechicken.core.render;

import cofh.codechicken.core.render.PlaceholderTexture;
import cofh.codechicken.core.render.TextureSpecial;
import cofh.render.RenderUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.Rect2i;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureStitched;
import net.minecraft.entity.Entity;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;

public class TextureUtils {
    private static HashMap textureDimensions;
    private static ArrayList iconRegistrars;

    public static void addIconRegistrar(IIconRegister registrar) {
        iconRegistrars.add(registrar);
    }

    public static Texture createTextureObject(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        return new Texture(textureFile, 2, img.getWidth(), img.getHeight(), 10496, 6408, 9728, 9728, img);
    }

    public static InputStream getTextureResource(String textureFile) throws IOException {
        return RenderUtils.engine().field_78366_k.func_77292_e().func_77532_a(textureFile);
    }

    public static BufferedImage loadBufferedImage(String textureFile) {
        try {
            InputStream in = TextureUtils.getTextureResource(textureFile);
            if (in != null) {
                BufferedImage img = TextureUtils.loadBufferedImage(in);
                if (img != null) {
                    textureDimensions.put(textureFile, new Dimension(img.getWidth(), img.getHeight()));
                }
                return img;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
        }
        textureDimensions.put(textureFile, new Dimension(0, 0));
        return null;
    }

    public static Dimension getTextureDimension(String textureFile) {
        Dimension dim = (Dimension)textureDimensions.get(textureFile);
        if (dim == null) {
            TextureUtils.loadBufferedImage(textureFile);
            dim = (Dimension)textureDimensions.get(textureFile);
        }
        return dim;
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static Texture createTextureObject(String name, int w, int h) {
        return new Texture(name, 2, w, h, 10496, 6408, 9728, 9728, null);
    }

    public static void copySubImg(Texture fromTex, int fromX, int fromY, int width, int height, Texture toTex, int toX, int toY) {
        int fromWidth = fromTex.func_94275_d();
        int toWidth = toTex.func_94275_d();
        ByteBuffer from = fromTex.func_94273_h();
        ByteBuffer to = toTex.func_94273_h();
        from.position(0);
        to.position(0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = ((y + fromY) * fromWidth + x + fromX) * 4;
                int tp = ((y + toY) * toWidth + x + toX) * 4;
                to.put(tp, from.get(fp));
                to.put(tp + 1, from.get(fp + 1));
                to.put(tp + 2, from.get(fp + 2));
                to.put(tp + 3, from.get(fp + 3));
            }
        }
        toTex.func_94272_a(new Rect2i(0, 0, 0, 0), 0);
    }

    public static void write(byte[] data, int width, int height, Texture toTex, int toX, int toY) {
        int toWidth = toTex.func_94275_d();
        ByteBuffer to = toTex.func_94273_h();
        to.position(0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y * width + x) * 4;
                int tp = ((y + toY) * toWidth + x + toX) * 4;
                to.put(tp, data[fp]);
                to.put(tp + 1, data[fp + 1]);
                to.put(tp + 2, data[fp + 2]);
                to.put(tp + 3, data[fp + 3]);
            }
        }
        toTex.func_94272_a(new Rect2i(0, 0, 0, 0), 0);
        to.position(toWidth * toTex.func_94276_e() * 4);
    }

    public static boolean refreshTexture(TextureMap map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (TextureStitched)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static Icon getIconFromTexture(String name, IconRegister iconRegister, boolean animated) {
        TextureMap textureMap = (TextureMap)iconRegister;
        TextureSpecial icon = new TextureSpecial(name).setTextureFile(name).useVanillaAnimation(animated);
        textureMap.setTextureEntry(name, (TextureStitched)icon);
        return icon;
    }

    public static Icon getIconFromTexture(String name, IconRegister iconRegister) {
        return TextureUtils.getIconFromTexture(name, iconRegister, true);
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glBindTexture((int)target, (int)texture);
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    static {
        RenderManager.field_78727_a.field_78729_o.put(null, new RegisterTextureCallback());
        textureDimensions = new HashMap();
        iconRegistrars = new ArrayList();
    }

    public static interface IIconRegister {
        public void registerIcons(IconRegister var1);
    }

    private static class RegisterTextureCallback
    extends Render {
        private RegisterTextureCallback() {
        }

        public void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        }

        public void func_94143_a(IconRegister par1IconRegister) {
            for (IIconRegister r : iconRegistrars) {
                r.registerIcons(par1IconRegister);
            }
        }
    }
}

