/*
 * Decompiled with CFR 0.152.
 */
package cofh.block;

import cofh.block.BlockFluidRoot;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFluidClassic
extends BlockFluidRoot {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];

    public BlockFluidClassic(int id, Material material) {
        super(id, material);
    }

    @Override
    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(bId)) {
            return (Boolean)displacementIds.get(bId);
        }
        Material material = Block.field_71973_m[bId].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76244_g && material != Material.field_76256_h && material != Material.field_76237_B;
    }

    @Override
    public boolean displaceIfPossible(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(bId)) {
            if (((Boolean)displacementIds.get(bId)).booleanValue()) {
                Block.field_71973_m[bId].func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
                return true;
            }
            return false;
        }
        Material material = Block.field_71973_m[bId].field_72018_cp;
        if (material.func_76230_c() || material == Material.field_76244_g || material == Material.field_76256_h || material == Material.field_76237_B) {
            return false;
        }
        Block.field_71973_m[bId].func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
        return true;
    }

    public boolean isFlowingVertically(IBlockAccess world, int x, int y, int z) {
        return world.func_72798_a(x, y + this.densityDir, z) == this.field_71990_ca || world.func_72798_a(x, y, z) == this.field_71990_ca && this.canFlowInto(world, x, y + this.densityDir, z);
    }

    public boolean isSourceBlock(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == this.field_71990_ca && world.func_72805_g(x, y, z) + 1 == this.quantaPerBlock;
    }

    protected void updateFlowLevel(World world, int x, int y, int z, int quantaRemaining) {
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack theItem) {
        world.func_72832_d(x, y, z, this.field_71990_ca, this.quantaPerBlock - 1, 3);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        int quantaRemaining = world.func_72805_g(x, y, z) + 1;
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (world.func_72798_a(x, y2, z) == this.field_71990_ca || world.func_72798_a(x - 1, y2, z) == this.field_71990_ca || world.func_72798_a(x + 1, y2, z) == this.field_71990_ca || world.func_72798_a(x, y2, z - 1) == this.field_71990_ca || world.func_72798_a(x, y2, z + 1) == this.field_71990_ca) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_94571_i(x, y, z);
                } else {
                    world.func_72921_c(x, y, z, expQuanta - 1, 3);
                    world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
            }
        } else if (quantaRemaining > this.quantaPerBlock) {
            world.func_72921_c(x, y, z, this.quantaPerBlock - 1, 3);
        }
        if (this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z)) {
            this.flowIntoBlock(world, x, y + this.densityDir, z, this.quantaPerBlock - 2);
            return;
        }
        int flowMeta = quantaRemaining - 2;
        if (flowMeta < 0) {
            return;
        }
        if (this.isSourceBlock(world, x, y, z) || !this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
            boolean[] flowTo;
            if (world.func_72798_a(x, y - this.densityDir, z) == this.field_71990_ca) {
                flowMeta = this.quantaPerBlock - 2;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    protected boolean[] getOptimalFlowDirections(World world, int x, int y, int z) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (side2) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, x2, y2, z2) || this.isSourceBlock(world, x2, y2, z2)) continue;
            this.flowCost[side2] = this.canFlowInto((IBlockAccess)world, x2, y2 + this.densityDir, z2) ? 0 : this.calculateFlowCost(world, x2, y2, z2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(World world, int x, int y, int z, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (adjSide) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((IBlockAccess)world, x2, y2, z2) || this.isSourceBlock(world, x2, y2, z2)) continue;
            if (this.canFlowInto((IBlockAccess)world, x2, y2 + this.densityDir, z2)) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, x2, y2, z2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x, y, z)) {
            world.func_72832_d(x, y, z, this.field_71990_ca, meta, 3);
        }
    }

    protected boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.field_71990_ca) {
            return true;
        }
        if (displacementIds.containsKey(bId)) {
            return (Boolean)displacementIds.get(bId);
        }
        Material material = Block.field_71973_m[bId].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76244_g && material != Material.field_76256_h && material != Material.field_76237_B;
    }

    protected int getLargerQuanta(IBlockAccess world, int x, int y, int z, int compare) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }
}

