/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.api.world.WeightedRandomBlock;
import cofh.core.CoFHProps;
import cofh.util.ConfigHandler;
import cofh.util.CoreUtils;
import cofh.world.TickHandlerWorld;
import cofh.world.WorldHandler;
import cofh.world.feature.FeatureOreGenNormal;
import cofh.world.feature.FeatureOreGenUniform;
import cofh.world.feature.WorldGenMinableCluster;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="CoFHWorld", name="CoFH World", version="1.5.2.5")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class CoFHWorld {
    @Mod.Instance(value="CoFHWorld")
    public static CoFHWorld instance;
    public static final int ORE_UNIFORM = 0;
    public static final int ORE_NORMAL = 1;
    public static final String CUSTOM_GEN_TEMPLATE = "#This file allows for the addition of custom generation TEMPLATES to World.cfg.\n#Generation parameters are changed inside World.cfg.\n#These values are only used as defaults and in the template comments.\n#\n";
    public static final String CUSTOM_GEN_FORMAT = "#Format (TAB DELIMITED): GenType\tName\tBlockID\tBlockMeta\tClusterSize\tNumClusters\tminY\tmaxY\tregen\n#GenType is either UNIFORM or NORMAL. If NORMAL, minY is the average height and maxY is the maximum variance.\n#\n";
    public static final String CUSTOM_GEN_UNIFORM = "#Creates a template with default values of 4 clusters of 4 ores (1000:0) randomly between y = 32 and y = 64. Retrogen Enabled:\n#UNIFORM\ttestUniform\t1000\t0\t4\t4\t32\t64\ttrue\n#\n";
    public static final String CUSTOM_GEN_NORMAL = "#Creates a template with default values of 6 clusters of 16 ores (1000:1) in a 32-height Normal Distribution centered at y = 32. RetroGen Disabled:\n#NORMAL\ttestNormal\t1000\t1\t16\t6\t32\t16\tfalse\n#\n";
    public static final Logger log;
    public static ConfigHandler config;
    public static File customGen;
    public static boolean allowCustomGen;
    public static boolean genFlatBedrock;
    public static boolean genReplaceVanilla;
    public static boolean retroFlatBedrock;
    public static boolean retroOreGeneration;
    public static boolean forceFullRegeneration;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/World.cfg")));
        String category = "feature";
        Property curProp = config.getProperty(category, "AllowCustomGeneration", false);
        curProp.comment = "This allows for custom generation to be specified in the WorldCustomGen.txt file.";
        allowCustomGen = curProp.getBoolean(false);
        curProp = config.getProperty(category, "ReplaceVanillaGeneration", false);
        curProp.comment = "This allows for vanilla ore generation to be REPLACED. Configure in the 'world.vanilla' section; vanilla defaults have been provided.";
        genReplaceVanilla = curProp.getBoolean(false);
        curProp = config.getProperty(category, "FlatBedrock", false);
        curProp.comment = "This will flatten the bedrock layer to a single block in height.";
        genFlatBedrock = curProp.getBoolean(false);
        curProp = config.getProperty(category, "RetroactiveFlatBedrock", false);
        curProp.comment = "If FlatBedrock is enabled, this will enforce it in previously generated chunks.";
        retroFlatBedrock = curProp.getBoolean(false);
        curProp = config.getProperty(category, "RetroactiveOreGeneration", false);
        curProp.comment = "This will retroactively generate ores in previously generated chunks.";
        retroOreGeneration = curProp.getBoolean(false);
        this.loadWorldGeneration();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)WorldHandler.instance);
        MinecraftForge.ORE_GEN_BUS.register((Object)WorldHandler.instance);
        if (OreDictionary.getOres((String)"oreIron").isEmpty()) {
            OreDictionary.registerOre((String)"oreIron", (Block)Block.field_71949_H);
        }
        if (OreDictionary.getOres((String)"oreGold").isEmpty()) {
            OreDictionary.registerOre((String)"oreGold", (Block)Block.field_71941_G);
        }
        if (OreDictionary.getOres((String)"ingotIron").isEmpty()) {
            OreDictionary.registerOre((String)"ingotIron", (Item)Item.field_77703_o);
        }
        if (OreDictionary.getOres((String)"ingotGold").isEmpty()) {
            OreDictionary.registerOre((String)"ingotGold", (Item)Item.field_77717_p);
        }
        if (config.hasCategory("world.feature")) {
            config.removeCategory("world.feature");
        }
        if (config.hasCategory("world.tweak")) {
            config.removeCategory("world.tweak");
        }
        if (config.hasKey("world.feature", "Vanilla.Augment")) {
            config.getCategory("world.feature").remove((Object)"Vanilla.Augment");
        }
        config.save();
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        this.parseCustomGeneration();
        if (genFlatBedrock && retroFlatBedrock || retroOreGeneration) {
            TickRegistry.registerTickHandler((ITickHandler)TickHandlerWorld.instance, (Side)Side.SERVER);
        }
    }

    void loadWorldGeneration() {
        String category = "world.vanilla";
        ConfigCategory cat = config.getCategory(category);
        cat.setComment("This section controls generation specifically related to vanilla Minecraft ores. THESE VALUES ARE USED INSTEAD OF STANDARD GENERATION IF REPLACEMENT IS ENABLED.");
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71979_v), "dirt", 32, 20, 0, 128, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71940_F), "gravel", 32, 10, 0, 128, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71950_I), "coal", 16, 20, 0, 128, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71949_H), "iron", 8, 20, 0, 64, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71941_G), "gold", 8, 2, 0, 32, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_72047_aN), "redstone", 7, 8, 0, 16, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_72073_aw), "diamond", 7, 1, 0, 16, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71947_N), "lapis", 6, 1, 16, 16, 1, true, genReplaceVanilla);
        config.save();
    }

    void parseCustomGeneration() {
        customGen = new File(CoFHProps.configDir, "/cofh/WorldCustomGen.txt");
        try {
            if (!customGen.exists()) {
                customGen.createNewFile();
                Files.write((byte[])"#This file allows for the addition of custom generation TEMPLATES to World.cfg.\n#Generation parameters are changed inside World.cfg.\n#These values are only used as defaults and in the template comments.\n#\n#Format (TAB DELIMITED): GenType\tName\tBlockID\tBlockMeta\tClusterSize\tNumClusters\tminY\tmaxY\tregen\n#GenType is either UNIFORM or NORMAL. If NORMAL, minY is the average height and maxY is the maximum variance.\n#\n#Creates a template with default values of 4 clusters of 4 ores (1000:0) randomly between y = 32 and y = 64. Retrogen Enabled:\n#UNIFORM\ttestUniform\t1000\t0\t4\t4\t32\t64\ttrue\n#\n#Creates a template with default values of 6 clusters of 16 ores (1000:1) in a 32-height Normal Distribution centered at y = 32. RetroGen Disabled:\n#NORMAL\ttestNormal\t1000\t1\t16\t6\t32\t16\tfalse\n#\n".getBytes(), (File)customGen);
            }
            List lines = Files.readLines((File)customGen, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                String[] tokens;
                if (line.startsWith("#") || (tokens = line.split("\t")).length != 9) continue;
                try {
                    int type;
                    String genType = tokens[0].toLowerCase(Locale.ENGLISH);
                    String name = tokens[1].toLowerCase(Locale.ENGLISH);
                    int oreId = Integer.valueOf(tokens[2]);
                    int oreMeta = Integer.valueOf(tokens[3]);
                    int clusterSize = Integer.valueOf(tokens[4]);
                    int numClusters = Integer.valueOf(tokens[5]);
                    int minY = Integer.valueOf(tokens[6]);
                    int maxY = Integer.valueOf(tokens[7]);
                    boolean regen = Boolean.valueOf(tokens[8]);
                    if (genType.equals("uniform")) {
                        type = 0;
                    } else if (genType.equals("normal")) {
                        type = 1;
                    } else {
                        log.log(Level.SEVERE, "The WorldCustomGen.txt file has an invalid entry: '" + tokens[1] + "'.");
                        continue;
                    }
                    CoFHWorld.addCustomFeature(oreId, oreMeta, tokens[1], clusterSize, numClusters, minY, maxY, type, regen, true);
                }
                catch (NumberFormatException e) {
                    log.log(Level.SEVERE, "The WorldCustomGen.txt file has an invalid entry: '" + tokens[1] + "'.");
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "The WorldCustomGen.txt file could not be read! Skipping custom generation.");
        }
    }

    public static void addCustomFeature(int oreId, int oreMeta, String featureName, int clusterSize, int numClusters, int minY, int maxY, int feature, boolean regen, boolean enable) {
        if (Block.field_71973_m[oreId] == null) {
            log.log(Level.SEVERE, "The entry for custom ore '" + featureName + "' is invalid - the block is null.");
            return;
        }
        String category = "world.custom." + featureName.toLowerCase(Locale.ENGLISH);
        ConfigCategory cat = config.getCategory(category);
        int bId = config.get(category, "BlockId", oreId);
        int bMeta = config.get(category, "BlockMeta", oreMeta);
        CoFHWorld.addFeature("world.custom", new ItemStack(bId, 1, bMeta), featureName, clusterSize, numClusters, minY, maxY, feature, regen, enable);
    }

    public static void addFeature(String category, ItemStack stack, String featureName, int clusterSize, int numClusters, int minY, int maxY, int feature, boolean regen, boolean enable) {
        ArrayList<WeightedRandomBlock> resList = new ArrayList<WeightedRandomBlock>();
        resList.add(new WeightedRandomBlock(stack));
        CoFHWorld.addFeature(category, resList, featureName, clusterSize, numClusters, minY, maxY, feature, regen, enable);
    }

    public static void addFeature(String category, List resList, String featureName, int clusterSize, int numClusters, int minY, int maxY, int feature, boolean regen, boolean enable) {
        category = category + "." + featureName.toLowerCase(Locale.ENGLISH);
        ConfigCategory cat = config.getCategory(category);
        String featureType = "<UNIFORM>";
        String strMin = "MinY";
        String strMax = "MaxY";
        if (feature == 1) {
            featureType = "<NORMAL>";
            strMin = "MeanY";
            strMax = "MaxVar";
        }
        clusterSize = config.get(category, "ClusterSize", clusterSize);
        numClusters = config.get(category, "NumClusters", numClusters);
        minY = config.get(category, strMin, minY);
        maxY = config.get(category, strMax, maxY);
        regen = config.get(category, "RetroGen", enable);
        cat.setComment(featureType + " Generation settings for " + CoreUtils.titleCase(featureName) + "; Defaults: ClusterSize = " + clusterSize + ", NumClusters = " + numClusters + ", " + strMin + " = " + minY + ", " + strMax + " = " + maxY);
        config.save();
        if (!enable) {
            return;
        }
        if (feature == 0) {
            WorldHandler.addFeature(new FeatureOreGenUniform(featureName, new WorldGenMinableCluster(resList, clusterSize), numClusters, minY, maxY, regen));
        } else if (feature == 1) {
            WorldHandler.addFeature(new FeatureOreGenNormal(featureName, new WorldGenMinableCluster(resList, clusterSize), numClusters, minY, maxY, regen));
        }
    }

    static {
        log = Logger.getLogger("CoFHWorld");
        config = new ConfigHandler("1.5.2.5");
        log.setParent(FMLLog.getLogger());
        allowCustomGen = false;
        genFlatBedrock = false;
        genReplaceVanilla = false;
        retroFlatBedrock = false;
        retroOreGeneration = false;
        forceFullRegeneration = false;
    }
}

