/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.api.core.RegistryAccess;
import cofh.command.CommandHandler;
import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.core.ProxyClient;
import cofh.entity.EntityDropHead;
import cofh.network.PacketHandler;
import cofh.network.TinyPacketHandler;
import cofh.skins.CapeHandler;
import cofh.skins.SkinHandler;
import cofh.util.ConfigHandler;
import cofh.util.liquid.BucketHandler;
import cofh.util.version.VersionHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@Mod(modid="CoFHCore", name="CoFH Core", version="1.5.2.5")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, channels={"CoFH"}, packetHandler=PacketHandler.class, tinyPacketHandler=TinyPacketHandler.class)
public class CoFHCore {
    @Mod.Instance(value="CoFHCore")
    public static CoFHCore instance;
    @SidedProxy(clientSide="cofh.core.ProxyClient", serverSide="cofh.core.Proxy")
    public static Proxy proxy;
    public static MinecraftServer theServer;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final VersionHandler version;

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        CommandHandler.initCommands(event);
        theServer = event.getServer();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        version.checkForNewVersion();
        proxy = event.getSide() == Side.CLIENT ? new ProxyClient() : new Proxy();
        RegistryAccess.capeRegistry = new CapeHandler();
        RegistryAccess.skinRegistry = new SkinHandler();
        CapeHandler.registerDefaults();
        SkinHandler.registerDefaults();
        CoFHProps.configDir = event.getModConfigurationDirectory();
        CapeHandler.capeConf = new Configuration(new File(CoFHProps.configDir, "/cofh/Capes.cfg"));
        CapeHandler.capeConf.load();
        CapeHandler.loadCapes();
        SkinHandler.skinConf = new Configuration(new File(CoFHProps.configDir, "/cofh/Skins.cfg"));
        SkinHandler.skinConf.load();
        SkinHandler.loadSkins();
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/Core.cfg")));
        String category = "general";
        CoFHProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", true);
        Property curProp = config.getProperty("general", "Tabs.Information", true);
        CoFHProps.enableInformationTabs = curProp.getBoolean(true);
        curProp = config.getProperty("general", "Tabs.Tutorial", true);
        CoFHProps.enableTutorialTabs = curProp.getBoolean(true);
        category = "feature.capes";
        curProp = config.getProperty(category, "AllowEveryone", true);
        curProp.comment = "Allows all players to use /cofh cape set.";
        CapeHandler.allowOpsUse = curProp.getBoolean(true);
        curProp = config.getProperty(category, "AllowOps", true);
        curProp.comment = "Allows Ops to use /cofh cape set and /cofh cape set (user) if that is also allowed.";
        CapeHandler.allowPlayersUse = curProp.getBoolean(true);
        curProp = config.getProperty(category, "AllowOpsToSetOthers", false);
        curProp.comment = "Allows Ops to set the capes of others, if Ops are allowed to set capes.";
        CapeHandler.allowOpsOthers = curProp.getBoolean(false);
        category = "feature.skins";
        curProp = config.getProperty(category, "AllowEveryone", true);
        curProp.comment = "Allows all players to use /cofh skin set.";
        SkinHandler.allowOpsUse = curProp.getBoolean(true);
        curProp = config.getProperty(category, "AllowOps", true);
        curProp.comment = "Allows Ops to use /cofh skin set and /cofh skin set (user) if that is also allowed.";
        SkinHandler.allowPlayersUse = curProp.getBoolean(true);
        curProp = config.getProperty(category, "AllowOpsToSetOthers", false);
        curProp.comment = "Allows Ops to set the skins of others, if Ops are allowed to set skins.";
        SkinHandler.allowOpsOthers = curProp.getBoolean(false);
        category = "feature.heads";
        curProp = config.getProperty(category, "MobsDropOnPvEOnly", EntityDropHead.mobPvEOnly);
        curProp.comment = "If enabled, mobs only drop heads when killed by players.";
        EntityDropHead.mobPvEOnly = curProp.getBoolean(EntityDropHead.mobPvEOnly);
        curProp = config.getProperty(category, "PlayersDropOnPvPOnly", EntityDropHead.playerPvPOnly);
        curProp.comment = "If enabled, players only drop heads when killed by other players.";
        EntityDropHead.playerPvPOnly = curProp.getBoolean(EntityDropHead.playerPvPOnly);
        category = "feature.heads.enable";
        curProp = config.getProperty(category, "PlayersDropHeads", EntityDropHead.playersEnabled);
        EntityDropHead.playersEnabled = curProp.getBoolean(EntityDropHead.playersEnabled);
        curProp = config.getProperty(category, "CreepersDropHeads", EntityDropHead.creeperEnabled);
        EntityDropHead.creeperEnabled = curProp.getBoolean(EntityDropHead.creeperEnabled);
        curProp = config.getProperty(category, "SkeletonsDropHeads", EntityDropHead.skeletonEnabled);
        EntityDropHead.skeletonEnabled = curProp.getBoolean(EntityDropHead.skeletonEnabled);
        curProp = config.getProperty(category, "WitherSkeletonsDropHeads", EntityDropHead.witherSkeletonEnabled);
        EntityDropHead.skeletonEnabled = curProp.getBoolean(EntityDropHead.witherSkeletonEnabled);
        curProp = config.getProperty(category, "ZombiesDropHeads", EntityDropHead.zombieEnabled);
        EntityDropHead.zombieEnabled = curProp.getBoolean(EntityDropHead.zombieEnabled);
        category = "feature.heads.chance";
        curProp = config.getProperty(category, "PlayerDropChance", EntityDropHead.playerChance);
        EntityDropHead.playerChance = curProp.getInt(EntityDropHead.playerChance);
        curProp = config.getProperty(category, "CreeperDropChance", EntityDropHead.creeperChance);
        EntityDropHead.creeperChance = curProp.getInt(EntityDropHead.creeperChance);
        curProp = config.getProperty(category, "SkeletonDropChance", EntityDropHead.skeletonChance);
        EntityDropHead.skeletonChance = curProp.getInt(EntityDropHead.skeletonChance);
        curProp = config.getProperty(category, "WitherSkeletonDropChance", EntityDropHead.witherSkeletonChance);
        EntityDropHead.witherSkeletonChance = curProp.getInt(EntityDropHead.skeletonChance);
        curProp = config.getProperty(category, "ZombieDropChance", EntityDropHead.zombieChance);
        EntityDropHead.zombieChance = curProp.getInt(EntityDropHead.zombieChance);
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)EntityDropHead.instance);
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        this.cleanConfig();
        config.cleanUp(false);
    }

    public void cleanConfig() {
        config.removeProperty("world.feature", "Vanilla.Augment");
        config.removeProperty("world.feature", "FlatBedrock");
        String category = "world.tweak";
        config.removeProperty(category, "Augment.Coal.NumClusters");
        config.removeProperty(category, "Augment.Iron.NumClusters");
        config.removeProperty(category, "Augment.Gold.NumClusters");
        config.removeProperty(category, "Augment.Redstone.NumClusters");
        config.removeProperty(category, "Augment.Diamond.NumClusters");
        config.removeProperty(category, "Augment.Lapis.NumClusters");
        config.removeProperty(category, "Augment.Quartz.NumClusters");
        config.removeProperty(category, "Augment.Coal.ClusterSize");
        config.removeProperty(category, "Augment.Iron.ClusterSize");
        config.removeProperty(category, "Augment.Gold.ClusterSize");
        config.removeProperty(category, "Augment.Redstone.ClusterSize");
        config.removeProperty(category, "Augment.Diamond.ClusterSize");
        config.removeProperty(category, "Augment.Lapis.ClusterSize");
        config.removeProperty(category, "Augment.Quartz.ClusterSize");
    }

    static {
        log = Logger.getLogger("CoFHCore");
        config = new ConfigHandler("1.5.2.5");
        version = new VersionHandler("CoFH Core", "1.5.2.5", "https://dl.dropboxusercontent.com/u/57416963/Minecraft/Mods/CoFHCore/version.txt");
        log.setParent(FMLLog.getLogger());
    }
}

