/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class NEIServerUtils {
    public static boolean isRaining(aab world) {
        return world.M().p();
    }

    public static void toggleRaining(aab world, boolean notify) {
        boolean raining;
        boolean bl = raining = !world.P();
        if (!raining) {
            ((iz)world).t.resetRainAndThunder();
        } else {
            world.A();
        }
        if (notify) {
            ServerUtils.sendChatToAll((String)("Rain turned " + (raining ? "on" : "off")));
        }
    }

    public static void healPlayer(sq player) {
        player.j(20);
        player.cn().a(20, 1.0f);
        player.A();
    }

    public static long getTime(aab world) {
        return world.M().g();
    }

    public static void setTime(long l, aab world) {
        world.M().c(l);
    }

    public static void setSlotContents(sq player, int slot, wm item, boolean containerInv) {
        if (slot == -999) {
            player.bK.b(item);
        } else if (containerInv) {
            player.bM.a(slot, item);
        } else {
            player.bK.a(slot, item);
        }
    }

    public static void deleteAllItems(jc player) {
        int i = 0;
        while (i < player.bM.c.size()) {
            ((ul)player.bM.c.get(i)).c(null);
            ++i;
        }
        player.a(player.bM, player.bM.a());
    }

    public static void setHourForward(aab world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((String)("Day " + NEIServerUtils.getTime(world) / 24000L + ". " + hour + ":00"));
        }
    }

    public static void advanceDisabledTimes(aab world) {
        int hour;
        int dim = CommonUtils.getDimension((aab)world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (true) {
            int zone = newhour / 6;
            try {
                if (!NEIServerConfig.isPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(zone))) break;
                newhour = (zone + 1) % 4 * 6;
            }
            catch (NumberFormatException nfe) {
                String s = "Time: " + NEIServerUtils.getTime(world) + ", Hour: " + hour + ", NewHour: " + newhour + ", Zone: " + zone + ", Map: " + AllowedPropertyMap.idToNameMap.toString();
                ServerUtils.mc().i(s);
                throw nfe;
            }
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(sq player, wm itemstack) {
        int i = 0;
        while (i < player.bK.j_() - 4) {
            if (player.bK.a(i) == null) {
                return true;
            }
            ++i;
        }
        if (!itemstack.i()) {
            if (itemstack.e() == 1) {
                return false;
            }
            i = 0;
            while (i < player.bK.j_()) {
                wm invstack = player.bK.a(i);
                if (invstack != null && invstack.c == itemstack.c && invstack.f() && invstack.a < invstack.e() && invstack.a < player.bK.d() && (!invstack.h() || invstack.k() == itemstack.k())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static int getSlotForStack(tj c, int firstSlot, int lastSlot, wm item) {
        ul slot;
        int slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            int filled;
            slot = c.a(slotIndex);
            if (slot.d() && item.f() && (filled = slot.c().a) < slot.a() && filled < item.e() && NEIServerUtils.areStacksSameType(slot.c(), item)) {
                return slotIndex;
            }
            ++slotIndex;
        }
        slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            slot = c.a(slotIndex);
            if (!slot.d()) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    public static int getSlotForStack(lt inv, int firstSlot, int lastSlot, wm item) {
        int slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            int filled;
            wm slotStack = inv.a(slotIndex);
            if (slotStack != null && item.f() && (filled = slotStack.a) < inv.d() && filled < item.e() && NEIServerUtils.areStacksSameType(slotStack, item)) {
                return slotIndex;
            }
            ++slotIndex;
        }
        slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            if (inv.a(slotIndex) == null) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    public static void sendNotice(String s, String permission) {
        NEIServerUtils.sendNotice(s, permission, -1);
    }

    public static void sendNotice(String s, String permission, int colour) {
        if (NEIServerConfig.canPlayerUseFeature("CONSOLE", permission)) {
            Logger.getLogger("Minecraft").info(s.replaceAll("\u00a7.", ""));
        }
        for (jc player : ServerUtils.mc().ad().a) {
            if (!NEIServerConfig.canPlayerUseFeature(player.bS, permission)) continue;
            ServerUtils.sendChatTo((jc)player, (String)s);
        }
    }

    public static boolean areStacksSameType(wm stack1, wm stack2) {
        return InventoryUtils.canStack((wm)stack1, (wm)stack2);
    }

    public static boolean areStacksSameTypeCrafting(wm stack1, wm stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.k() == stack2.k() || stack1.k() == -1 || stack2.k() == -1 || stack1.b().o());
    }

    public static int compareStacks(wm stack1, wm stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.c != stack2.c) {
            return stack1.c - stack2.c;
        }
        if (stack1.a != stack2.a) {
            return stack1.a - stack2.a;
        }
        return stack1.k() - stack2.k();
    }

    public static boolean areStacksIdentical(wm stack1, wm stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static void givePlayerItem(jc player, wm stack, boolean infinite, LinkedList name, boolean doGive) {
        if (stack.b() == null) {
            player.a.b((ei)new cw("\u00a7fNo such item."));
            return;
        }
        StringBuilder namebuilder = new StringBuilder();
        boolean first = true;
        for (String string : name) {
            if (!first) {
                namebuilder.append(" ");
            }
            namebuilder.append(string.trim());
            first = false;
        }
        String itemname = namebuilder.toString();
        int given = 0;
        if (!doGive) {
            given = stack.a;
        } else if (infinite) {
            player.bK.a(stack);
        } else {
            int increment = stack.e();
            given = 0;
            while (given < stack.a) {
                int qty = Math.min(stack.a - given, increment);
                int slotNo = NEIServerUtils.getSlotForStack((lt)player.bK, 0, 36, stack);
                if (slotNo == -1) break;
                wm slotStack = player.bK.a(slotNo);
                int current = slotStack != null ? slotStack.a : 0;
                qty = Math.min(qty, player.bK.d() - current);
                player.bK.a(slotNo, NEIServerUtils.copyStack(stack, qty + current));
                given += qty;
            }
        }
        if (infinite) {
            NEIServerUtils.sendNotice("Giving " + player.bS + " infinite " + "\u00a7f" + itemname, "notify-item");
        } else {
            NEIServerUtils.sendNotice("Giving " + player.bS + " " + given + " of " + "\u00a7f" + itemname, "notify-item");
        }
        player.bM.b();
    }

    public static wm copyStack(wm itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.a += i;
        return itemstack.a(i);
    }

    public static wm copyStack(wm itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.a);
    }

    public static boolean isMagnetMode(jc player) {
        return NEIServerConfig.forPlayer(player.bS).getMagnetMode();
    }

    public static void toggleMagnetMode(jc player) {
        PlayerSave playerSave;
        playerSave.setMagnetMode(!(playerSave = NEIServerConfig.forPlayer(player.bS)).getMagnetMode());
        NEISPH.sendMagnetModeTo(player, playerSave.getMagnetMode());
    }

    public static int getCreativeMode(jc player) {
        if (NEIServerConfig.forPlayer(player.bS).getCreativeInv()) {
            return 2;
        }
        if (player.c.d()) {
            return 1;
        }
        return 0;
    }

    public static void toggleCreativeMode(jc player) {
        int mode = (NEIServerUtils.getCreativeMode(player) + 1) % 3;
        player.c.a(mode == 0 ? aaj.b : aaj.c);
        NEIServerConfig.forPlayer(player.bS).setCreativeInv(mode == 2);
        NEISPH.sendCreativeModeTo(player, mode);
    }

    public static void cycleCreativeInv(jc player, int steps) {
        int col;
        int col2;
        so inventory = player.bK;
        wm[][] slots = new wm[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.bS);
        int hotbar = 0;
        while (hotbar < 9) {
            slots[9][hotbar] = inventory.a[hotbar];
            ++hotbar;
        }
        int row = 0;
        while (row < 3) {
            col2 = 0;
            while (col2 < 9) {
                slots[row + 6][col2] = inventory.a[(row + 1) * 9 + col2];
                ++col2;
            }
            ++row;
        }
        row = 0;
        while (row < 6) {
            col2 = 0;
            while (col2 < 9) {
                slots[row][col2] = playerSave.creativeInv[row * 9 + col2];
                ++col2;
            }
            ++row;
        }
        wm[][] newslots = new wm[10][];
        int row2 = 0;
        while (row2 < 10) {
            newslots[(row2 + steps + 10) % 10] = slots[row2];
            ++row2;
        }
        int hotbar2 = 0;
        while (hotbar2 < 9) {
            inventory.a[hotbar2] = newslots[9][hotbar2];
            ++hotbar2;
        }
        row2 = 0;
        while (row2 < 3) {
            col = 0;
            while (col < 9) {
                inventory.a[(row2 + 1) * 9 + col] = newslots[row2 + 6][col];
                ++col;
            }
            ++row2;
        }
        row2 = 0;
        while (row2 < 6) {
            col = 0;
            while (col < 9) {
                playerSave.creativeInv[row2 * 9 + col] = newslots[row2][col];
                ++col;
            }
            ++row2;
        }
        playerSave.setDirty();
    }

    public static List getEnchantments(wm itemstack) {
        ca nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.r()) != null) {
            int i = 0;
            while (i < nbttaglist.c()) {
                short word0 = ((bs)nbttaglist.b(i)).d("id");
                short word1 = ((bs)nbttaglist.b(i)).d("lvl");
                int[] ai = new int[]{word0, word1};
                arraylist.add(ai);
                ++i;
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(wm itemstack, int e) {
        List allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(wm itemstack, int e) {
        List allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List enchantments, yz e) {
        for (int[] ai : enchantments) {
            if (e.a(yz.b[ai[0]])) continue;
            return true;
        }
        return false;
    }
}

