/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeEssentials.client.util;

import com.ForgeEssentials.client.util.IReconstructData;
import com.ForgeEssentials.client.util.SaveableObject;
import java.io.Serializable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;

@SaveableObject(SaveInline=true)
public class ClientPoint
implements Serializable,
Comparable {
    private static final long serialVersionUID = 3003472204175937036L;
    @SaveableObject.SaveableField
    public double x;
    @SaveableObject.SaveableField
    public double y;
    @SaveableObject.SaveableField
    public double z;

    public ClientPoint(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ClientPoint(EntityPlayer player) {
        this.x = player.field_70165_t;
        this.y = player.field_70163_u;
        this.z = player.field_70161_v;
    }

    public ClientPoint(ChunkCoordinates coords) {
        this.x = coords.field_71574_a;
        this.y = coords.field_71572_b;
        this.z = coords.field_71573_c;
    }

    public int getX() {
        return (int)Math.floor(this.x);
    }

    public int getY() {
        return (int)Math.floor(this.y);
    }

    public int getZ() {
        return (int)Math.floor(this.z);
    }

    public int compareTo(ClientPoint point) {
        if (this.equals(point)) {
            return 0;
        }
        int positives = 0;
        int negatives = 0;
        if (this.x > point.x) {
            ++positives;
        } else {
            ++negatives;
        }
        if (this.y > point.y) {
            ++positives;
        } else {
            ++negatives;
        }
        if (this.z > point.z) {
            ++positives;
        } else {
            ++negatives;
        }
        if (positives > negatives) {
            return 1;
        }
        if (negatives > positives) {
            return -1;
        }
        return (int)(this.x - point.x + (this.y - point.y) + (this.z - point.z));
    }

    public boolean equals(Object object) {
        return object instanceof ClientPoint && this.x == ((ClientPoint)object).x && this.y == ((ClientPoint)object).y && this.z == ((ClientPoint)object).z;
    }

    public double getDistanceTo(ClientPoint point) {
        return Math.sqrt((this.x - point.x) * (this.x - point.x) + (this.y - point.y) * (this.y - point.y) + (this.z - point.z) * (this.z - point.z));
    }

    public boolean alignsWith(ClientPoint p) {
        return this.getX() == p.getX() || this.getY() == p.getY() || this.getZ() == p.getZ();
    }

    public ClientPoint copy(ClientPoint point) {
        return new ClientPoint(point.x, point.y, point.z);
    }

    public static ClientPoint validate(ClientPoint point) {
        if (point.y < 0.0) {
            return new ClientPoint(point.x, 0.0, point.z);
        }
        return point;
    }

    @SaveableObject.Reconstructor
    public static ClientPoint reconstruct(IReconstructData tag) {
        float x = ((Float)tag.getFieldValue("x")).floatValue();
        float y = ((Float)tag.getFieldValue("y")).floatValue();
        float z = ((Float)tag.getFieldValue("z")).floatValue();
        return new ClientPoint(x, y, z);
    }

    @SaveableObject.UniqueLoadingKey
    private String getLoadingField() {
        return "point_" + this.x + "_" + this.y + "_" + this.z;
    }

    public String toString() {
        return "[" + this.x + ";" + this.y + ";" + this.z + "]";
    }
}

